/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hardcodedPasswords.checkers;

import com.intellij.hardcodedPasswords.checkers.PasswordChecker;
import com.intellij.hardcodedPasswords.result.EntropyResult;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0007H\u0002J\f\u0010\f\u001a\u00020\u0005*\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/hardcodedPasswords/checkers/HighEntropyChecker;", "Lcom/intellij/hardcodedPasswords/checkers/PasswordChecker;", "Lcom/intellij/hardcodedPasswords/result/EntropyResult;", "()V", "bigramEntropy", "", "str", "", "check", "string", "isTokenHighEntropy", "", "calculateEntropyUnogramm", "Companion", "NGramIterator", "intellij.hardcodedPasswords"})
@SourceDebugExtension(value={"SMAP\nHighEntropyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighEntropyChecker.kt\ncom/intellij/hardcodedPasswords/checkers/HighEntropyChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,60:1\n1536#2:61\n1#3:62\n1099#4,3:63\n1099#4,3:66\n1099#4,3:69\n1099#4,3:72\n*S KotlinDebug\n*F\n+ 1 HighEntropyChecker.kt\ncom/intellij/hardcodedPasswords/checkers/HighEntropyChecker\n*L\n30#1:61\n56#1:63,3\n57#1:66,3\n58#1:69,3\n59#1:72,3\n*E\n"})
public final class HighEntropyChecker
implements PasswordChecker<EntropyResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int VERY_HIGH_ENTROPY_THRESHOLD = 100;
    public static final int THRESHOLD_UNOGRAMM = 24;
    public static final double THRESHOLD_BIGRAMM = 2.3;
    public static final int PER_CHAR_THRESHOLD = 3;

    @Override
    @NotNull
    public EntropyResult check(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        double entropy = this.bigramEntropy(string);
        boolean result = entropy >= 2.3 && this.isTokenHighEntropy(string);
        return new EntropyResult(result, entropy);
    }

    private final boolean isTokenHighEntropy(String string) {
        double entropy = this.calculateEntropyUnogramm(string);
        double entropyPerChar = entropy / (double)string.length();
        return entropy >= 24.0 || entropy / (double)2 >= 24.0 && entropyPerChar >= 3.0;
    }

    private final double bigramEntropy(String str) {
        if (str.length() < 2) {
            return 0.0;
        }
        List bigrams = SequencesKt.toList((Sequence)new NGramIterator(2, str));
        Iterable $this$groupingBy$iv = bigrams;
        boolean $i$f$groupingBy = false;
        Map bigramFrequencies = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<String, String>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            @NotNull
            public Iterator<String> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                String it = (String)element;
                boolean bl = false;
                return var2_2;
            }
        }));
        int totalBigrams = str.length() - 1;
        Iterable iterable = bigramFrequencies.entrySet();
        double d = 0.0;
        for (Object t : iterable) {
            Map.Entry entry = (Map.Entry)t;
            double d2 = d;
            boolean bl = false;
            int count = ((Number)entry.getValue()).intValue();
            double probability = (double)count / (double)totalBigrams;
            double d3 = -probability * MathKt.log2((double)probability);
            d = d2 + d3;
        }
        return d;
    }

    private final double calculateEntropyUnogramm(String $this$calculateEntropyUnogramm) {
        char it;
        char element$iv;
        int n;
        CharSequence $this$count$iv = $this$calculateEntropyUnogramm;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (n = 0; n < $this$count$iv.length(); ++n) {
            it = element$iv = $this$count$iv.charAt(n);
            boolean bl = false;
            if (!Character.isLowerCase(it)) continue;
            ++count$iv;
        }
        $this$count$iv = $this$calculateEntropyUnogramm;
        double d = (double)count$iv * MathKt.log2((double)26.0);
        $i$f$count = false;
        count$iv = 0;
        for (n = 0; n < $this$count$iv.length(); ++n) {
            it = element$iv = $this$count$iv.charAt(n);
            boolean bl = false;
            if (!Character.isUpperCase(it)) continue;
            ++count$iv;
        }
        int n2 = count$iv;
        $this$count$iv = $this$calculateEntropyUnogramm;
        d += (double)n2 * MathKt.log2((double)26.0);
        $i$f$count = false;
        count$iv = 0;
        for (n = 0; n < $this$count$iv.length(); ++n) {
            it = element$iv = $this$count$iv.charAt(n);
            boolean bl = false;
            if (!Character.isDigit(it)) continue;
            ++count$iv;
        }
        n2 = count$iv;
        $this$count$iv = $this$calculateEntropyUnogramm;
        d += (double)n2 * MathKt.log2((double)10.0);
        $i$f$count = false;
        count$iv = 0;
        for (n = 0; n < $this$count$iv.length(); ++n) {
            it = element$iv = $this$count$iv.charAt(n);
            boolean bl = false;
            boolean bl2 = !Character.isLetterOrDigit(it);
            if (!bl2) continue;
            ++count$iv;
        }
        n2 = count$iv;
        return d + (double)n2 * MathKt.log2((double)32.0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/hardcodedPasswords/checkers/HighEntropyChecker$Companion;", "", "()V", "PER_CHAR_THRESHOLD", "", "THRESHOLD_BIGRAMM", "", "THRESHOLD_UNOGRAMM", "VERY_HIGH_ENTROPY_THRESHOLD", "intellij.hardcodedPasswords"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\t\u0010\t\u001a\u00020\nH\u0096\u0002J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0096\u0002J\t\u0010\f\u001a\u00020\u0002H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/hardcodedPasswords/checkers/HighEntropyChecker$NGramIterator;", "", "", "Lkotlin/sequences/Sequence;", "n", "", "str", "(ILjava/lang/String;)V", "pos", "hasNext", "", "iterator", "next", "intellij.hardcodedPasswords"})
    public static final class NGramIterator
    implements Iterator<String>,
    Sequence<String>,
    KMappedMarker {
        private final int n;
        @NotNull
        private final String str;
        private int pos;

        public NGramIterator(int n, @NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            this.n = n;
            this.str = str;
        }

        @NotNull
        public Iterator<String> iterator() {
            return new NGramIterator(this.n, this.str);
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.str.length() - this.n + 1;
        }

        @Override
        @NotNull
        public String next() {
            StringBuilder sb = new StringBuilder();
            int n = this.pos + this.n;
            for (int i = this.pos; i < n; ++i) {
                sb.append(this.str.charAt(i));
            }
            int n2 = this.pos;
            this.pos = n2 + 1;
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

