/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tailwind.settings;

import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.typescript.lsp.JSExternalDefinitionsNodeDescriptor;
import com.intellij.lang.typescript.lsp.JSExternalDefinitionsPackageResolver;
import com.intellij.lang.typescript.lsp.LspServerDownloaderKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.platform.lsp.api.LspServerManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.tailwind.TailwindCssBundle;
import com.intellij.tailwind.lsp.TailwindLspServerSupportProvider;
import com.intellij.tailwind.settings.TailwindConfigurable;
import com.intellij.tailwind.settings.TailwindSettings;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.HyperlinkEventAction;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.util.ui.JBDimension;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/tailwind/settings/TailwindConfigurable;", "Lcom/intellij/openapi/options/Configurable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "currentLspConfiguration", "", "getCurrentLspConfiguration", "()Ljava/lang/String;", "lspConfigurationEditor", "Lcom/intellij/openapi/editor/Editor;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "apply", "", "createComponent", "Ljavax/swing/JComponent;", "disposeUIResources", "getDisplayName", "getHelpTopic", "isModified", "", "reset", "intellij.tailwindcss"})
public final class TailwindConfigurable
implements Configurable {
    @NotNull
    private final Project project;
    private DialogPanel panel;
    private Editor lspConfigurationEditor;

    public TailwindConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final String getCurrentLspConfiguration() {
        Editor editor = this.lspConfigurationEditor;
        if (editor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lspConfigurationEditor");
            editor = null;
        }
        String string = editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    @NotNull
    public String getDisplayName() {
        String string = TailwindCssBundle.message("settings.page.tailwind", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getHelpTopic() {
        return "configurable.tailwindcss";
    }

    @NotNull
    public JComponent createComponent() {
        JSExternalDefinitionsNodeDescriptor serverDescriptor = new JSExternalDefinitionsNodeDescriptor(TailwindSettings.Companion.getDefaultLspPackage());
        NodePackageField lspPackageField = new NodePackageField(this.project, (NodePackageDescriptor)serverDescriptor, () -> TailwindConfigurable.createComponent$lambda$0(this), (NodePackageRefResolver)new JSExternalDefinitionsPackageResolver(this.project, (NodePackageDescriptor)serverDescriptor));
        PsiFile jsonFile = PsiFileFactory.getInstance((Project)this.project).createFileFromText("dummy.json", (Language)JsonLanguage.INSTANCE, (CharSequence)"", true, false);
        Document jsonDocument = PsiDocumentManager.getInstance((Project)this.project).getDocument(jsonFile);
        Editor editor = TemplateEditorUtil.createEditor((boolean)false, (Document)jsonDocument, (Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"createEditor(...)");
        this.lspConfigurationEditor = editor;
        Editor editor2 = this.lspConfigurationEditor;
        if (editor2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lspConfigurationEditor");
            editor2 = null;
        }
        editor2.getSettings().setAdditionalLinesCount(0);
        Editor editor3 = this.lspConfigurationEditor;
        if (editor3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lspConfigurationEditor");
            editor3 = null;
        }
        editor3.getComponent().setPreferredSize((Dimension)new JBDimension(200, 100));
        this.panel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(lspPackageField, this){
            final /* synthetic */ NodePackageField $lspPackageField;
            final /* synthetic */ TailwindConfigurable this$0;
            {
                this.$lspPackageField = $lspPackageField;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string = TailwindCssBundle.message("settings.page.lsp.server.path.label", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$panel.row(string, (Function1)new Function1<Row, Unit>(this.$lspPackageField, this.this$0){
                    final /* synthetic */ NodePackageField $lspPackageField;
                    final /* synthetic */ TailwindConfigurable this$0;
                    {
                        this.$lspPackageField = $lspPackageField;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        LspServerDownloaderKt.bind((Cell)$this$row.cell((JComponent)this.$lspPackageField).align((Align)AlignX.FILL.INSTANCE), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(TailwindSettings.Companion.getInstance(TailwindConfigurable.access$getProject$p(this.this$0))){

                            @Nullable
                            public Object get() {
                                return ((TailwindSettings)this.receiver).getLspServerPackageRef();
                            }

                            public void set(@Nullable Object value) {
                                ((TailwindSettings)this.receiver).setLspServerPackageRef((NodePackageRef)value);
                            }
                        }));
                    }
                });
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ TailwindConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = TailwindCssBundle.message("settings.page.configuration.label", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        $this$row.label(string).resizableColumn();
                        String string2 = TailwindCssBundle.message("settings.page.restore.default.configuration.link", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        Row.comment$default((Row)$this$row, (String)string2, (int)0, arg_0 -> createComponent.2.invoke$lambda$1(this.this$0, arg_0), (int)2, null).align((Align)AlignY.BOTTOM.INSTANCE).visibleIf(new ComponentPredicate(this.this$0){
                            final /* synthetic */ TailwindConfigurable this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public void addListener(@NotNull Function1<? super Boolean, Unit> listener) {
                                Intrinsics.checkNotNullParameter(listener, (String)"listener");
                                Editor editor = TailwindConfigurable.access$getLspConfigurationEditor$p(this.this$0);
                                if (editor == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"lspConfigurationEditor");
                                    editor = null;
                                }
                                editor.getDocument().addDocumentListener(new DocumentListener(listener, this.this$0){
                                    final /* synthetic */ Function1<Boolean, Unit> $listener;
                                    final /* synthetic */ TailwindConfigurable this$0;
                                    {
                                        this.$listener = $listener;
                                        this.this$0 = $receiver;
                                    }

                                    public void documentChanged(@NotNull DocumentEvent event) {
                                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                                        this.$listener.invoke((Object)(!Intrinsics.areEqual((Object)TailwindConfigurable.access$getCurrentLspConfiguration(this.this$0), (Object)TailwindSettings.DEFAULT_CONFIGURATION) ? 1 : 0));
                                    }
                                });
                            }

                            @NotNull
                            public Boolean invoke() {
                                return !Intrinsics.areEqual((Object)TailwindConfigurable.access$getCurrentLspConfiguration(this.this$0), (Object)TailwindSettings.DEFAULT_CONFIGURATION);
                            }
                        });
                        String string3 = TailwindCssBundle.message("settings.page.available.options.comment", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                        Row.comment$default((Row)$this$row, (String)string3, (int)0, (HyperlinkEventAction)HyperlinkEventAction.HTML_HYPERLINK_INSTANCE, (int)2, null);
                    }

                    private static final void invoke$lambda$1$lambda$0(TailwindConfigurable this$0) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Editor editor = TailwindConfigurable.access$getLspConfigurationEditor$p(this$0);
                        if (editor == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"lspConfigurationEditor");
                            editor = null;
                        }
                        editor.getDocument().setText((CharSequence)TailwindSettings.DEFAULT_CONFIGURATION);
                    }

                    private static final void invoke$lambda$1(TailwindConfigurable this$0, HyperlinkEvent it) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        WriteAction.run(() -> createComponent.2.invoke$lambda$1$lambda$0(this$0));
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ TailwindConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Editor editor = TailwindConfigurable.access$getLspConfigurationEditor$p(this.this$0);
                        if (editor == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"lspConfigurationEditor");
                            editor = null;
                        }
                        $this$row.cell(editor.getComponent()).align(Align.FILL);
                    }
                }), (int)1, null).resizableRow();
            }
        }));
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        return (JComponent)dialogPanel;
    }

    public void reset() {
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        dialogPanel.reset();
        WriteAction.run(() -> TailwindConfigurable.reset$lambda$1(this));
    }

    public boolean isModified() {
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        return dialogPanel.isModified() || !Intrinsics.areEqual((Object)TailwindSettings.Companion.getInstance(this.project).getLspConfiguration(), (Object)this.getCurrentLspConfiguration());
    }

    public void apply() {
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        dialogPanel.apply();
        TailwindSettings.Companion.getInstance(this.project).setLspConfiguration(this.getCurrentLspConfiguration());
        if (!this.project.isDefault()) {
            LspServerManager.Companion.getInstance(this.project).stopAndRestartIfNeeded(TailwindLspServerSupportProvider.class);
        }
    }

    public void disposeUIResources() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Editor editor = this.lspConfigurationEditor;
        if (editor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lspConfigurationEditor");
            editor = null;
        }
        editorFactory.releaseEditor(editor);
    }

    private static final NodeJsInterpreter createComponent$lambda$0(TailwindConfigurable this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return NodeJsInterpreterManager.getInstance((Project)this$0.project).getInterpreter();
    }

    private static final void reset$lambda$1(TailwindConfigurable this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Editor editor = this$0.lspConfigurationEditor;
        if (editor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lspConfigurationEditor");
            editor = null;
        }
        editor.getDocument().setText((CharSequence)TailwindSettings.Companion.getInstance(this$0.project).getLspConfiguration());
    }

    public static final /* synthetic */ Project access$getProject$p(TailwindConfigurable $this) {
        return $this.project;
    }

    public static final /* synthetic */ Editor access$getLspConfigurationEditor$p(TailwindConfigurable $this) {
        return $this.lspConfigurationEditor;
    }

    public static final /* synthetic */ String access$getCurrentLspConfiguration(TailwindConfigurable $this) {
        return $this.getCurrentLspConfiguration();
    }
}

