/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tailwind.lsp;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.options.Configurable;
import com.intellij.platform.lang.lsWidget.LanguageServicePopupSection;
import com.intellij.platform.lang.lsWidget.LanguageServiceWidgetItem;
import com.intellij.platform.lang.lsWidget.OpenSettingsAction;
import com.intellij.tailwind.TailwindCssBundle;
import com.intellij.tailwind.settings.TailwindConfigurable;
import icons.TailwindcssIcons;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B*\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0014R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u0016\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/tailwind/lsp/TailwindProblemWidgetItem;", "Lcom/intellij/platform/lang/lsWidget/LanguageServiceWidgetItem;", "problemText", "", "Lorg/jetbrains/annotations/Nls;", "widgetActionLocation", "Lcom/intellij/platform/lang/lsWidget/LanguageServicePopupSection;", "problemPageClass", "Ljava/lang/Class;", "Lcom/intellij/openapi/options/Configurable;", "(Ljava/lang/String;Lcom/intellij/platform/lang/lsWidget/LanguageServicePopupSection;Ljava/lang/Class;)V", "isError", "", "()Z", "statusBarIcon", "Ljavax/swing/Icon;", "getStatusBarIcon", "()Ljavax/swing/Icon;", "statusBarTooltip", "getStatusBarTooltip", "()Ljava/lang/String;", "getWidgetActionLocation", "()Lcom/intellij/platform/lang/lsWidget/LanguageServicePopupSection;", "createWidgetInlineActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "createWidgetMainAction", "intellij.tailwindcss"})
public final class TailwindProblemWidgetItem
extends LanguageServiceWidgetItem {
    @NotNull
    private final String problemText;
    @NotNull
    private final LanguageServicePopupSection widgetActionLocation;
    @NotNull
    private final Class<? extends Configurable> problemPageClass;
    @NotNull
    private final Icon statusBarIcon;
    @NotNull
    private final String statusBarTooltip;
    private final boolean isError;

    public TailwindProblemWidgetItem(@NotNull String problemText, @NotNull LanguageServicePopupSection widgetActionLocation, @NotNull Class<? extends Configurable> problemPageClass) {
        Intrinsics.checkNotNullParameter((Object)problemText, (String)"problemText");
        Intrinsics.checkNotNullParameter((Object)widgetActionLocation, (String)"widgetActionLocation");
        Intrinsics.checkNotNullParameter(problemPageClass, (String)"problemPageClass");
        this.problemText = problemText;
        this.widgetActionLocation = widgetActionLocation;
        this.problemPageClass = problemPageClass;
        Icon icon = TailwindcssIcons.Tailwind_16;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Tailwind_16");
        this.statusBarIcon = icon;
        String string = TailwindCssBundle.message("settings.page.tailwind", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.statusBarTooltip = string;
        this.isError = true;
    }

    @NotNull
    public LanguageServicePopupSection getWidgetActionLocation() {
        return this.widgetActionLocation;
    }

    @NotNull
    public Icon getStatusBarIcon() {
        return this.statusBarIcon;
    }

    @NotNull
    public String getStatusBarTooltip() {
        return this.statusBarTooltip;
    }

    public boolean isError() {
        return this.isError;
    }

    @NotNull
    protected AnAction createWidgetMainAction() {
        String string = TailwindCssBundle.message("settings.page.tailwind", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Icon icon = TailwindcssIcons.Tailwind_16;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Tailwind_16");
        return (AnAction)new OpenSettingsAction(TailwindConfigurable.class, string, icon);
    }

    @NotNull
    protected List<AnAction> createWidgetInlineActions() {
        Object[] objectArray = new OpenSettingsAction[2];
        Icon icon = AllIcons.General.Error;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Error");
        objectArray[0] = new OpenSettingsAction(this.problemPageClass, this.problemText, icon);
        objectArray[1] = new OpenSettingsAction(TailwindConfigurable.class, null, null, 6, null);
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

