/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.ruby.correctness;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.lang.Language;
import com.intellij.ml.inline.completion.features.correctness.EnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.SuggestionEnricherBase;
import com.intellij.ml.inline.completion.ruby.correctness.RubyDuplicateDeclarationsChecker;
import com.intellij.ml.inline.completion.ruby.correctness.RubyInspectionBasedChecker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.inspections.argcount.RubyArgCountInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.jumpError.RubyJumpErrorInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.resolve.InvalidCallToProtectedPrivateMethodInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.resolve.RubyResolveInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.supercall.RubySuperCallWithoutSuperclassInspection;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/inline/completion/ruby/correctness/RubySuggestionEnricher;", "Lcom/intellij/ml/inline/completion/features/correctness/SuggestionEnricherBase;", "()V", "buildFileWithSuggestion", "Lcom/intellij/psi/PsiFile;", "originalFile", "suggestionOffset", "", "suggestion", "", "suffix", "matchedEnclosuresIndices", "", "intellij.ml.inline.completion.ruby"})
@SourceDebugExtension(value={"SMAP\nRubySuggestionEnricher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubySuggestionEnricher.kt\ncom/intellij/ml/inline/completion/ruby/correctness/RubySuggestionEnricher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class RubySuggestionEnricher
extends SuggestionEnricherBase {
    public RubySuggestionEnricher() {
        RubyResolveInspection rubyResolveInspection;
        Object[] objectArray = new EnrichmentTool[6];
        objectArray[0] = new RubyInspectionBasedChecker((LocalInspectionTool)new RubyJumpErrorInspection());
        objectArray[1] = new RubyInspectionBasedChecker((LocalInspectionTool)new RubyArgCountInspection());
        objectArray[2] = new RubyInspectionBasedChecker((LocalInspectionTool)new InvalidCallToProtectedPrivateMethodInspection());
        objectArray[3] = new RubyInspectionBasedChecker((LocalInspectionTool)new RubySuperCallWithoutSuperclassInspection());
        RubyResolveInspection rubyResolveInspection2 = rubyResolveInspection = new RubyResolveInspection();
        int n = 4;
        Object[] objectArray2 = objectArray;
        RubySuggestionEnricher rubySuggestionEnricher = this;
        boolean bl = false;
        it.warnImplicitResults = true;
        Unit unit = Unit.INSTANCE;
        LocalInspectionTool localInspectionTool = (LocalInspectionTool)rubyResolveInspection;
        objectArray2[n] = new RubyInspectionBasedChecker(localInspectionTool);
        objectArray[5] = new RubyDuplicateDeclarationsChecker();
        super(CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    @NotNull
    protected PsiFile buildFileWithSuggestion(@NotNull PsiFile originalFile, int suggestionOffset, @NotNull String suggestion, @NotNull String suffix, @Nullable Set<Integer> matchedEnclosuresIndices) {
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Set<Integer> set = matchedEnclosuresIndices;
        int matchedSize = set != null ? set.size() : 0;
        String it = originalFile.getText();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        String text2 = StringsKt.take((String)it, (int)suggestionOffset) + suggestion + " " + StringsKt.drop((String)it, (int)(suggestionOffset + matchedSize));
        PsiFileFactory psiFileFactory = PsiFileFactoryImpl.getInstance((Project)originalFile.getProject());
        Intrinsics.checkNotNull((Object)psiFileFactory, (String)"null cannot be cast to non-null type com.intellij.psi.impl.PsiFileFactoryImpl");
        PsiFileFactoryImpl factory = (PsiFileFactoryImpl)psiFileFactory;
        PsiFile mockFile = factory.createFileFromText(originalFile.getName(), (Language)RubyLanguage.INSTANCE, (CharSequence)text2, true, true, false, PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)originalFile)));
        PsiFileImpl psiFileImpl = mockFile instanceof PsiFileImpl ? (PsiFileImpl)mockFile : null;
        if (psiFileImpl != null) {
            psiFileImpl.setOriginalFile(originalFile);
        }
        Intrinsics.checkNotNull((Object)mockFile);
        return mockFile;
    }
}

