/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.js;

import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.inline.completion.suggestion.InlineCompletionQuoteHandlerEx;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\u0010\u001a\u00020\n*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/inline/completion/js/JSInlineCompletionQuoteHandlerEx;", "Lcom/intellij/codeInsight/inline/completion/suggestion/InlineCompletionQuoteHandlerEx;", "()V", "getClosingQuoteRange", "Lcom/intellij/openapi/util/TextRange;", "documentText", "", "iterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "offset", "", "quoteHandler", "Lcom/intellij/codeInsight/editorActions/QuoteHandler;", "getOpeningQuoteRange", "isBackquoteOpening", "", "indexOfLast", "startOffset", "endOffset", "char", "", "intellij.ml.inline.completion.js"})
public final class JSInlineCompletionQuoteHandlerEx
implements InlineCompletionQuoteHandlerEx {
    @Nullable
    public TextRange getOpeningQuoteRange(@NotNull String documentText, @NotNull HighlighterIterator iterator, int offset2, @NotNull QuoteHandler quoteHandler) {
        Intrinsics.checkNotNullParameter((Object)documentText, (String)"documentText");
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        Intrinsics.checkNotNullParameter((Object)quoteHandler, (String)"quoteHandler");
        if (iterator.atEnd()) {
            return null;
        }
        IElementType iElementType = iterator.getTokenType();
        return Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.STRING_TEMPLATE_PART) ? null : (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.BACKQUOTE) ? (offset2 == iterator.getStart() && this.isBackquoteOpening(iterator, quoteHandler) ? new TextRange(iterator.getStart(), iterator.getEnd()) : null) : (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.REGEXP_LITERAL) ? (offset2 == iterator.getStart() ? new TextRange(offset2, offset2 + 1) : null) : super.getOpeningQuoteRange(documentText, iterator, offset2, quoteHandler)));
    }

    @Nullable
    public TextRange getClosingQuoteRange(@NotNull String documentText, @NotNull HighlighterIterator iterator, int offset2, @NotNull QuoteHandler quoteHandler) {
        int indexOfSlash;
        Intrinsics.checkNotNullParameter((Object)documentText, (String)"documentText");
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        Intrinsics.checkNotNullParameter((Object)quoteHandler, (String)"quoteHandler");
        if (iterator.atEnd()) {
            return null;
        }
        IElementType iElementType = iterator.getTokenType();
        Object object = Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.STRING_TEMPLATE_PART) ? null : (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.BACKQUOTE) ? (offset2 == iterator.getStart() && !this.isBackquoteOpening(iterator, quoteHandler) ? new TextRange(iterator.getStart(), iterator.getEnd()) : null) : (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.REGEXP_LITERAL) ? (documentText.charAt(offset2) == '/' && offset2 > iterator.getStart() ? (offset2 == (indexOfSlash = this.indexOfLast(documentText, iterator.getStart(), iterator.getEnd(), '/')) ? new TextRange(offset2, offset2 + 1) : null) : null) : super.getClosingQuoteRange(documentText, iterator, offset2, quoteHandler)));
        return object;
    }

    private final boolean isBackquoteOpening(HighlighterIterator iterator, QuoteHandler quoteHandler) {
        iterator.advance();
        boolean success = !iterator.atEnd() && (quoteHandler.isInsideLiteral(iterator) || Intrinsics.areEqual((Object)iterator.getTokenType(), (Object)JSTokenTypes.DOLLAR));
        iterator.retreat();
        return success;
    }

    private final int indexOfLast(String $this$indexOfLast, int startOffset, int endOffset, char c) {
        int i = endOffset - 1;
        if (startOffset <= i) {
            while (true) {
                if ($this$indexOfLast.charAt(i) == c) {
                    return i;
                }
                if (i == startOffset) break;
                --i;
            }
        }
        return -1;
    }
}

