/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl;

import com.intellij.lang.Language;
import com.intellij.ml.inline.completion.impl.MLCompletionParameters;
import com.intellij.ml.inline.completion.impl.diagnostic.DiagnosticLoggersKt;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionDiagnosticsService;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionSessionLogger;
import com.intellij.ml.inline.completion.impl.id.CompletionId;
import com.intellij.ml.inline.completion.impl.id.CompletionIdFactory;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionLanguageKit;
import com.intellij.ml.inline.completion.impl.postprocessing.MLCompletionPipelineConfiguration;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/inline/completion/impl/MLCompletionRequest;", "T", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "", "languageKit", "parameters", "Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;", "language", "Lcom/intellij/lang/Language;", "(Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;Lcom/intellij/lang/Language;)V", "completionId", "Lcom/intellij/ml/inline/completion/impl/id/CompletionId;", "getCompletionId", "()Lcom/intellij/ml/inline/completion/impl/id/CompletionId;", "getLanguage", "()Lcom/intellij/lang/Language;", "getLanguageKit", "()Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "getParameters", "()Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;", "pipelineConfiguration", "Lcom/intellij/ml/inline/completion/impl/postprocessing/MLCompletionPipelineConfiguration;", "getPipelineConfiguration", "()Lcom/intellij/ml/inline/completion/impl/postprocessing/MLCompletionPipelineConfiguration;", "pipelineConfiguration$delegate", "Lkotlin/Lazy;", "sessionLogger", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionSessionLogger;", "getSessionLogger", "()Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionSessionLogger;", "intellij.ml.inline.completion"})
public abstract class MLCompletionRequest<T extends MLCompletionLanguageKit> {
    @NotNull
    private final T languageKit;
    @NotNull
    private final MLCompletionParameters parameters;
    @NotNull
    private final Language language;
    @NotNull
    private final Lazy pipelineConfiguration$delegate;
    @NotNull
    private final CompletionId completionId;
    @NotNull
    private final MLCompletionSessionLogger sessionLogger;

    public MLCompletionRequest(@NotNull T languageKit, @NotNull MLCompletionParameters parameters, @NotNull Language language) {
        Intrinsics.checkNotNullParameter(languageKit, (String)"languageKit");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.languageKit = languageKit;
        this.parameters = parameters;
        this.language = language;
        this.pipelineConfiguration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MLCompletionPipelineConfiguration>(this){
            final /* synthetic */ MLCompletionRequest<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MLCompletionPipelineConfiguration invoke() {
                return this.this$0.getLanguageKit().getPipelineConfigurator().configure(this.this$0.getParameters());
            }
        }));
        this.completionId = CompletionIdFactory.INSTANCE.getNext();
        this.sessionLogger = DiagnosticLoggersKt.toSessionLogger(MLCompletionDiagnosticsService.logger$default(MLCompletionDiagnosticsService.Companion.getInstance(), null, 1, null), this.completionId);
    }

    @NotNull
    public final T getLanguageKit() {
        return this.languageKit;
    }

    @NotNull
    public final MLCompletionParameters getParameters() {
        return this.parameters;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @NotNull
    public final MLCompletionPipelineConfiguration getPipelineConfiguration() {
        Lazy lazy = this.pipelineConfiguration$delegate;
        return (MLCompletionPipelineConfiguration)lazy.getValue();
    }

    @NotNull
    public final CompletionId getCompletionId() {
        return this.completionId;
    }

    @NotNull
    public final MLCompletionSessionLogger getSessionLogger() {
        return this.sessionLogger;
    }
}

