/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import git4idea.config.GitExecutableListener;
import git4idea.config.GitExecutableManager;
import git4idea.repo.GitConfigKey;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ/\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\nH\u0016R(\u0010\u0003\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lgit4idea/repo/GitConfigurationCacheBase;", "Lcom/intellij/openapi/Disposable;", "()V", "cache", "", "Lgit4idea/repo/GitConfigKey;", "Ljava/util/concurrent/CompletableFuture;", "getCache", "()Ljava/util/Map;", "clearCache", "", "computeCachedValue", "T", "configKey", "computeValue", "Lkotlin/Function0;", "(Lgit4idea/repo/GitConfigKey;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "dispose", "intellij.vcs.git"})
public abstract class GitConfigurationCacheBase
implements Disposable {
    @NotNull
    private final Map<GitConfigKey<?>, CompletableFuture<?>> cache;

    public GitConfigurationCacheBase() {
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.cache = concurrentMap;
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic<GitExecutableListener> topic = GitExecutableManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        connection.subscribe(topic, () -> GitConfigurationCacheBase._init_$lambda$0(this));
    }

    @NotNull
    protected final Map<GitConfigKey<?>, CompletableFuture<?>> getCache() {
        return this.cache;
    }

    @RequiresBackgroundThread
    public final <T> T computeCachedValue(@NotNull GitConfigKey<T> configKey, @NotNull Function0<? extends T> computeValue) {
        Intrinsics.checkNotNullParameter(configKey, (String)"configKey");
        Intrinsics.checkNotNullParameter(computeValue, (String)"computeValue");
        CompletableFuture<Object> future2 = new CompletableFuture<Object>();
        CompletableFuture oldFuture = this.cache.putIfAbsent(configKey, future2);
        if (oldFuture != null) {
            try {
                return oldFuture.get();
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable == null) {
                    throwable = e;
                }
                throw throwable;
            }
            catch (CancellationException e) {
                if (oldFuture.isCancelled()) {
                    ProgressManager.checkCanceled();
                    return (T)computeValue.invoke();
                }
                throw e;
            }
        }
        try {
            Object result2 = computeValue.invoke();
            future2.complete(result2);
            return (T)result2;
        }
        catch (ProcessCanceledException e) {
            this.cache.remove(configKey, future2);
            future2.cancel(true);
            throw e;
        }
        catch (Throwable e) {
            future2.completeExceptionally(e);
            throw e;
        }
    }

    public final void clearCache() {
        this.cache.clear();
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(GitConfigurationCacheBase this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.clearCache();
    }
}

