/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import git4idea.branch.GitRebaseParams;
import git4idea.config.GitVersion;
import git4idea.history.GitHistoryTraverser;
import git4idea.history.GitHistoryTraverserImpl;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseUtils;
import git4idea.rebase.GitSquashedCommitsMessage;
import git4idea.rebase.interactive.CantRebaseUsingLogException;
import git4idea.rebase.interactive.GitInteractiveRebaseUsingLogEditorHandler;
import git4idea.rebase.interactive.GitRebaseEntryGeneratedUsingLog;
import git4idea.rebase.interactive.dialog.GitInteractiveRebaseDialog;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0001\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a$\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getEntriesUsingLog", "", "Lgit4idea/rebase/interactive/GitRebaseEntryGeneratedUsingLog;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "interactivelyRebaseUsingLog", "", "startInteractiveRebase", "editorHandler", "Lgit4idea/rebase/GitRebaseEditorHandler;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitInteractiveRebaseUsingLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitInteractiveRebaseUsingLog.kt\ngit4idea/rebase/interactive/GitInteractiveRebaseUsingLogKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1747#2,3:162\n1549#2:165\n1620#2,3:166\n*S KotlinDebug\n*F\n+ 1 GitInteractiveRebaseUsingLog.kt\ngit4idea/rebase/interactive/GitInteractiveRebaseUsingLogKt\n*L\n56#1:162,3\n60#1:165\n60#1:166,3\n*E\n"})
public final class GitInteractiveRebaseUsingLogKt {
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final List<GitRebaseEntryGeneratedUsingLog> getEntriesUsingLog(@NotNull GitRepository repository, @NotNull VcsShortCommitDetails commit, @NotNull VcsLogData logData) throws CantRebaseUsingLogException {
        void $this$mapTo$iv$iv;
        boolean bl;
        List details;
        block8: {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            Project project = repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            GitHistoryTraverser traverser = new GitHistoryTraverserImpl(project, logData);
            details = new ArrayList();
            try {
                VirtualFile virtualFile = repository.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                GitHistoryTraverser.traverse$default(traverser, virtualFile, null, null, (Function2)new Function2<GitHistoryTraverser.Traverse, GitHistoryTraverser.TraverseCommitInfo, Boolean>(traverser, commit, (List<VcsCommitMetadata>)details){
                    final /* synthetic */ GitHistoryTraverser $traverser;
                    final /* synthetic */ VcsShortCommitDetails $commit;
                    final /* synthetic */ List<VcsCommitMetadata> $details;
                    {
                        this.$traverser = $traverser;
                        this.$commit = $commit;
                        this.$details = $details;
                        super(2);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull GitHistoryTraverser.Traverse $this$traverse, @NotNull GitHistoryTraverser.TraverseCommitInfo traverseCommitInfo) {
                        Hash hash;
                        Intrinsics.checkNotNullParameter((Object)$this$traverse, (String)"$this$traverse");
                        Intrinsics.checkNotNullParameter((Object)traverseCommitInfo, (String)"<name for destructuring parameter 0>");
                        int commitId = traverseCommitInfo.component1();
                        List<Integer> parents = traverseCommitInfo.component2();
                        if (parents.size() == 1) {
                            $this$traverse.loadMetadataLater(commitId, (Function1<? super VcsCommitMetadata, Unit>)((Function1)new Function1<VcsCommitMetadata, Unit>(this.$details){
                                final /* synthetic */ List<VcsCommitMetadata> $details;
                                {
                                    this.$details = $details;
                                    super(1);
                                }

                                public final void invoke(@NotNull VcsCommitMetadata metadata) {
                                    Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                                    this.$details.add(metadata);
                                }
                            }));
                            hash = this.$traverser.toHash(commitId);
                        } else {
                            throw new CantRebaseUsingLogException(CantRebaseUsingLogException.Reason.MERGE);
                        }
                        return !Intrinsics.areEqual((Object)hash, (Object)this.$commit.getId());
                    }
                }, 6, null);
            }
            catch (VcsException e) {
                throw new CantRebaseUsingLogException(CantRebaseUsingLogException.Reason.UNRESOLVED_HASH);
            }
            if (!Intrinsics.areEqual((Object)((VcsCommitMetadata)CollectionsKt.last((List)details)).getId(), (Object)commit.getId())) {
                throw new CantRebaseUsingLogException(CantRebaseUsingLogException.Reason.UNEXPECTED_HASH);
            }
            Iterable $this$any$iv = details;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VcsCommitMetadata detail = (VcsCommitMetadata)element$iv;
                    boolean bl2 = false;
                    String string = detail.getSubject();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSubject(...)");
                    if (!GitSquashedCommitsMessage.INSTANCE.isAutosquashCommitMessage(string)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new CantRebaseUsingLogException(CantRebaseUsingLogException.Reason.FIXUP_SQUASH);
        }
        Iterable $this$map$iv = details;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(new GitRebaseEntryGeneratedUsingLog((VcsCommitMetadata)it));
        }
        return CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
    }

    public static final void interactivelyRebaseUsingLog(@NotNull GitRepository repository, @NotNull VcsShortCommitDetails commit, @NotNull VcsLogData logData) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Project project = repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        VirtualFile root = virtualFile;
        String string = GitBundle.message("rebase.progress.indicator.preparing.title", new Object[0]);
        new Task.Backgroundable(project2, repository, commit, logData, root, string){
            @Nullable
            private List<GitRebaseEntryGeneratedUsingLog> generatedEntries;
            final /* synthetic */ Project $project;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ VcsShortCommitDetails $commit;
            final /* synthetic */ VcsLogData $logData;
            final /* synthetic */ VirtualFile $root;
            {
                this.$project = $project;
                this.$repository = $repository;
                this.$commit = $commit;
                this.$logData = $logData;
                this.$root = $root;
                super($project, $super_call_param$1);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    this.generatedEntries = GitInteractiveRebaseUsingLogKt.getEntriesUsingLog(this.$repository, this.$commit, this.$logData);
                }
                catch (CantRebaseUsingLogException e) {
                    GitInteractiveRebaseUsingLogKt.access$getLOG$p().warn("Couldn't use log for rebasing: " + e.getMessage());
                }
            }

            public void onSuccess() {
                block3: {
                    Unit unit;
                    List<GitRebaseEntryGeneratedUsingLog> list2 = this.generatedEntries;
                    if (list2 != null) {
                        List<GitRebaseEntryGeneratedUsingLog> list3 = list2;
                        Project project = this.$project;
                        VirtualFile virtualFile = this.$root;
                        GitRepository gitRepository = this.$repository;
                        VcsShortCommitDetails vcsShortCommitDetails = this.$commit;
                        List<GitRebaseEntryGeneratedUsingLog> entries = list3;
                        boolean bl = false;
                        GitInteractiveRebaseDialog<GitRebaseEntryGeneratedUsingLog> dialog = new GitInteractiveRebaseDialog<GitRebaseEntryGeneratedUsingLog>(project, virtualFile, entries);
                        dialog.show();
                        if (dialog.isOK()) {
                            GitInteractiveRebaseUsingLogKt.startInteractiveRebase(gitRepository, vcsShortCommitDetails, new GitInteractiveRebaseUsingLogEditorHandler(gitRepository, entries, dialog.getModel()));
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit != null) break block3;
                    GitInteractiveRebaseUsingLogKt.startInteractiveRebase$default(this.$repository, this.$commit, null, 4, null);
                }
            }
        }.queue();
    }

    public static final void startInteractiveRebase(@NotNull GitRepository repository, @NotNull VcsShortCommitDetails commit, @Nullable GitRebaseEditorHandler editorHandler) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        Project project = repository.getProject();
        String string = GitBundle.message("rebase.progress.indicator.title", new Object[0]);
        new Task.Backgroundable(repository, commit, editorHandler, project, string){
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ VcsShortCommitDetails $commit;
            final /* synthetic */ GitRebaseEditorHandler $editorHandler;
            {
                this.$repository = $repository;
                this.$commit = $commit;
                this.$editorHandler = $editorHandler;
                super($super_call_param$1, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GitVersion gitVersion = this.$repository.getVcs().getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)gitVersion, (String)"getVersion(...)");
                List list2 = this.$commit.getParents();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getParents(...)");
                String string = ((Hash)CollectionsKt.first((List)list2)).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                GitRebaseParams params = GitRebaseParams.Companion.editCommits$default(GitRebaseParams.Companion, gitVersion, string, this.$editorHandler, false, null, 16, null);
                GitRebaseUtils.rebase(this.$repository.getProject(), CollectionsKt.listOf((Object)this.$repository), params, indicator);
            }
        }.queue();
    }

    public static /* synthetic */ void startInteractiveRebase$default(GitRepository gitRepository, VcsShortCommitDetails vcsShortCommitDetails, GitRebaseEditorHandler gitRebaseEditorHandler, int n, Object object) {
        if ((n & 4) != 0) {
            gitRebaseEditorHandler = null;
        }
        GitInteractiveRebaseUsingLogKt.startInteractiveRebase(gitRepository, vcsShortCommitDetails, gitRebaseEditorHandler);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance((String)"Git.Interactive.Rebase.Using.Log");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

