/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsScopeKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.LogDataImpl;
import git4idea.GitCommit;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitFullDetailsCollector;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.InternedGitLogRecordBuilder;
import git4idea.log.GitLogProvider;
import git4idea.log.GitRefManager;
import git4idea.telemetry.GitTelemetrySpan;
import io.opentelemetry.api.trace.Tracer;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class GitLogUtil {
    private static final Logger LOG = Logger.getInstance(GitLogUtil.class);
    public static final String GRAFTED = "grafted";
    public static final String REPLACED = "replaced";
    public static final List<String> LOG_ALL = List.of("HEAD", "--branches", "--remotes", "--tags");
    public static final String STDIN = "--stdin";
    static final GitLogParser.GitLogOption[] COMMIT_METADATA_OPTIONS = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY};

    public static void readTimedCommits(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> parameters, @Nullable java.util.function.Consumer<? super VcsUser> userConsumer, @Nullable java.util.function.Consumer<? super VcsRef> refConsumer, @NotNull java.util.function.Consumer<? super TimedVcsCommit> commitConsumer) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(2);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(3);
        }
        GitLogUtil.readTimedCommits(project, root, Collections.emptyList(), parameters, userConsumer, refConsumer, commitConsumer);
    }

    public static void readTimedCommits(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> configParameters, @NotNull List<String> parameters, @Nullable java.util.function.Consumer<? super VcsUser> userConsumer, @Nullable java.util.function.Consumer<? super VcsRef> refConsumer, @NotNull java.util.function.Consumer<? super TimedVcsCommit> commitConsumer) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(4);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(5);
        }
        if (configParameters == null) {
            GitLogUtil.$$$reportNull$$$0(6);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(7);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(8);
        }
        GitLogUtil.readTimedCommits(project, root, configParameters, parameters, Collections.emptyList(), userConsumer, refConsumer, commitConsumer);
    }

    public static void readTimedCommits(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> configParameters, @NotNull List<String> parameters, @NotNull List<FilePath> filePaths, @Nullable java.util.function.Consumer<? super VcsUser> userConsumer, @Nullable java.util.function.Consumer<? super VcsRef> refConsumer, @NotNull java.util.function.Consumer<? super TimedVcsCommit> commitConsumer) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(9);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(10);
        }
        if (configParameters == null) {
            GitLogUtil.$$$reportNull$$$0(11);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(12);
        }
        if (filePaths == null) {
            GitLogUtil.$$$reportNull$$$0(13);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(14);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            return;
        }
        GitLineHandler handler = GitLogUtil.createGitHandler(project, root, configParameters, false);
        ArrayList<GitLogParser.GitLogOption> options = new ArrayList<GitLogParser.GitLogOption>(Arrays.asList(GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME));
        if (userConsumer != null) {
            options.add(GitLogParser.GitLogOption.AUTHOR_NAME);
            options.add(GitLogParser.GitLogOption.AUTHOR_EMAIL);
        }
        if (refConsumer != null) {
            options.add(GitLogParser.GitLogOption.REF_NAMES);
        }
        GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, options.toArray(new GitLogParser.GitLogOption[0]));
        handler.setStdoutSuppressed(true);
        handler.addParameters(parser.getPretty(), "--encoding=UTF-8");
        handler.addParameters("--decorate=full");
        if (parameters.contains("--")) {
            int index = parameters.indexOf("--");
            handler.addParameters(parameters.subList(0, index));
            handler.endOptions();
            handler.addParameters(parameters.subList(index + 1, parameters.size()));
        } else {
            handler.addParameters(parameters);
            handler.endOptions();
        }
        handler.addRelativePaths(filePaths);
        GitLogOutputSplitter<GitLogRecord> handlerListener = new GitLogOutputSplitter<GitLogRecord>(handler, parser, record -> {
            Hash hash = HashImpl.build((String)record.getHash());
            List parents = ContainerUtil.map((Object[])record.getParentsHashes(), arg_0 -> ((VcsLogObjectsFactory)factory).createHash(arg_0));
            commitConsumer.accept(factory.createTimedCommit(hash, parents, record.getCommitTime()));
            if (refConsumer != null) {
                for (VcsRef ref : GitLogUtil.parseRefs(record.getRefs(), hash, factory, root)) {
                    refConsumer.accept(ref);
                }
            }
            if (userConsumer != null) {
                userConsumer.accept(factory.createUser(record.getAuthorName(), record.getAuthorEmail()));
            }
        });
        Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
        handlerListener.reportErrors();
    }

    @NotNull
    public static List<? extends VcsCommitMetadata> collectMetadata(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> hashes2) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(15);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(16);
        }
        if (hashes2 == null) {
            GitLogUtil.$$$reportNull$$$0(17);
        }
        CollectConsumer collectConsumer = new CollectConsumer();
        GitLogUtil.collectMetadata(project, root, hashes2, (java.util.function.Consumer<? super VcsCommitMetadata>)collectConsumer);
        return new ArrayList(collectConsumer.getResult());
    }

    public static void collectMetadata(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> hashes2, @NotNull java.util.function.Consumer<? super VcsCommitMetadata> consumer2) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(18);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(19);
        }
        if (hashes2 == null) {
            GitLogUtil.$$$reportNull$$$0(20);
        }
        if (consumer2 == null) {
            GitLogUtil.$$$reportNull$$$0(21);
        }
        if (hashes2.isEmpty()) {
            return;
        }
        VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return;
        }
        GitLineHandler h = GitLogUtil.createGitHandler(project, root);
        GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, COMMIT_METADATA_OPTIONS);
        h.setSilent(true);
        h.addParameters(GitLogUtil.getNoWalkParameter(project));
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(STDIN);
        h.endOptions();
        GitLogUtil.sendHashesToStdin(hashes2, h);
        GitLogOutputSplitter<GitLogRecord> outputHandler = new GitLogOutputSplitter<GitLogRecord>(h, parser, record -> {
            SmartList parents = new SmartList();
            for (String parent : record.getParentsHashes()) {
                parents.add(HashImpl.build((String)parent));
            }
            record.setUsedHandler(h);
            consumer2.accept(factory.createCommitMetadata(HashImpl.build((String)record.getHash()), (List)parents, record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getFullMessage(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp()));
        });
        Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
        outputHandler.reportErrors();
    }

    @NotNull
    public static VcsLogProvider.DetailedLogData collectMetadata(@NotNull Project project, @NotNull VirtualFile root, String ... params) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(22);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(23);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            if (logDataImpl == null) {
                GitLogUtil.$$$reportNull$$$0(24);
            }
            return logDataImpl;
        }
        ObjectOpenCustomHashSet refs = new ObjectOpenCustomHashSet(GitLogProvider.DONT_CONSIDER_SHA);
        ArrayList commits2 = new ArrayList();
        java.util.function.Consumer<GitLogRecord> recordConsumer = arg_0 -> GitLogUtil.lambda$collectMetadata$3(root, factory, commits2, (Set)refs, arg_0);
        try {
            GitLineHandler handler = GitLogUtil.createGitHandler(project, root, Collections.emptyList(), false);
            GitLogParser.GitLogOption[] options = (GitLogParser.GitLogOption[])ArrayUtil.append((Object[])COMMIT_METADATA_OPTIONS, (Object)((Object)GitLogParser.GitLogOption.REF_NAMES));
            GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, options);
            handler.setStdoutSuppressed(true);
            handler.addParameters(params);
            handler.addParameters(parser.getPretty(), "--encoding=UTF-8");
            handler.addParameters("--decorate=full");
            handler.endOptions();
            TraceUtil.runWithSpanThrows((Tracer)TelemetryManager.getInstance().getTracer(VcsScopeKt.VcsScope), (String)GitTelemetrySpan.Log.LoadingCommitMetadata.getName(), span -> {
                span.setAttribute("rootName", root.getName());
                GitLogOutputSplitter handlerListener = new GitLogOutputSplitter(handler, parser, recordConsumer);
                Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
                handlerListener.reportErrors();
            });
        }
        catch (VcsException e) {
            if (commits2.isEmpty()) {
                throw e;
            }
            LOG.warn("Error during loading details, returning partially loaded commits\n", (Throwable)e);
        }
        return new LogDataImpl((Set)refs, commits2);
    }

    public static void readFullDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull java.util.function.Consumer<? super GitCommit> commitConsumer, String ... parameters) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(25);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(26);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(27);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(28);
        }
        new GitFullDetailsCollector(project, root, new InternedGitLogRecordBuilder()).readFullDetails(commitConsumer, GitCommitRequirements.DEFAULT, false, parameters);
    }

    public static void readFullDetailsForHashes(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> hashes2, @NotNull GitCommitRequirements requirements, @NotNull Consumer<? super GitCommit> commitConsumer) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(29);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(30);
        }
        if (hashes2 == null) {
            GitLogUtil.$$$reportNull$$$0(31);
        }
        if (requirements == null) {
            GitLogUtil.$$$reportNull$$$0(32);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(33);
        }
        if (hashes2.isEmpty()) {
            return;
        }
        new GitFullDetailsCollector(project, root, new InternedGitLogRecordBuilder()).readFullDetailsForHashes(hashes2, requirements, false, arg_0 -> commitConsumer.consume(arg_0));
    }

    @NotNull
    private static Collection<VcsRef> parseRefs(@NotNull Collection<String> refs, @NotNull Hash hash, @NotNull VcsLogObjectsFactory factory, @NotNull VirtualFile root) {
        if (refs == null) {
            GitLogUtil.$$$reportNull$$$0(34);
        }
        if (hash == null) {
            GitLogUtil.$$$reportNull$$$0(35);
        }
        if (factory == null) {
            GitLogUtil.$$$reportNull$$$0(36);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(37);
        }
        List list2 = ContainerUtil.mapNotNull(refs, refName -> {
            if (refName.equals(GRAFTED) || refName.equals(REPLACED)) {
                return null;
            }
            VcsRefType type = GitRefManager.getRefType(refName);
            return (refName = GitBranchUtil.stripRefsPrefix(refName)).equals("origin/HEAD") ? null : factory.createRef(hash, refName, type, root);
        });
        if (list2 == null) {
            GitLogUtil.$$$reportNull$$$0(38);
        }
        return list2;
    }

    @Nullable
    public static VcsLogObjectsFactory getObjectsFactoryWithDisposeCheck(@NotNull Project project) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(39);
        }
        return (VcsLogObjectsFactory)ReadAction.compute(() -> {
            if (!project.isDisposed()) {
                return (VcsLogObjectsFactory)project.getService(VcsLogObjectsFactory.class);
            }
            return null;
        });
    }

    @NotNull
    static VcsCommitMetadata createMetadata(@NotNull VirtualFile root, @NotNull GitLogRecord record, @NotNull VcsLogObjectsFactory factory) {
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(40);
        }
        if (record == null) {
            GitLogUtil.$$$reportNull$$$0(41);
        }
        if (factory == null) {
            GitLogUtil.$$$reportNull$$$0(42);
        }
        List parents = ContainerUtil.map((Object[])record.getParentsHashes(), arg_0 -> ((VcsLogObjectsFactory)factory).createHash(arg_0));
        VcsCommitMetadata vcsCommitMetadata = factory.createCommitMetadata(factory.createHash(record.getHash()), parents, record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getFullMessage(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp());
        if (vcsCommitMetadata == null) {
            GitLogUtil.$$$reportNull$$$0(43);
        }
        return vcsCommitMetadata;
    }

    public static void sendHashesToStdin(@NotNull Collection<String> hashes2, @NotNull GitHandler handler) {
        if (hashes2 == null) {
            GitLogUtil.$$$reportNull$$$0(44);
        }
        if (handler == null) {
            GitLogUtil.$$$reportNull$$$0(45);
        }
        handler.setInputProcessor(GitHandlerInputProcessorUtil.writeLines(hashes2, "\n", handler.getCharset(), true));
    }

    @NotNull
    public static String getNoWalkParameter(@NotNull Project project) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(46);
        }
        return GitVersionSpecialty.NO_WALK_UNSORTED.existsIn(project) ? "--no-walk=unsorted" : "--no-walk";
    }

    @NotNull
    public static GitLineHandler createGitHandler(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(47);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(48);
        }
        return GitLogUtil.createGitHandler(project, root, Collections.emptyList(), false);
    }

    @NotNull
    static GitLineHandler createGitHandler(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> configParameters, boolean lowPriorityProcess) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(49);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(50);
        }
        if (configParameters == null) {
            GitLogUtil.$$$reportNull$$$0(51);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.LOG, configParameters);
        if (lowPriorityProcess) {
            handler.withLowPriority();
        }
        handler.setWithMediator(false);
        GitLineHandler gitLineHandler = handler;
        if (gitLineHandler == null) {
            GitLogUtil.$$$reportNull$$$0(52);
        }
        return gitLineHandler;
    }

    public static long parseTime(@NotNull String timeString) {
        if (timeString == null) {
            GitLogUtil.$$$reportNull$$$0(53);
        }
        return Long.parseLong(timeString.trim()) * 1000L;
    }

    private static /* synthetic */ void lambda$collectMetadata$3(VirtualFile root, VcsLogObjectsFactory factory, List commits2, Set refs, GitLogRecord record) {
        VcsCommitMetadata commit = GitLogUtil.createMetadata(root, record, factory);
        commits2.add(commit);
        Collection<VcsRef> refsInRecord = GitLogUtil.parseRefs(record.getRefs(), (Hash)commit.getId(), factory, root);
        for (VcsRef ref : refsInRecord) {
            if (refs.add(ref)) continue;
            VcsRef otherRef = (VcsRef)ContainerUtil.find((Iterable)refs, r -> GitLogProvider.DONT_CONSIDER_SHA.equals(r, (Object)ref));
            LOG.error("Adding duplicate element " + ref + " to the set containing " + otherRef);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 24, 38, 43, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 16: 
            case 19: 
            case 23: 
            case 26: 
            case 30: 
            case 37: 
            case 40: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitConsumer";
                break;
            }
            case 6: 
            case 11: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configParameters";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 17: 
            case 20: 
            case 31: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 24: 
            case 38: 
            case 43: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitLogUtil";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitLogUtil";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMetadata";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRefs";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createMetadata";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createGitHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readTimedCommits";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectMetadata";
                break;
            }
            case 24: 
            case 38: 
            case 43: 
            case 52: {
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "readFullDetails";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "readFullDetailsForHashes";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "parseRefs";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsFactoryWithDisposeCheck";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createMetadata";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "sendHashesToStdin";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getNoWalkParameter";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createGitHandler";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "parseTime";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 24, 38, 43, 52 -> new IllegalStateException(string);
        };
    }
}

