/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.UnsupportedHistoryFiltersException;
import com.intellij.vcs.log.VcsLogBranchLikeFilter;
import com.intellij.vcs.log.VcsLogFileHistoryHandler;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcs.log.visible.CommitCountStageKt;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.history.DefaultGitLogFullRecordBuilder;
import git4idea.history.GitFileHistory;
import git4idea.history.GitHistoryProvider;
import git4idea.history.GitLogFullRecord;
import git4idea.history.GitLogHistoryHandler;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import git4idea.i18n.GitBundle;
import git4idea.log.GitLogProvider;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 %2\u00020\u0001:\u0002%&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u000f0\u0019H\u0016J\u001a\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0004JF\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u000f0\u0019H\u0016J*\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0015H\u0016J,\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\"\u0010$\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\u0005\u001a0\u0012,\u0012*\u0012\u000e\b\u0001\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0014\u0012\u000e\b\u0001\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006'"}, d2={"Lgit4idea/history/GitLogHistoryHandler;", "Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "supportedFilters", "", "Lcom/intellij/vcs/log/VcsLogFilterCollection$FilterKey;", "Lcom/intellij/vcs/log/VcsLogBranchLikeFilter;", "kotlin.jvm.PlatformType", "supportedVcs", "Lcom/intellij/openapi/vcs/VcsKey;", "getSupportedVcs", "()Lcom/intellij/openapi/vcs/VcsKey;", "collectHistory", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "hash", "Lcom/intellij/vcs/log/Hash;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "consumer", "Lkotlin/Function1;", "Lcom/intellij/openapi/vcs/history/VcsFileRevision;", "getDefaultFilters", "getHistoryFast", "commitCount", "", "getRename", "Lcom/intellij/vcs/log/VcsLogFileHistoryHandler$Rename;", "beforeHash", "afterHash", "getSupportedFilters", "throwIfFiltersNotSupported", "Companion", "RenamesCollector", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitLogHistoryHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLogHistoryHandler.kt\ngit4idea/history/GitLogHistoryHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1#2:156\n1726#3,3:157\n*S KotlinDebug\n*F\n+ 1 GitLogHistoryHandler.kt\ngit4idea/history/GitLogHistoryHandler\n*L\n49#1:157,3\n*E\n"})
public class GitLogHistoryHandler
implements VcsLogFileHistoryHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VcsKey supportedVcs;
    @NotNull
    private final Set<VcsLogFilterCollection.FilterKey<? extends VcsLogBranchLikeFilter>> supportedFilters;
    @NotNull
    private static final Logger LOG;

    public GitLogHistoryHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        VcsKey vcsKey = GitVcs.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)vcsKey, (String)"getKey(...)");
        this.supportedVcs = vcsKey;
        Object[] objectArray = new VcsLogFilterCollection.FilterKey[]{VcsLogFilterCollection.BRANCH_FILTER, VcsLogFilterCollection.REVISION_FILTER};
        this.supportedFilters = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        return this.supportedVcs;
    }

    @NotNull
    public Set<VcsLogFilterCollection.FilterKey<?>> getSupportedFilters(@NotNull VirtualFile root, @NotNull FilePath filePath, @Nullable Hash hash) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (hash != null) {
            return SetsKt.emptySet();
        }
        return this.supportedFilters;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected final VcsLogFilterCollection getDefaultFilters(@NotNull VirtualFile root, @Nullable Hash hash) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        v0 = var3_3 = new VcsLogFilter[1];
        v1 = 0;
        v2 = hash;
        if (v2 == null) ** GOTO lbl-1000
        var4_4 = v2;
        var7_5 = v1;
        var6_6 = v0;
        $i$a$-let-GitLogHistoryHandler$getDefaultFilters$1 = false;
        var8_8 = VcsLogFilterObject.fromCommit((CommitId)new CommitId((Hash)it, root));
        v0 = var6_6;
        v1 = var7_5;
        v3 = var8_8;
        v2 = v3;
        if (v3 != null) {
            v4 = (VcsLogBranchLikeFilter)v2;
        } else lbl-1000:
        // 2 sources

        {
            v4 = (VcsLogBranchLikeFilter)VcsLogFilterObject.fromBranch((String)"HEAD");
        }
        v0[v1] = v4;
        return VcsLogFilterObject.collection((VcsLogFilter[])var3_3);
    }

    private final void throwIfFiltersNotSupported(VirtualFile root, Hash hash, VcsLogFilterCollection filters) throws UnsupportedHistoryFiltersException {
        String string;
        if (hash == null) {
            boolean bl;
            block8: {
                Iterable $this$all$iv = VcsLogFiltersKt.getKeysToSet((VcsLogFilterCollection)filters);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        VcsLogFilterCollection.FilterKey it = (VcsLogFilterCollection.FilterKey)element$iv;
                        boolean bl2 = false;
                        if (CollectionsKt.contains((Iterable)this.supportedFilters, (Object)it)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
        }
        if (Intrinsics.areEqual((Object)filters, (Object)this.getDefaultFilters(root, hash))) {
            return;
        }
        Collection collection = filters.getFilters();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFilters(...)");
        String presentation2 = CollectionsKt.joinToString$default((Iterable)collection, null, null, null, (int)0, null, (Function1)throwIfFiltersNotSupported.presentation.1.INSTANCE, (int)31, null);
        if (hash == null) {
            var7_8 = new Object[]{presentation2};
            string = GitBundle.message("history.filters.unsupported.error.message", var7_8);
        } else {
            var7_8 = new Object[]{presentation2};
            string = GitBundle.message("history.for.revision.filters.unsupported.error.message", var7_8);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        Object message = string2;
        throw new UnsupportedHistoryFiltersException((String)message);
    }

    public void getHistoryFast(@NotNull VirtualFile root, @NotNull FilePath filePath, @Nullable Hash hash, @NotNull VcsLogFilterCollection filters, int commitCount, @NotNull Function1<? super VcsFileRevision, Unit> consumer2) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        this.throwIfFiltersNotSupported(root, hash, filters);
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForRoot(root);
        if (gitRepository == null) {
            return;
        }
        GitRepository repository = gitRepository;
        GitLogParser<GitLogFullRecord> parser = GitFileHistory.Companion.createLogParser$intellij_vcs_git(this.project);
        GitLineHandler handler = new GitLineHandler(this.project, root, GitCommand.LOG);
        handler.setStdoutSuppressed(true);
        String[] stringArray = new String[]{"--name-status", parser.getPretty(), "--encoding=UTF-8"};
        handler.addParameters(stringArray);
        if (!CommitCountStageKt.isAll((int)commitCount)) {
            stringArray = new String[]{"--max-count=" + commitCount};
            handler.addParameters(stringArray);
        }
        handler.addParameters(GitLogProvider.getBranchLikeFilterParameters(repository, filters, null));
        handler.endOptions();
        stringArray = new FilePath[]{filePath};
        handler.addRelativePaths((FilePath[])stringArray);
        GitLogOutputSplitter<Object> splitter2 = new GitLogOutputSplitter<Object>(handler, parser, arg_0 -> GitLogHistoryHandler.getHistoryFast$lambda$2((Function1)new Function1<GitLogFullRecord, Unit>(consumer2, this, root, filePath){
            final /* synthetic */ Function1<VcsFileRevision, Unit> $consumer;
            final /* synthetic */ GitLogHistoryHandler this$0;
            final /* synthetic */ VirtualFile $root;
            final /* synthetic */ FilePath $filePath;
            {
                this.$consumer = $consumer;
                this.this$0 = $receiver;
                this.$root = $root;
                this.$filePath = $filePath;
                super(1);
            }

            public final void invoke(GitLogFullRecord record) {
                Project project = GitLogHistoryHandler.access$getProject$p(this.this$0);
                Intrinsics.checkNotNull((Object)record);
                this.$consumer.invoke((Object)GitFileHistory.Companion.createGitFileRevision$intellij_vcs_git(project, this.$root, record, this.$filePath));
            }
        }, arg_0));
        Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
        splitter2.reportErrors();
    }

    public void collectHistory(@NotNull VirtualFile root, @NotNull FilePath filePath, @Nullable Hash hash, @NotNull VcsLogFilterCollection filters, @NotNull Function1<? super VcsFileRevision, Unit> consumer2) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        this.throwIfFiltersNotSupported(root, hash, filters);
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForRoot(root);
        if (gitRepository == null) {
            return;
        }
        GitRepository repository = gitRepository;
        String[] stringArray = GitHistoryProvider.getHistoryLimitArgs(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getHistoryLimitArgs(...)");
        String[] args = stringArray;
        List<String> startingRevisions = GitLogProvider.getBranchLikeFilterParameters(repository, filters, null);
        Intrinsics.checkNotNull(startingRevisions);
        new GitFileHistory(this.project, root, filePath, startingRevisions, true).load$intellij_vcs_git(consumer2, Arrays.copyOf(args, args.length));
    }

    @Nullable
    public VcsLogFileHistoryHandler.Rename getRename(@NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull Hash beforeHash, @NotNull Hash afterHash) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)beforeHash, (String)"beforeHash");
        Intrinsics.checkNotNullParameter((Object)afterHash, (String)"afterHash");
        String string = beforeHash.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String string2 = afterHash.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        VcsFileStatusInfo vcsFileStatusInfo = Companion.getRename$intellij_vcs_git(this.project, root, string, string2, filePath);
        if (vcsFileStatusInfo == null) {
            return null;
        }
        VcsFileStatusInfo info = vcsFileStatusInfo;
        FilePath filePath2 = VcsUtil.getFilePath((String)(root.getPath() + "/" + info.getFirstPath()), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)filePath2, (String)"getFilePath(...)");
        FilePath firstPath = filePath2;
        FilePath filePath3 = VcsUtil.getFilePath((String)(root.getPath() + "/" + info.getSecondPath()), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)filePath3, (String)"getFilePath(...)");
        FilePath secondPath = filePath3;
        return new VcsLogFileHistoryHandler.Rename(firstPath, secondPath, beforeHash, afterHash);
    }

    private static final void getHistoryFast$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(GitLogHistoryHandler $this) {
        return $this.project;
    }

    static {
        Logger logger = Logger.getInstance(GitLogHistoryHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000b\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u000b\u0010\u000f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgit4idea/history/GitLogHistoryHandler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getRename", "Lcom/intellij/vcs/log/impl/VcsFileStatusInfo;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "beforeHash", "", "Lcom/intellij/openapi/util/NlsSafe;", "afterHash", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "getRename$intellij_vcs_git", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VcsFileStatusInfo getRename$intellij_vcs_git(@NotNull Project project, @NotNull VirtualFile root, @NotNull String beforeHash, @NotNull String afterHash, @NotNull FilePath filePath) throws VcsException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)beforeHash, (String)"beforeHash");
            Intrinsics.checkNotNullParameter((Object)afterHash, (String)"afterHash");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            GitLineHandler h = new GitLineHandler(project, root, GitCommand.DIFF);
            h.setWithMediator(false);
            h.setStdoutSuppressed(true);
            String[] stringArray = new String[]{"-M", "--diff-filter=R", "--name-status", "--encoding=UTF-8", "--follow", beforeHash + ".." + afterHash};
            h.addParameters(stringArray);
            h.endOptions();
            stringArray = new FilePath[]{filePath};
            h.addRelativePaths((FilePath[])stringArray);
            String string = h.printableCommandLine();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"printableCommandLine(...)");
            RenamesCollector renamesCollector = new RenamesCollector(string);
            h.addLineListener(renamesCollector.getLineListener());
            Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
            return renamesCollector.getSingleRename();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgit4idea/history/GitLogHistoryHandler$RenamesCollector;", "Lgit4idea/history/DefaultGitLogFullRecordBuilder;", "commandLine", "", "(Ljava/lang/String;)V", "unexpectedStatusReported", "", "addPath", "", "type", "Lcom/intellij/openapi/vcs/changes/Change$Type;", "firstPath", "secondPath", "getLineListener", "Lgit4idea/commands/GitLineHandlerListener;", "getSingleRename", "Lcom/intellij/vcs/log/impl/VcsFileStatusInfo;", "intellij.vcs.git"})
    private static final class RenamesCollector
    extends DefaultGitLogFullRecordBuilder {
        @NotNull
        private final String commandLine;
        private boolean unexpectedStatusReported;

        public RenamesCollector(@NotNull String commandLine) {
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            this.commandLine = commandLine;
        }

        @Override
        public void addPath(@NotNull Change.Type type, @NotNull String firstPath, @Nullable String secondPath) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)firstPath, (String)"firstPath");
            if (type == Change.Type.MOVED) {
                super.addPath(type, firstPath, secondPath);
            } else if (!this.unexpectedStatusReported) {
                this.unexpectedStatusReported = true;
                LOG.error("Unexpected change " + type + " " + firstPath + " " + secondPath + " in the output of [" + this.commandLine + "]");
            }
        }

        @NotNull
        public final GitLineHandlerListener getLineListener() {
            GitLogParser.PathsParser parser = new GitLogParser.PathsParser(GitLogParser.NameStatus.STATUS, this);
            return (arg_0, arg_1) -> RenamesCollector.getLineListener$lambda$0(parser, arg_0, arg_1);
        }

        @Nullable
        public final VcsFileStatusInfo getSingleRename() {
            VcsFileStatusInfo info;
            if (this.getStatuses$intellij_vcs_git().size() > 1) {
                LOG.error("Unexpected multiple renames found. Command [" + this.commandLine + "].\nOutput [" + this.getStatuses$intellij_vcs_git() + "].");
            }
            VcsFileStatusInfo vcsFileStatusInfo = info = (VcsFileStatusInfo)CollectionsKt.singleOrNull(this.getStatuses$intellij_vcs_git());
            if ((vcsFileStatusInfo != null ? vcsFileStatusInfo.getSecondPath() : null) != null) {
                return info;
            }
            return null;
        }

        private static final void getLineListener$lambda$0(GitLogParser.PathsParser $parser, String line, Key outputType) {
            Intrinsics.checkNotNullParameter((Object)$parser, (String)"$parser");
            if (Intrinsics.areEqual((Object)outputType, (Object)ProcessOutputTypes.STDOUT)) {
                $parser.parseLine(line);
            }
        }
    }
}

