/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.thinclient.terminal;

import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.RdEventSource;
import com.intellij.openapi.rd.SourceExKt;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.TerminalTitleListener;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.TerminalDisplay;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jetbrains.codeWithMe.model.RdTerminalSession;
import com.jetbrains.codeWithMe.model.RdTerminalSessionOrigin;
import com.jetbrains.codeWithMe.model.RdTerminalSize;
import com.jetbrains.codeWithMe.model.RdTerminalTitle;
import com.jetbrains.codeWithMe.model.SessionPortForwarding;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.thinclient.CodeWithMeGuestBundle;
import com.jetbrains.thinclient.portForwarding.ThinClientPortForwardingPanelWidget;
import com.jetbrains.thinclient.services.ThinClientPermissionHost;
import com.jetbrains.thinclient.terminal.HostPrivateTerminalWidget;
import com.jetbrains.thinclient.terminal.ThinClientTerminalHost;
import com.jetbrains.thinclient.terminal.ThinClientTerminalProcess;
import com.jetbrains.thinclient.terminal.ThinClientTerminalRunner;
import java.awt.Component;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalTabState;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001/B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0016J \u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\"\u0010$\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00020%2\b\b\u0001\u0010&\u001a\u00020\u0019H\u0002J\u0018\u0010'\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0002J$\u0010*\u001a\u00020\u0007*\u00020+2\u0006\u0010\"\u001a\u00020#2\u000e\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010.0-H\u0002\u00a8\u00060"}, d2={"Lcom/jetbrains/thinclient/terminal/ThinClientTerminalRunner;", "Lorg/jetbrains/plugins/terminal/AbstractTerminalRunner;", "Lcom/jetbrains/thinclient/terminal/ThinClientTerminalProcess;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "bindTerminalScroll", "", "connector", "Lcom/jetbrains/thinclient/terminal/ThinClientTerminalRunner$ThinClientTtyConnector;", "widget", "Lorg/jetbrains/plugins/terminal/ShellTerminalWidget;", "bindTerminalSize", "createProcess", "options", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions;", "createShellTerminalWidget", "Lcom/intellij/terminal/ui/TerminalWidget;", "parent", "Lcom/intellij/openapi/Disposable;", "startupOptions", "createTtyConnector", "Lcom/jediterm/terminal/TtyConnector;", "process", "getCurrentWorkingDir", "", "state", "Lorg/jetbrains/plugins/terminal/TerminalTabState;", "getDefaultTabTitle", "setupPortForwardingPanel", "terminalUpperPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "portForwardingSession", "Lcom/jetbrains/codeWithMe/model/SessionPortForwarding;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "showNonSharedNotification", "Ljavax/swing/JPanel;", "text", "updateLocalTerminalSize", "hostSize", "Lcom/jetbrains/codeWithMe/model/RdTerminalSize;", "bindTerminalTitle", "Lcom/intellij/terminal/TerminalTitle;", "property", "Lcom/jetbrains/rd/util/reactive/IProperty;", "Lcom/jetbrains/codeWithMe/model/RdTerminalTitle;", "ThinClientTtyConnector", "intellij.terminal.frontend.split"})
public final class ThinClientTerminalRunner
extends AbstractTerminalRunner<ThinClientTerminalProcess> {
    public ThinClientTerminalRunner(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    public String getDefaultTabTitle() {
        return CodeWithMeGuestBundle.INSTANCE.message("terminal.session.tab.name", new Object[0]);
    }

    @NotNull
    protected TerminalWidget createShellTerminalWidget(@NotNull Disposable parent, @NotNull ShellStartupOptions startupOptions) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)startupOptions, (String)"startupOptions");
        if (!ThinClientTerminalHost.Companion.isRemoteDirectory(startupOptions.getWorkingDirectory()) && !ThinClientPermissionHost.Companion.getInstance().hasFullAccessToTerminal() || Intrinsics.areEqual((Object)startupOptions.getWorkingDirectory(), (Object)"FollowHostPrivateTab")) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            JBTerminalSystemSettingsProvider jBTerminalSystemSettingsProvider = this.getSettingsProvider();
            Intrinsics.checkNotNullExpressionValue((Object)jBTerminalSystemSettingsProvider, (String)"getSettingsProvider(...)");
            TerminalWidget terminalWidget = new HostPrivateTerminalWidget(project, jBTerminalSystemSettingsProvider, parent).asNewWidget();
            Intrinsics.checkNotNullExpressionValue((Object)terminalWidget, (String)"asNewWidget(...)");
            return terminalWidget;
        }
        Project project = this.getProject();
        JBTerminalSystemSettingsProvider jBTerminalSystemSettingsProvider = this.getSettingsProvider();
        ShellTerminalWidget widget2 = new ShellTerminalWidget(parent, project, jBTerminalSystemSettingsProvider){
            @Nullable
            private JComponent component;

            @NotNull
            public JComponent getComponent() {
                if (this.component == null) {
                    this.component = ScrollPaneFactory.createScrollPane((Component)super.getComponent(), (int)21, (int)31);
                }
                JComponent jComponent = this.component;
                Intrinsics.checkNotNull((Object)jComponent);
                return jComponent;
            }

            @NotNull
            public JComponent getPreferredFocusableComponent() {
                JComponent jComponent = super.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                return jComponent;
            }

            @NotNull
            protected JediTerminal createTerminal(@NotNull TerminalDisplay display, @NotNull TerminalTextBuffer textBuffer, @NotNull StyleState initialStyleState) {
                Intrinsics.checkNotNullParameter((Object)display, (String)"display");
                Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
                Intrinsics.checkNotNullParameter((Object)initialStyleState, (String)"initialStyleState");
                return new JediTerminal(display, textBuffer, initialStyleState){

                    public void deviceStatusReport(@NotNull String str) {
                        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                    }

                    public void deviceAttributes(@NotNull byte[] response) {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    }
                };
            }
        };
        widget2.getTerminalTitle().change((Function1)createShellTerminalWidget.1.INSTANCE);
        widget2.executeWithTtyConnector(arg_0 -> ThinClientTerminalRunner.createShellTerminalWidget$lambda$0(this, widget2, arg_0));
        TerminalWidget terminalWidget = widget2.asNewWidget();
        Intrinsics.checkNotNullExpressionValue((Object)terminalWidget, (String)"asNewWidget(...)");
        return terminalWidget;
    }

    private final void setupPortForwardingPanel(BorderLayoutPanel terminalUpperPanel, SessionPortForwarding portForwardingSession, Lifetime lifetime) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ThinClientPortForwardingPanelWidget portForwardingWidget = new ThinClientPortForwardingPanelWidget(project, lifetime, portForwardingSession);
        terminalUpperPanel.add((Component)portForwardingWidget, (Object)"North");
    }

    private final void bindTerminalTitle(TerminalTitle $this$bindTerminalTitle, Lifetime lifetime, IProperty<RdTerminalTitle> property) {
        SourceExKt.advise((ISource)((ISource)property), (Lifetime)lifetime, (Function2)((Function2)new Function2<RdTerminalTitle, RdEventSource, Unit>($this$bindTerminalTitle){
            final /* synthetic */ TerminalTitle $this_bindTerminalTitle;
            {
                this.$this_bindTerminalTitle = $receiver;
                super(2);
            }

            public final void invoke(@Nullable RdTerminalTitle title, @NotNull RdEventSource rdEventSource) {
                Intrinsics.checkNotNullParameter((Object)rdEventSource, (String)"<anonymous parameter 1>");
                if (title == null) {
                    return;
                }
                this.$this_bindTerminalTitle.change((Function1)new Function1<TerminalTitle.State, Unit>(title){
                    final /* synthetic */ RdTerminalTitle $title;
                    {
                        this.$title = $title;
                        super(1);
                    }

                    public final void invoke(@NotNull TerminalTitle.State $this$change) {
                        Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
                        $this$change.setUserDefinedTitle(this.$title.getUserDefinedTitle());
                        $this$change.setApplicationTitle(this.$title.getApplicationTitle());
                        $this$change.setDefaultTitle(this.$title.getDefaultTitle());
                    }
                });
            }
        }));
        $this$bindTerminalTitle.addTitleListener(new TerminalTitleListener(property){
            final /* synthetic */ IProperty<RdTerminalTitle> $property;
            {
                this.$property = $property;
            }

            public void onTitleChanged(@NotNull TerminalTitle terminalTitle) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)terminalTitle, (String)"terminalTitle");
                RdTerminalTitle existingModel = (RdTerminalTitle)this.$property.getValue();
                String string = terminalTitle.getUserDefinedTitle();
                Object object2 = existingModel;
                if (object2 == null || (object2 = object2.getApplicationTitle()) == null) {
                    object2 = terminalTitle.getApplicationTitle();
                }
                if (((object = existingModel) == null || (object = object.getDefaultTitle()) == null) && (object = terminalTitle.getDefaultTitle()) == null) {
                    String string2 = ExecutionBundle.message((String)"terminal.default.title", (Object[])new Object[0]);
                    object = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                }
                RdTerminalTitle model = new RdTerminalTitle(string, (String)object2, (String)object);
                this.$property.set((Object)model);
            }
        }, LifetimeDisposableExKt.createNestedDisposable((Lifetime)lifetime, (String)"thin terminal"));
    }

    private final void bindTerminalSize(ThinClientTtyConnector connector, ShellTerminalWidget widget2) {
        RdTerminalSession model = connector.getProcess().getModel();
        SourceExKt.advise((ISource)((ISource)model.getSize()), (Lifetime)connector.getProcess().getLifetime(), (Function2)((Function2)new Function2<RdTerminalSize, RdEventSource, Unit>(connector, widget2, this){
            final /* synthetic */ ThinClientTtyConnector $connector;
            final /* synthetic */ ShellTerminalWidget $widget;
            final /* synthetic */ ThinClientTerminalRunner this$0;
            {
                this.$connector = $connector;
                this.$widget = $widget;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull RdTerminalSize hostSize, @NotNull RdEventSource source) {
                Intrinsics.checkNotNullParameter((Object)hostSize, (String)"hostSize");
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                if (source == RdEventSource.Remote) {
                    this.$connector.setSizeController(false);
                    JComponent jComponent = this.$widget.getComponent();
                    JScrollPane jScrollPane = jComponent instanceof JScrollPane ? (JScrollPane)jComponent : null;
                    if (jScrollPane != null) {
                        jScrollPane.setHorizontalScrollBarPolicy(32);
                    }
                    ThinClientTerminalRunner.access$updateLocalTerminalSize(this.this$0, this.$widget, hostSize);
                }
            }
        }));
    }

    private final void updateLocalTerminalSize(ShellTerminalWidget widget2, RdTerminalSize hostSize) {
        if (hostSize.getWidth() == 0 && hostSize.getHeight() == 0) {
            return;
        }
        int width = hostSize.getWidth() > 0 ? hostSize.getWidth() : widget2.getTerminal().getTerminalWidth();
        int height = hostSize.getHeight() > 0 ? hostSize.getHeight() : widget2.getTerminal().getTerminalHeight();
        widget2.getTerminal().resize(new TermSize(width, height), RequestOrigin.User);
        widget2.getTerminalPanel().invalidate();
        widget2.getTerminalPanel().repaint();
    }

    private final void bindTerminalScroll(ThinClientTtyConnector connector, ShellTerminalWidget widget2) {
        RdTerminalSession model = connector.getProcess().getModel();
        Lifetime lifetime = connector.getProcess().getLifetime();
        BoundedRangeModel boundedRangeModel = widget2.getTerminalPanel().getVerticalScrollModel();
        Intrinsics.checkNotNullExpressionValue((Object)boundedRangeModel, (String)"getVerticalScrollModel(...)");
        BoundedRangeModel verticalScrollModel = boundedRangeModel;
        SourceExKt.advise((ISource)((ISource)model.getScroll()), (Lifetime)lifetime, (Function2)((Function2)new Function2<Integer, RdEventSource, Unit>(verticalScrollModel){
            final /* synthetic */ BoundedRangeModel $verticalScrollModel;
            {
                this.$verticalScrollModel = $verticalScrollModel;
                super(2);
            }

            public final void invoke(int hostScroll, @NotNull RdEventSource origin) {
                Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
                if (origin != RdEventSource.Remote) {
                    return;
                }
                this.$verticalScrollModel.setValue(hostScroll);
            }
        }));
        ChangeListener listener = arg_0 -> ThinClientTerminalRunner.bindTerminalScroll$lambda$1(model, verticalScrollModel, arg_0);
        verticalScrollModel.addChangeListener(listener);
        connector.getProcess().getLifetime().onTermination((Function0)new Function0<Unit>(verticalScrollModel, listener){
            final /* synthetic */ BoundedRangeModel $verticalScrollModel;
            final /* synthetic */ ChangeListener $listener;
            {
                this.$verticalScrollModel = $verticalScrollModel;
                this.$listener = $listener;
                super(0);
            }

            public final void invoke() {
                this.$verticalScrollModel.removeChangeListener(this.$listener);
            }
        });
    }

    private final void showNonSharedNotification(Lifetime lifetime, JPanel widget2, @Nls String text) {
        EditorNotificationPanel panel = new EditorNotificationPanel(JBUI.CurrentTheme.Validator.warningBackgroundColor());
        panel.setText(text);
        widget2.add((Component)panel, "South");
        lifetime.onTermination((Function0)new Function0<Unit>(widget2, panel){
            final /* synthetic */ JPanel $widget;
            final /* synthetic */ EditorNotificationPanel $panel;
            {
                this.$widget = $widget;
                this.$panel = $panel;
                super(0);
            }

            public final void invoke() {
                this.$widget.remove((Component)this.$panel);
                this.$widget.revalidate();
            }
        });
    }

    @NotNull
    public ThinClientTerminalProcess createProcess(@NotNull ShellStartupOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new ThinClientTerminalProcess(project, options.getWorkingDirectory());
    }

    @Nullable
    public String getCurrentWorkingDir(@Nullable TerminalTabState state) {
        String string;
        TerminalTabState terminalTabState = state;
        if (ThinClientTerminalHost.Companion.isRemoteDirectory(terminalTabState != null ? terminalTabState.myWorkingDirectory : null)) {
            TerminalTabState terminalTabState2 = state;
            Intrinsics.checkNotNull((Object)terminalTabState2);
            string = terminalTabState2.myWorkingDirectory;
        } else {
            string = super.getCurrentWorkingDir(state);
        }
        return string;
    }

    @NotNull
    public TtyConnector createTtyConnector(@NotNull ThinClientTerminalProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        return (TtyConnector)new ThinClientTtyConnector(process);
    }

    private static final void createShellTerminalWidget$lambda$0(ThinClientTerminalRunner this$0, createShellTerminalWidget.widget.1 $widget, TtyConnector it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$widget), (String)"$widget");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.jetbrains.thinclient.terminal.ThinClientTerminalRunner.ThinClientTtyConnector");
        ThinClientTtyConnector connector = (ThinClientTtyConnector)it;
        TerminalTitle terminalTitle = $widget.getTerminalTitle();
        Intrinsics.checkNotNullExpressionValue((Object)terminalTitle, (String)"getTerminalTitle(...)");
        this$0.bindTerminalTitle(terminalTitle, connector.getProcess().getLifetime(), (IProperty<RdTerminalTitle>)connector.getProcess().getModel().getTitle());
        this$0.bindTerminalSize(connector, $widget);
        this$0.bindTerminalScroll(connector, $widget);
        BorderLayoutPanel terminalUpperPanel = new BorderLayoutPanel();
        TerminalWidget terminalWidget = $widget.asNewWidget();
        JComponent jComponent = (JComponent)terminalUpperPanel;
        TerminalWidget terminalWidget2 = $widget.asNewWidget();
        Intrinsics.checkNotNullExpressionValue((Object)terminalWidget2, (String)"asNewWidget(...)");
        terminalWidget.addNotification(jComponent, (Disposable)terminalWidget2);
        InterfacesKt.viewNotNull((IViewable)((IViewable)connector.getProcess().getModel().getPortForwardingSession()), (Lifetime)connector.getProcess().getLifetime(), (Function2)((Function2)new Function2<Lifetime, SessionPortForwarding, Unit>(this$0, terminalUpperPanel){
            final /* synthetic */ ThinClientTerminalRunner this$0;
            final /* synthetic */ BorderLayoutPanel $terminalUpperPanel;
            {
                this.this$0 = $receiver;
                this.$terminalUpperPanel = $terminalUpperPanel;
                super(2);
            }

            public final void invoke(@NotNull Lifetime lt, @NotNull SessionPortForwarding pfSession) {
                Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                Intrinsics.checkNotNullParameter((Object)pfSession, (String)"pfSession");
                ThinClientTerminalRunner.access$setupPortForwardingPanel(this.this$0, this.$terminalUpperPanel, pfSession, lt);
            }
        }));
        BoolPropertyExKt.whenFalse((IViewable)((IViewable)connector.getProcess().getModel().getShared()), (Lifetime)connector.getProcess().getLifetime(), (Function1)((Function1)new Function1<Lifetime, Unit>(this$0, terminalUpperPanel){
            final /* synthetic */ ThinClientTerminalRunner this$0;
            final /* synthetic */ BorderLayoutPanel $terminalUpperPanel;
            {
                this.this$0 = $receiver;
                this.$terminalUpperPanel = $terminalUpperPanel;
                super(1);
            }

            public final void invoke(@NotNull Lifetime lt) {
                Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                ThinClientTerminalRunner.access$showNonSharedNotification(this.this$0, lt, (JPanel)this.$terminalUpperPanel, CodeWithMeGuestBundle.INSTANCE.message("terminal.session.private", new Object[0]));
            }
        }));
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)connector.getProcess().getModel().getClosed()), (Lifetime)connector.getProcess().getLifetime(), (Function1)((Function1)new Function1<Lifetime, Unit>(this$0, terminalUpperPanel){
            final /* synthetic */ ThinClientTerminalRunner this$0;
            final /* synthetic */ BorderLayoutPanel $terminalUpperPanel;
            {
                this.this$0 = $receiver;
                this.$terminalUpperPanel = $terminalUpperPanel;
                super(1);
            }

            public final void invoke(@NotNull Lifetime lt) {
                Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                ThinClientTerminalRunner.access$showNonSharedNotification(this.this$0, lt, (JPanel)this.$terminalUpperPanel, CodeWithMeGuestBundle.INSTANCE.message("terminal.message.terminal.closed", new Object[0]));
            }
        }));
    }

    private static final void bindTerminalScroll$lambda$1(RdTerminalSession $model, BoundedRangeModel $verticalScrollModel, ChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        Intrinsics.checkNotNullParameter((Object)$verticalScrollModel, (String)"$verticalScrollModel");
        $model.getScroll().set((Object)$verticalScrollModel.getValue());
    }

    public static final /* synthetic */ void access$updateLocalTerminalSize(ThinClientTerminalRunner $this, ShellTerminalWidget widget2, RdTerminalSize hostSize) {
        $this.updateLocalTerminalSize(widget2, hostSize);
    }

    public static final /* synthetic */ void access$setupPortForwardingPanel(ThinClientTerminalRunner $this, BorderLayoutPanel terminalUpperPanel, SessionPortForwarding portForwardingSession, Lifetime lifetime) {
        $this.setupPortForwardingPanel(terminalUpperPanel, portForwardingSession, lifetime);
    }

    public static final /* synthetic */ void access$showNonSharedNotification(ThinClientTerminalRunner $this, Lifetime lifetime, JPanel widget2, String text) {
        $this.showNonSharedNotification(lifetime, widget2, text);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/thinclient/terminal/ThinClientTerminalRunner$ThinClientTtyConnector;", "Lcom/jediterm/terminal/ProcessTtyConnector;", "process", "Lcom/jetbrains/thinclient/terminal/ThinClientTerminalProcess;", "(Lcom/jetbrains/thinclient/terminal/ThinClientTerminalProcess;)V", "getProcess", "()Lcom/jetbrains/thinclient/terminal/ThinClientTerminalProcess;", "sizeController", "", "getSizeController", "()Z", "setSizeController", "(Z)V", "getName", "", "isConnected", "resize", "", "termSize", "Lcom/jediterm/core/util/TermSize;", "intellij.terminal.frontend.split"})
    private static final class ThinClientTtyConnector
    extends ProcessTtyConnector {
        @NotNull
        private final ThinClientTerminalProcess process;
        private volatile boolean sizeController;

        public ThinClientTtyConnector(@NotNull ThinClientTerminalProcess process) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            super((Process)process, Charsets.UTF_8);
            this.process = process;
            this.sizeController = this.process.getModel().getOrigin() == RdTerminalSessionOrigin.Client;
        }

        @NotNull
        public final ThinClientTerminalProcess getProcess() {
            return this.process;
        }

        public final boolean getSizeController() {
            return this.sizeController;
        }

        public final void setSizeController(boolean bl) {
            this.sizeController = bl;
        }

        @NotNull
        public String getName() {
            return CodeWithMeGuestBundle.INSTANCE.message("terminal.session.tab.name", new Object[0]);
        }

        public boolean isConnected() {
            return true;
        }

        public void resize(@NotNull TermSize termSize) {
            Intrinsics.checkNotNullParameter((Object)termSize, (String)"termSize");
            if (this.sizeController) {
                this.process.getModel().getSize().set((Object)new RdTerminalSize(termSize.getColumns(), termSize.getRows()));
            }
        }
    }
}

