/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.workspace;

import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePrefixTreeFactory;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.RootsKt;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ExternalEntityMapping;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableExternalEntityMapping;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.ApplicationKt;
import com.intellij.util.containers.prefix.set.MutablePrefixTreeSet;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.AddRemove;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendModel;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.UnityPackage;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.UnityPackageSource;
import com.jetbrains.rider.plugins.unity.workspace.UnityPackageEntity;
import com.jetbrains.rider.plugins.unity.workspace.UnityPackageEntityKt;
import com.jetbrains.rider.plugins.unity.workspace.UnityWorkspaceExtensionsKt;
import com.jetbrains.rider.plugins.unity.workspace.UnityWorkspacePackageUpdater;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.workspace.RiderEntitySource;
import com.jetbrains.rider.workspaceModel.RiderModuleTypeKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0003\u0018\u0019\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\b\u0010\u0014\u001a\u00020\rH\u0002J\u001c\u0010\u0015\u001a\u00020\r2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0017H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/plugins/unity/workspace/UnityWorkspacePackageUpdater;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "initialEntityStorage", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "sourceRootsTree", "Lcom/intellij/util/containers/prefix/set/MutablePrefixTreeSet;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSourceRootsTree", "()Lcom/intellij/util/containers/prefix/set/MutablePrefixTreeSet;", "addPackage", "", "unityPackage", "Lcom/jetbrains/rider/plugins/unity/model/frontendBackend/UnityPackage;", "packageFolder", "entityStorage", "removePackage", "builder", "syncInitialEntityStorage", "updateWorkspaceModel", "action", "Lkotlin/Function1;", "Companion", "ProtocolListener", "RiderUnityPackageEntitySource", "intellij.rider.plugins.unity"})
public final class UnityWorkspacePackageUpdater {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private MutableEntityStorage initialEntityStorage;
    @NotNull
    private final MutablePrefixTreeSet<VirtualFile> sourceRootsTree;
    @NotNull
    private static final Logger logger;

    public UnityWorkspacePackageUpdater(@NotNull Project project) {
        VirtualFile assets;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.initialEntityStorage = MutableEntityStorage.Companion.create();
        this.sourceRootsTree = VirtualFilePrefixTreeFactory.INSTANCE.createSet((Object[])new VirtualFile[0]);
        ApplicationKt.getApplication().assertIsDispatchThread();
        VirtualFile virtualFile = DocumentUtilKt.toVirtualFile((File)SolutionHostExtensionsKt.getSolutionDirectory((Project)this.project), (boolean)false);
        Object object = assets = virtualFile != null ? virtualFile.findChild("Assets") : null;
        if (assets != null) {
            this.sourceRootsTree.add((Object)assets);
        } else {
            logger.warn("No `Assets` folder in the Unity project");
        }
    }

    @NotNull
    public final MutablePrefixTreeSet<VirtualFile> getSourceRootsTree() {
        return this.sourceRootsTree;
    }

    private final void addPackage(UnityPackage unityPackage, VirtualFile packageFolder, MutableEntityStorage entityStorage) {
        UnityPackageEntity unityPackageEntity;
        ContentRootEntity contentRootEntity;
        logger.trace("Adding Unity package: " + unityPackage.getId());
        ContentRootEntity contentRootEntity2 = contentRootEntity = packageFolder != null && unityPackage.getSource() != UnityPackageSource.Unknown ? UnityWorkspaceExtensionsKt.addContentRootEntity(entityStorage, VirtualFileUrls.toVirtualFileUrl((VirtualFile)packageFolder, (VirtualFileUrlManager)WorkspaceModel.Companion.getInstance(this.project).getVirtualFileUrlManager()), CollectionsKt.emptyList(), UnityWorkspaceExtensionsKt.getUNITY_EXCLUDED_PATTERNS(), RiderModuleTypeKt.getOrCreateRiderModuleEntity((MutableEntityStorage)entityStorage), (EntitySource)RiderUnityPackageEntitySource.INSTANCE) : null;
        if (contentRootEntity != null) {
            ContentRootEntity updatedRoot2 = RootsKt.modifyContentRootEntity((MutableEntityStorage)entityStorage, contentRootEntity, (Function1)((Function1)new Function1<ContentRootEntity.Builder, Unit>(unityPackage){
                final /* synthetic */ UnityPackage $unityPackage;
                {
                    this.$unityPackage = $unityPackage;
                    super(1);
                }

                public final void invoke(@NotNull ContentRootEntity.Builder $this$modifyContentRootEntity) {
                    Intrinsics.checkNotNullParameter((Object)$this$modifyContentRootEntity, (String)"$this$modifyContentRootEntity");
                    UnityPackageEntityKt.setUnityPackageEntity($this$modifyContentRootEntity, UnityPackageEntity.Companion.create(this.$unityPackage, (EntitySource)RiderUnityPackageEntitySource.INSTANCE, (Function1<? super UnityPackageEntity.Builder, Unit>)((Function1)new Function1<UnityPackageEntity.Builder, Unit>(this.$unityPackage){
                        final /* synthetic */ UnityPackage $unityPackage;
                        {
                            this.$unityPackage = $unityPackage;
                            super(1);
                        }

                        public final void invoke(@NotNull UnityPackageEntity.Builder $this$invoke) {
                            Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                            $this$invoke.setDescriptor(this.$unityPackage);
                        }
                    })));
                }
            }));
            UnityPackageEntity unityPackageEntity2 = UnityPackageEntityKt.getUnityPackageEntity(updatedRoot2);
            unityPackageEntity = unityPackageEntity2;
            Intrinsics.checkNotNull((Object)unityPackageEntity2);
        } else {
            unityPackageEntity = (UnityPackageEntity)entityStorage.addEntity((WorkspaceEntity.Builder)UnityPackageEntity.Companion.create(unityPackage, (EntitySource)RiderUnityPackageEntitySource.INSTANCE, (Function1<? super UnityPackageEntity.Builder, Unit>)((Function1)new Function1<UnityPackageEntity.Builder, Unit>(unityPackage){
                final /* synthetic */ UnityPackage $unityPackage;
                {
                    this.$unityPackage = $unityPackage;
                    super(1);
                }

                public final void invoke(@NotNull UnityPackageEntity.Builder $this$invoke) {
                    Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                    $this$invoke.setDescriptor(this.$unityPackage);
                    $this$invoke.setContentRootEntity(null);
                }
            })));
        }
        UnityPackageEntity entity2 = unityPackageEntity;
        MutableExternalEntityMapping mapping = entityStorage.getMutableExternalMapping(UnityWorkspaceExtensionsKt.getUNITY_PACKAGE_ID_MAPPING());
        mapping.addMapping((WorkspaceEntity)entity2, (Object)entity2.getPackageId());
    }

    private final void removePackage(UnityPackage unityPackage, MutableEntityStorage builder) {
        logger.trace("Removing Unity package: " + unityPackage.getId());
        ExternalEntityMapping mapping = builder.getExternalMapping(UnityWorkspaceExtensionsKt.getUNITY_PACKAGE_ID_MAPPING());
        for (WorkspaceEntity entity2 : mapping.getEntities((Object)unityPackage.getId())) {
            builder.removeEntity(entity2);
        }
    }

    private final void updateWorkspaceModel(Function1<? super MutableEntityStorage, Unit> action2) {
        ApplicationKt.getApplication().runWriteAction(() -> UnityWorkspacePackageUpdater.updateWorkspaceModel$lambda$0(this, action2));
    }

    private final void syncInitialEntityStorage() {
        MutableEntityStorage mutableEntityStorage = this.initialEntityStorage;
        if (mutableEntityStorage == null) {
            return;
        }
        MutableEntityStorage initialEntityStorage = mutableEntityStorage;
        logger.trace("Sync Unity packages after startup...");
        ApplicationKt.getApplication().runWriteAction(() -> UnityWorkspacePackageUpdater.syncInitialEntityStorage$lambda$1(this, initialEntityStorage));
    }

    private static final void updateWorkspaceModel$lambda$0(UnityWorkspacePackageUpdater this$0, Function1 $action) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        MutableEntityStorage entityStorage = this$0.initialEntityStorage;
        if (entityStorage != null) {
            $action.invoke((Object)entityStorage);
        } else {
            WorkspaceModel.Companion.getInstance(this$0.project).updateProjectModel("Unity: update packages", $action);
        }
    }

    private static final void syncInitialEntityStorage$lambda$1(UnityWorkspacePackageUpdater this$0, MutableEntityStorage $initialEntityStorage) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$initialEntityStorage, (String)"$initialEntityStorage");
        this$0.initialEntityStorage = null;
        WorkspaceModel.Companion.getInstance(this$0.project).updateProjectModel("Unity: sync packages", (Function1)new Function1<MutableEntityStorage, Unit>($initialEntityStorage){
            final /* synthetic */ MutableEntityStorage $initialEntityStorage;
            {
                this.$initialEntityStorage = $initialEntityStorage;
                super(1);
            }

            public final void invoke(@NotNull MutableEntityStorage entityStorage) {
                Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
                entityStorage.replaceBySource((Function1)syncInitialEntityStorage.1.1.INSTANCE, (EntityStorage)this.$initialEntityStorage);
            }
        });
    }

    public static final /* synthetic */ void access$updateWorkspaceModel(UnityWorkspacePackageUpdater $this, Function1 action2) {
        $this.updateWorkspaceModel((Function1<? super MutableEntityStorage, Unit>)action2);
    }

    public static final /* synthetic */ void access$addPackage(UnityWorkspacePackageUpdater $this, UnityPackage unityPackage, VirtualFile packageFolder, MutableEntityStorage entityStorage) {
        $this.addPackage(unityPackage, packageFolder, entityStorage);
    }

    public static final /* synthetic */ void access$removePackage(UnityWorkspacePackageUpdater $this, UnityPackage unityPackage, MutableEntityStorage builder) {
        $this.removePackage(unityPackage, builder);
    }

    public static final /* synthetic */ void access$syncInitialEntityStorage(UnityWorkspacePackageUpdater $this) {
        $this.syncInitialEntityStorage();
    }

    static {
        Logger logger = Logger.getInstance(UnityWorkspacePackageUpdater.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UnityWorkspacePackageUpdater.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/plugins/unity/workspace/UnityWorkspacePackageUpdater$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/jetbrains/rider/plugins/unity/workspace/UnityWorkspacePackageUpdater;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.unity"})
    @SourceDebugExtension(value={"SMAP\nUnityWorkspacePackageUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityWorkspacePackageUpdater.kt\ncom/jetbrains/rider/plugins/unity/workspace/UnityWorkspacePackageUpdater$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,154:1\n31#2,2:155\n*S KotlinDebug\n*F\n+ 1 UnityWorkspacePackageUpdater.kt\ncom/jetbrains/rider/plugins/unity/workspace/UnityWorkspacePackageUpdater$Companion\n*L\n36#1:155,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UnityWorkspacePackageUpdater getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<UnityWorkspacePackageUpdater> serviceClass$iv = UnityWorkspacePackageUpdater.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (UnityWorkspacePackageUpdater)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/plugins/unity/workspace/UnityWorkspacePackageUpdater$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/plugins/unity/model/frontendBackend/FrontendBackendModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider.plugins.unity"})
    public static final class ProtocolListener
    implements SolutionExtListener<FrontendBackendModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull FrontendBackendModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            model.getPackages().adviseAddRemove(lifetime, (Function3)new Function3<AddRemove, String, UnityPackage, Unit>(session){
                final /* synthetic */ ClientProjectSession $session;
                {
                    this.$session = $session;
                    super(3);
                }

                public final void invoke(@NotNull AddRemove action2, @NotNull String string, @NotNull UnityPackage unityPackage) {
                    VirtualFile virtualFile;
                    Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                    Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 1>");
                    Intrinsics.checkNotNullParameter((Object)unityPackage, (String)"unityPackage");
                    ApplicationKt.getApplication().assertIsDispatchThread();
                    UnityWorkspacePackageUpdater updater = UnityWorkspacePackageUpdater.Companion.getInstance(this.$session.getProject());
                    String string2 = unityPackage.getPackageFolderPath();
                    if (string2 != null) {
                        String it = string2;
                        boolean bl = false;
                        virtualFile = VfsUtil.findFile((Path)Paths.get(it, new String[0]), (boolean)true);
                    } else {
                        virtualFile = null;
                    }
                    VirtualFile packageFolder = virtualFile;
                    switch (extensionCreated.WhenMappings.$EnumSwitchMapping$0[action2.ordinal()]) {
                        case 1: {
                            UnityWorkspacePackageUpdater.access$updateWorkspaceModel(UnityWorkspacePackageUpdater.Companion.getInstance(this.$session.getProject()), (Function1)new Function1<MutableEntityStorage, Unit>(packageFolder, updater, unityPackage){
                                final /* synthetic */ VirtualFile $packageFolder;
                                final /* synthetic */ UnityWorkspacePackageUpdater $updater;
                                final /* synthetic */ UnityPackage $unityPackage;
                                {
                                    this.$packageFolder = $packageFolder;
                                    this.$updater = $updater;
                                    this.$unityPackage = $unityPackage;
                                    super(1);
                                }

                                public final void invoke(@NotNull MutableEntityStorage entityStorage) {
                                    Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
                                    if (this.$packageFolder != null) {
                                        this.$updater.getSourceRootsTree().add((Object)this.$packageFolder);
                                    }
                                    UnityWorkspacePackageUpdater.access$addPackage(this.$updater, this.$unityPackage, this.$packageFolder, entityStorage);
                                }
                            });
                            break;
                        }
                        case 2: {
                            UnityWorkspacePackageUpdater.access$updateWorkspaceModel(UnityWorkspacePackageUpdater.Companion.getInstance(this.$session.getProject()), (Function1)new Function1<MutableEntityStorage, Unit>(packageFolder, updater, unityPackage){
                                final /* synthetic */ VirtualFile $packageFolder;
                                final /* synthetic */ UnityWorkspacePackageUpdater $updater;
                                final /* synthetic */ UnityPackage $unityPackage;
                                {
                                    this.$packageFolder = $packageFolder;
                                    this.$updater = $updater;
                                    this.$unityPackage = $unityPackage;
                                    super(1);
                                }

                                public final void invoke(@NotNull MutableEntityStorage entityStorage) {
                                    Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
                                    if (this.$packageFolder != null) {
                                        this.$updater.getSourceRootsTree().remove((Object)this.$packageFolder);
                                    }
                                    UnityWorkspacePackageUpdater.access$removePackage(this.$updater, this.$unityPackage, entityStorage);
                                }
                            });
                        }
                    }
                }
            });
            SourceExKt.adviseUntil((ISource)((ISource)model.getPackagesUpdating()), (Lifetime)lifetime, (Function1)((Function1)new Function1<Boolean, Boolean>(session){
                final /* synthetic */ ClientProjectSession $session;
                {
                    this.$session = $session;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@Nullable Boolean updating) {
                    if (Intrinsics.areEqual((Object)updating, (Object)false)) {
                        UnityWorkspacePackageUpdater.access$syncInitialEntityStorage(UnityWorkspacePackageUpdater.Companion.getInstance(this.$session.getProject()));
                        return true;
                    }
                    return false;
                }
            }));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jetbrains/rider/plugins/unity/workspace/UnityWorkspacePackageUpdater$RiderUnityPackageEntitySource;", "Lcom/jetbrains/rider/projectView/workspace/RiderEntitySource;", "()V", "intellij.rider.plugins.unity"})
    public static final class RiderUnityPackageEntitySource
    implements RiderEntitySource {
        @NotNull
        public static final RiderUnityPackageEntitySource INSTANCE = new RiderUnityPackageEntitySource();

        private RiderUnityPackageEntitySource() {
        }
    }
}

