/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.util;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/rider/plugins/unity/util/UnityCachesFinder;", "", "()V", "Companion", "intellij.rider.plugins.unity"})
public final class UnityCachesFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Lazy<Path> packagesCacheRoot$delegate;

    static {
        Logger logger = Logger.getInstance(UnityCachesFinder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UnityCachesFinder.logger = logger;
        packagesCacheRoot$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>((Object)Companion){

            @Nullable
            public final Path invoke() {
                return com.jetbrains.rider.plugins.unity.util.UnityCachesFinder$Companion.access$findPackagesCacheRoot((Companion)this.receiver);
            }
        }));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/plugins/unity/util/UnityCachesFinder$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "packagesCacheRoot", "Ljava/nio/file/Path;", "getPackagesCacheRoot", "()Ljava/nio/file/Path;", "packagesCacheRoot$delegate", "Lkotlin/Lazy;", "findPackagesCache", "Lcom/intellij/openapi/vfs/VirtualFile;", "cacheRoot", "registry", "", "findPackagesCacheRoot", "getPackagesCacheFolder", "intellij.rider.plugins.unity"})
    @SourceDebugExtension(value={"SMAP\nUnityCachesFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityCachesFinder.kt\ncom/jetbrains/rider/plugins/unity/util/UnityCachesFinder$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getPackagesCacheRoot() {
            Lazy lazy = packagesCacheRoot$delegate;
            return (Path)lazy.getValue();
        }

        @Nullable
        public final VirtualFile getPackagesCacheFolder(@NotNull String registry) {
            String string;
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Path path = this.getPackagesCacheRoot();
            if (path == null) {
                return null;
            }
            Path cache = path;
            String defaultRegistry = "packages.unity.com";
            try {
                string = new URL(registry).getHost();
            }
            catch (Throwable throwable) {
                String reg = ((CharSequence)registry).length() > 0 ? registry : defaultRegistry;
                logger.error("Error parsing registry as URL. Falling back to " + reg, throwable);
                string = reg;
            }
            String registryHost = string;
            Intrinsics.checkNotNull((Object)registryHost);
            VirtualFile virtualFile = this.findPackagesCache(cache, registryHost);
            if (virtualFile == null) {
                virtualFile = this.findPackagesCache(cache, defaultRegistry);
            }
            return virtualFile;
        }

        private final Path findPackagesCacheRoot() {
            Object object;
            block3: {
                block6: {
                    Object object2;
                    block8: {
                        block7: {
                            block5: {
                                block4: {
                                    block2: {
                                        object = System.getenv("UPM_CACHE_PATH");
                                        if (object == null) break block2;
                                        String it = object;
                                        boolean bl = false;
                                        Path path = Paths.get(it, new String[0]);
                                        object = path;
                                        if (path != null) break block3;
                                    }
                                    if (!SystemInfo.isWindows) break block4;
                                    object = Paths.get(System.getenv("LOCALAPPDATA"), new String[0]).resolve("Unity/cache/packages");
                                    break block3;
                                }
                                if (!SystemInfo.isMac) break block5;
                                object = Paths.get(SystemProperties.getUserHome(), new String[0]).resolve("Library/Unity/cache/packages");
                                break block3;
                            }
                            if (!SystemInfo.isLinux) break block6;
                            object2 = System.getenv("XDG_CONFIG_HOME");
                            if (object2 == null) break block7;
                            String it = object2;
                            boolean bl = false;
                            Path path = Paths.get(it, new String[0]);
                            object2 = path;
                            if (path != null) break block8;
                        }
                        object2 = Paths.get(SystemProperties.getUserHome(), new String[0]).resolve(".config");
                    }
                    Object configRoot = object2;
                    object = configRoot.resolve("unity3d/cache/packages");
                    break block3;
                }
                object = null;
            }
            return object;
        }

        private final VirtualFile findPackagesCache(Path cacheRoot, String registry) {
            VirtualFile virtualFile;
            try {
                virtualFile = VfsUtil.findFile((Path)cacheRoot.resolve(registry), (boolean)true);
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ControlFlowException)) {
                    logger.error("Error looking for registry cache location: " + cacheRoot + "/" + registry, throwable);
                }
                virtualFile = null;
            }
            return virtualFile;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Path access$findPackagesCacheRoot(Companion $this) {
            return $this.findPackagesCacheRoot();
        }
    }
}

