/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001eB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J?\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u0007H\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/plugins/unity/util/SemVer;", "", "major", "", "minor", "patch", "prerelease", "", "buildMetadata", "(IIILjava/lang/String;Ljava/lang/String;)V", "getBuildMetadata", "()Ljava/lang/String;", "getMajor", "()I", "getMinor", "getPatch", "getPrerelease", "compareTo", "other", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "", "hashCode", "toString", "Companion", "intellij.rider.plugins.unity"})
public final class SemVer
implements Comparable<SemVer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int patch;
    @Nullable
    private final String prerelease;
    @Nullable
    private final String buildMetadata;

    public SemVer(int major, int minor, int patch, @Nullable String prerelease, @Nullable String buildMetadata) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.prerelease = prerelease;
        this.buildMetadata = buildMetadata;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @Nullable
    public final String getPrerelease() {
        return this.prerelease;
    }

    @Nullable
    public final String getBuildMetadata() {
        return this.buildMetadata;
    }

    @NotNull
    public String toString() {
        String result = this.major + "." + this.minor + "." + this.patch;
        if (this.prerelease != null) {
            result = result + "-" + this.prerelease;
        }
        if (this.buildMetadata != null) {
            result = result + "+" + this.buildMetadata;
        }
        return result;
    }

    @Override
    public int compareTo(@NotNull SemVer other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.major > other.major) {
            return 1;
        }
        if (this.major < other.major) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.patch > other.patch) {
            return 1;
        }
        if (this.patch < other.patch) {
            return -1;
        }
        if (this.prerelease == null && other.prerelease == null) {
            return 0;
        }
        if (other.prerelease == null) {
            return -1;
        }
        if (this.prerelease == null) {
            return 1;
        }
        String[] stringArray = new String[]{"."};
        List segments = StringsKt.split$default((CharSequence)this.prerelease, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String[] stringArray2 = new String[]{"."};
        List otherSegments = StringsKt.split$default((CharSequence)other.prerelease, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        int i = 0;
        int commonSegments = Math.min(segments.size(), otherSegments.size());
        int n = commonSegments - 1;
        if (i <= n) {
            while (true) {
                String segment = (String)segments.get(i);
                String otherSegment = (String)otherSegments.get(i);
                Integer digitVal = StringsKt.toIntOrNull((String)segment);
                Integer otherDigitVal = StringsKt.toIntOrNull((String)segment);
                if (digitVal == null && otherDigitVal != null) {
                    return 1;
                }
                if (digitVal != null && otherDigitVal == null) {
                    return -1;
                }
                if (digitVal != null && otherDigitVal != null) {
                    if (digitVal > otherDigitVal) {
                        return 1;
                    }
                    if (digitVal < otherDigitVal) {
                        return -1;
                    }
                } else {
                    if (segment.compareTo(otherSegment) > 0) {
                        return 1;
                    }
                    if (segment.compareTo(otherSegment) < 0) {
                        return -1;
                    }
                }
                if (i == n) break;
                ++i;
            }
        }
        if (segments.size() > otherSegments.size()) {
            return 1;
        }
        if (segments.size() < otherSegments.size()) {
            return -1;
        }
        return 0;
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.patch;
    }

    @Nullable
    public final String component4() {
        return this.prerelease;
    }

    @Nullable
    public final String component5() {
        return this.buildMetadata;
    }

    @NotNull
    public final SemVer copy(int major, int minor, int patch, @Nullable String prerelease, @Nullable String buildMetadata) {
        return new SemVer(major, minor, patch, prerelease, buildMetadata);
    }

    public static /* synthetic */ SemVer copy$default(SemVer semVer, int n, int n2, int n3, String string, String string2, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = semVer.major;
        }
        if ((n4 & 2) != 0) {
            n2 = semVer.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = semVer.patch;
        }
        if ((n4 & 8) != 0) {
            string = semVer.prerelease;
        }
        if ((n4 & 0x10) != 0) {
            string2 = semVer.buildMetadata;
        }
        return semVer.copy(n, n2, n3, string, string2);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.major);
        result = result * 31 + Integer.hashCode(this.minor);
        result = result * 31 + Integer.hashCode(this.patch);
        result = result * 31 + (this.prerelease == null ? 0 : this.prerelease.hashCode());
        result = result * 31 + (this.buildMetadata == null ? 0 : this.buildMetadata.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SemVer)) {
            return false;
        }
        SemVer semVer = (SemVer)other;
        if (this.major != semVer.major) {
            return false;
        }
        if (this.minor != semVer.minor) {
            return false;
        }
        if (this.patch != semVer.patch) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.prerelease, (Object)semVer.prerelease)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.buildMetadata, (Object)semVer.buildMetadata);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/plugins/unity/util/SemVer$Companion;", "", "()V", "parse", "Lcom/jetbrains/rider/plugins/unity/util/SemVer;", "version", "", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SemVer parse(@NotNull String version) {
            SemVer semVer;
            MatchResult match;
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Regex pattern = new Regex("(?<major>\\d+)\\.(?<minor>\\d+)\\.(?<patch>\\d+)(?:-(?<prerelease>[0-9A-Za-z\\-]+(?:\\.([0-9A-Za-z\\-])+)*)(?:\\+(?<build>[0-9A-Za-z\\-.]+))?)?");
            MatchResult matchResult = match = pattern.matchEntire((CharSequence)version);
            if (matchResult != null) {
                MatchResult it = matchResult;
                boolean bl = false;
                Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"major");
                int major = object != null && (object = object.getValue()) != null ? Integer.parseInt((String)object) : 0;
                Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"minor");
                int minor = object2 != null && (object2 = object2.getValue()) != null ? Integer.parseInt((String)object2) : 0;
                Object object3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"patch");
                int patch = object3 != null && (object3 = object3.getValue()) != null ? Integer.parseInt((String)object3) : 0;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"prerelease");
                String prerelease = matchGroup != null ? matchGroup.getValue() : null;
                MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"build");
                String build = matchGroup2 != null ? matchGroup2.getValue() : null;
                semVer = new SemVer(major, minor, patch, prerelease, build);
            } else {
                semVer = null;
            }
            return semVer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

