/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.ui.vcs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.ui.BooleanCommitOption;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.util.PairConsumer;
import com.jetbrains.rd.framework.impl.RpcTimeouts;
import com.jetbrains.rider.plugins.unity.UnityProjectDiscovererKt;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendModel_PregeneratedKt;
import com.jetbrains.rider.plugins.unity.ui.UnityUIBundle;
import com.jetbrains.rider.plugins.unity.ui.vcs.UnsavedCheckinState;
import com.jetbrains.rider.plugins.unity.ui.vcs.UnsavedSceneCheckinHandlerFactoryKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/plugins/unity/ui/vcs/UnresolvedMergeCheckHandler;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "(Lcom/intellij/openapi/vcs/CheckinProjectPanel;)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "settings", "Lcom/jetbrains/rider/plugins/unity/ui/vcs/UnsavedCheckinState;", "askUser", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "beforeCheckin", "executor", "Lcom/intellij/openapi/vcs/changes/CommitExecutor;", "additionalDataConsumer", "Lcom/intellij/util/PairConsumer;", "", "getBeforeCheckinConfigurationPanel", "Lcom/intellij/openapi/vcs/ui/RefreshableOnComponent;", "intellij.rider.plugins.unity"})
final class UnresolvedMergeCheckHandler
extends CheckinHandler {
    @NotNull
    private final CheckinProjectPanel panel;
    @NotNull
    private final Project project;
    @NotNull
    private final UnsavedCheckinState settings;

    public UnresolvedMergeCheckHandler(@NotNull CheckinProjectPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        this.panel = panel2;
        Project project = this.panel.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.settings = UnsavedCheckinState.Companion.getService(this.project);
    }

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        if (!((Boolean)UnityProjectDiscovererKt.isUnityProject(this.project).getValue()).booleanValue()) {
            return null;
        }
        return (RefreshableOnComponent)new BooleanCommitOption(this.panel, UnityUIBundle.Companion.message("commitOption.check.unsaved.unity.state", new Object[0]), false, (KMutableProperty0)new MutablePropertyReference0Impl(this.settings){

            @Nullable
            public Object get() {
                return ((UnsavedCheckinState)this.receiver).getCheckUnsavedState();
            }

            public void set(@Nullable Object value) {
                ((UnsavedCheckinState)this.receiver).setCheckUnsavedState((Boolean)value);
            }
        });
    }

    @NotNull
    public CheckinHandler.ReturnResult beforeCheckin(@Nullable CommitExecutor executor, @NotNull PairConsumer<Object, Object> additionalDataConsumer) {
        Intrinsics.checkNotNullParameter(additionalDataConsumer, (String)"additionalDataConsumer");
        if (this.settings.getCheckUnsavedState() && ((Boolean)UnityProjectDiscovererKt.isUnityProject(this.project).getValue()).booleanValue()) {
            boolean providerResult = false;
            try {
                providerResult = (Boolean)FrontendBackendModel_PregeneratedKt.getFrontendBackendModel(SolutionHostExtensionsKt.getSolution((Project)this.project)).getHasUnsavedState().sync((Object)Unit.INSTANCE, new RpcTimeouts(200L, 200L));
            }
            catch (CancellationException t) {
                UnsavedSceneCheckinHandlerFactoryKt.access$getLogger$p().info("Unable to fetch hasUnsavedScenes", (Throwable)t);
            }
            catch (Throwable t) {
                UnsavedSceneCheckinHandlerFactoryKt.access$getLogger$p().warn("Unable to fetch hasUnsavedScenes", t);
            }
            if (providerResult) {
                return this.askUser();
            }
        }
        return CheckinHandler.ReturnResult.COMMIT;
    }

    private final CheckinHandler.ReturnResult askUser() {
        int dialogResult = Messages.showOkCancelDialog((Project)this.project, (String)UnityUIBundle.Companion.message("dialog.unsaved.message.changes.in.unity.state.will.not.be.included.in.commit", new Object[0]), (String)UnityUIBundle.Companion.message("dialog.unsaved.title.unity.state", new Object[0]), (String)UnityUIBundle.Companion.message("dialog.unsaved.button.commit.anyway", new Object[0]), (String)UnityUIBundle.Companion.message("dialog.unsaved.button.cancel", new Object[0]), (Icon)Messages.getWarningIcon());
        if (dialogResult == 0) {
            return CheckinHandler.ReturnResult.COMMIT;
        }
        return CheckinHandler.ReturnResult.CANCEL;
    }
}

