/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.ui.vcs;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.ui.BooleanCommitOption;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairConsumer;
import com.jetbrains.rider.plugins.unity.UnityProjectDiscovererKt;
import com.jetbrains.rider.plugins.unity.ui.UnityUIBundle;
import com.jetbrains.rider.plugins.unity.ui.vcs.MetaFilesCheckinHandlerFactoryKt;
import com.jetbrains.rider.plugins.unity.ui.vcs.MetaFilesCheckinState;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/plugins/unity/ui/vcs/MetaFilesCheckHandler;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "(Lcom/intellij/openapi/vcs/CheckinProjectPanel;)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "settings", "Lcom/jetbrains/rider/plugins/unity/ui/vcs/MetaFilesCheckinState;", "beforeCheckin", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "executor", "Lcom/intellij/openapi/vcs/changes/CommitExecutor;", "additionalDataConsumer", "Lcom/intellij/util/PairConsumer;", "", "getBeforeCheckinConfigurationPanel", "Lcom/intellij/openapi/vcs/ui/RefreshableOnComponent;", "isMetaFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nMetaFilesCheckinHandlerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetaFilesCheckinHandlerFactory.kt\ncom/jetbrains/rider/plugins/unity/ui/vcs/MetaFilesCheckHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n766#2:101\n857#2,2:102\n*S KotlinDebug\n*F\n+ 1 MetaFilesCheckinHandlerFactory.kt\ncom/jetbrains/rider/plugins/unity/ui/vcs/MetaFilesCheckHandler\n*L\n65#1:101\n65#1:102,2\n*E\n"})
final class MetaFilesCheckHandler
extends CheckinHandler {
    @NotNull
    private final CheckinProjectPanel panel;
    @NotNull
    private final Project project;
    @NotNull
    private final MetaFilesCheckinState settings;

    public MetaFilesCheckHandler(@NotNull CheckinProjectPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        this.panel = panel2;
        Project project = this.panel.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.settings = MetaFilesCheckinState.Companion.getService(this.project);
    }

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        if (!((Boolean)UnityProjectDiscovererKt.isUnityProject(this.project).getValue()).booleanValue()) {
            return null;
        }
        return (RefreshableOnComponent)new BooleanCommitOption(this.panel, UnityUIBundle.Companion.message("check.redundant.meta.files", new Object[0]), false, (KMutableProperty0)new MutablePropertyReference0Impl(this.settings){

            @Nullable
            public Object get() {
                return ((MetaFilesCheckinState)this.receiver).getCheckMetaFiles();
            }

            public void set(@Nullable Object value) {
                ((MetaFilesCheckinState)this.receiver).setCheckMetaFiles((Boolean)value);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CheckinHandler.ReturnResult beforeCheckin(@Nullable CommitExecutor executor, @NotNull PairConsumer<Object, Object> additionalDataConsumer) {
        Intrinsics.checkNotNullParameter(additionalDataConsumer, (String)"additionalDataConsumer");
        if (this.settings.getCheckMetaFiles() && ((Boolean)UnityProjectDiscovererKt.isUnityProject(this.project).getValue()).booleanValue()) {
            Collection changes = this.panel.getSelectedChanges();
            Intrinsics.checkNotNull((Object)changes);
            if (CollectionsKt.any((Iterable)changes)) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = changes;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Object[] destination$iv$iv = (Object[])new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    Change it = (Change)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getVirtualFile() == null) {
                        bl = false;
                    } else {
                        VirtualFile virtualFile;
                        Intrinsics.checkNotNull((Object)virtualFile);
                        VirtualFile virtualFile2 = virtualFile;
                        if (!Intrinsics.areEqual((Object)it.getFileStatus(), (Object)FileStatus.ADDED) || !this.isMetaFile(it.getVirtualFile())) {
                            bl = false;
                        } else if (virtualFile2.getParent().findChild(virtualFile2.getNameWithoutExtension()) == null) {
                            bl = false;
                        } else {
                            VirtualFile virtualFile3;
                            Intrinsics.checkNotNull((Object)virtualFile3);
                            VirtualFile folder = virtualFile3;
                            if (!folder.isDirectory()) {
                                bl = false;
                            } else {
                                VirtualFile[] virtualFileArray = folder.getChildren();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                                bl = !ArraysKt.any((Object[])virtualFileArray);
                            }
                        }
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List emptyFolders = (List)destination$iv$iv;
                if (CollectionsKt.any((Iterable)emptyFolders)) {
                    MetaFilesCheckinHandlerFactoryKt.access$getLogger$p().info("check.redundant.meta.files");
                    NotificationGroup groupId = NotificationGroupManager.getInstance().getNotificationGroup("Unity commit failure");
                    String title = UnityUIBundle.Companion.message("commit.failed.with.error", new Object[0]);
                    destination$iv$iv = new Object[]{CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)emptyFolders, (int)3), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<Change, CharSequence>(this){
                        final /* synthetic */ MetaFilesCheckHandler this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final CharSequence invoke(Change it) {
                            Path path = SolutionHostExtensionsKt.getSolutionDirectory((Project)MetaFilesCheckHandler.access$getProject$p(this.this$0)).toPath();
                            VirtualFile virtualFile = it.getVirtualFile();
                            Intrinsics.checkNotNull((Object)virtualFile);
                            Path path2 = path.relativize(virtualFile.toNioPath());
                            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"relativize(...)");
                            return ((Object)path2).toString();
                        }
                    }), (int)30, null) + (((Collection)emptyFolders).size() > 3 ? ", \u2026" : "")};
                    String message2 = UnityUIBundle.Companion.message("notification.content.empty.folders.so.meta.files.should.not.be.committed", destination$iv$iv);
                    Notification notification = new Notification(groupId.getDisplayId(), title, message2, NotificationType.ERROR);
                    Notifications.Bus.notify((Notification)notification, (Project)this.project);
                    return CheckinHandler.ReturnResult.CLOSE_WINDOW;
                }
            }
        }
        return CheckinHandler.ReturnResult.COMMIT;
    }

    private final boolean isMetaFile(VirtualFile file) {
        Object object = file;
        if (object == null || (object = object.getExtension()) == null) {
            return false;
        }
        Object extension = object;
        return StringsKt.equals((String)"meta", (String)extension, (boolean)true);
    }

    public static final /* synthetic */ Project access$getProject$p(MetaFilesCheckHandler $this) {
        return $this.project;
    }
}

