/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.ui.shaders;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.awt.RelativePoint;
import com.jetbrains.rd.ide.model.TextControlExtension;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.editors.resolveContextWidget.RiderResolveContextWidget;
import com.jetbrains.rider.plugins.unity.UnityBundle;
import com.jetbrains.rider.plugins.unity.ideaInterop.fileTypes.shaderLab.ShaderLabFileType;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.RdShaderVariantExtension;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.RdShaderVariantInfo;
import com.jetbrains.rider.plugins.unity.ui.shaders.AbstractShaderWidget;
import com.jetbrains.rider.plugins.unity.ui.shaders.ShaderVariantPopup;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/plugins/unity/ui/shaders/ShaderVariantWidget;", "Lcom/jetbrains/rider/plugins/unity/ui/shaders/AbstractShaderWidget;", "Lcom/jetbrains/rider/editors/resolveContextWidget/RiderResolveContextWidget;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "shaderVariant", "Lcom/jetbrains/rider/plugins/unity/model/frontendBackend/RdShaderVariantExtension;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rider/plugins/unity/model/frontendBackend/RdShaderVariantExtension;)V", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "addNotify", "", "showPopup", "point", "Lcom/intellij/ui/awt/RelativePoint;", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nShaderVariantWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShaderVariantWidget.kt\ncom/jetbrains/rider/plugins/unity/ui/shaders/ShaderVariantWidget\n+ 2 textControlModelEx.kt\ncom/jetbrains/rd/ide/editor/TextControlModelExKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,60:1\n14#2:61\n15#2,4:73\n4098#3,11:62\n*S KotlinDebug\n*F\n+ 1 ShaderVariantWidget.kt\ncom/jetbrains/rider/plugins/unity/ui/shaders/ShaderVariantWidget\n*L\n52#1:61\n52#1:73,4\n52#1:62,11\n*E\n"})
public final class ShaderVariantWidget
extends AbstractShaderWidget
implements RiderResolveContextWidget,
Disposable {
    @NotNull
    private final Lifetime lifetime;

    public ShaderVariantWidget(@NotNull Project project, @NotNull Editor editor, @NotNull RdShaderVariantExtension shaderVariant) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)shaderVariant), (String)"shaderVariant");
        super(project, editor);
        this.lifetime = LifetimeDisposableExKt.createLifetime((Disposable)this);
        this.getLabel().setIcon(ShaderLabFileType.INSTANCE.getIcon());
        shaderVariant.getInfo().advise(this.lifetime, (Function1)new Function1<RdShaderVariantInfo, Unit>(){

            public final void invoke(@NotNull RdShaderVariantInfo info) {
                String string;
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                if (info.getSuppressedCount() > 0) {
                    var3_2 = new Object[]{info.getEnabledCount(), info.getSuppressedCount(), info.getAvailableCount()};
                    string = UnityBundle.Companion.message("shaderVariant.widget.text.with.suppressed", var3_2);
                } else {
                    var3_2 = new Object[]{info.getEnabledCount(), info.getAvailableCount()};
                    string = UnityBundle.Companion.message("shaderVariant.widget.text", var3_2);
                }
                String newText = string;
                this.getText$intellij_rider_plugins_unity().set((Object)newText);
            }
        });
    }

    public void showPopup(@NotNull RelativePoint point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        ShaderVariantPopup.Companion.show(this.lifetime, this.getProject(), this.getEditor(), point);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addNotify() {
        TextControlModel textControlModel = DocumentExKt.getTextControlModel((Editor)this.getEditor());
        if (textControlModel != null) {
            void $this$filterIsInstanceTo$iv$iv$iv;
            TextControlModel $this$getExtensionSafe$iv = textControlModel;
            boolean $i$f$getExtensionSafe = false;
            TextControlExtension[] $this$filterIsInstance$iv$iv = $this$getExtensionSafe$iv.getExtensions();
            boolean $i$f$filterIsInstance = false;
            TextControlExtension[] textControlExtensionArray = $this$filterIsInstance$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                if (!(element$iv$iv$iv instanceof RdShaderVariantExtension)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            List extensions$iv = (List)destination$iv$iv$iv;
            if (((Collection)extensions$iv).size() > 1) {
                Logger.getInstance((String)"com.jetbrains.rd.ide.editor").error("Text control has duplicates of an extension of type " + RdShaderVariantExtension.class);
            }
            RdShaderVariantExtension cfr_ignored_0 = (RdShaderVariantExtension)((TextControlExtension)CollectionsKt.firstOrNull((List)extensions$iv));
        }
        super.addNotify();
        new GotItTooltip("shader_variant.widget.got.it", UnityBundle.Companion.message("shaderVariant.widget.got.it.tooltip.text", new Object[0]), (Disposable)this).withHeader(UnityBundle.Companion.message("shaderVariant.widget.got.it.tooltip.header", new Object[0])).withBrowserLink(UnityBundle.Companion.message("shaderVariant.widget.got.it.tooltip.learnMore", new Object[0]), new URL("https://jb.gg/wacf2b")).show((JComponent)this, GotItTooltip.TOP_MIDDLE);
    }
}

