/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.toolWindow.log;

import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rider.plugins.unity.toolWindow.log.LogPanelItem;
import com.jetbrains.rider.plugins.unity.toolWindow.log.UnityLogPanelIconsKt;
import com.jetbrains.rider.plugins.unity.toolWindow.log.UnityLogTokenizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J:\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0014J8\u0010\u0015\u001a\u00020\u00162\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelEventRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/jetbrains/rider/plugins/unity/toolWindow/log/LogPanelItem;", "Ljavax/swing/ListCellRenderer;", "()V", "countLabel", "Ljavax/swing/JLabel;", "tokenizer", "Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogTokenizer;", "view", "Ljavax/swing/JPanel;", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "event", "index", "", "selected", "", "hasFocus", "getListCellRendererComponent", "Ljava/awt/Component;", "item", "intellij.rider.plugins.unity"})
public final class UnityLogPanelEventRenderer
extends ColoredListCellRenderer<LogPanelItem>
implements ListCellRenderer<LogPanelItem> {
    @NotNull
    private final JLabel countLabel = new JLabel();
    @NotNull
    private final JPanel view = new JPanel((LayoutManager)new MigLayout("ins 0, fillx, gap 0, novisualpadding"));
    @NotNull
    private final UnityLogTokenizer tokenizer;

    public UnityLogPanelEventRenderer() {
        this.view.add((Component)((Object)this), "wmin 0, pushx");
        this.countLabel.setForeground(Color.GRAY);
        this.view.add((Component)this.countLabel, "east");
        this.tokenizer = new UnityLogTokenizer();
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends LogPanelItem> list, @NotNull LogPanelItem item, int index, boolean selected, boolean hasFocus) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.clear();
        this.setFont(list.getFont());
        this.mySelected = selected;
        this.myForeground = this.isEnabled() ? list.getForeground() : UIUtil.getLabelDisabledForeground();
        this.mySelectionForeground = list.getSelectionForeground();
        Color bg = UIUtil.isUnderWin10LookAndFeel() ? (selected ? list.getSelectionBackground() : list.getBackground()) : (selected ? list.getSelectionBackground() : null);
        this.setBackground(bg);
        this.countLabel.setBackground(bg);
        this.view.setBackground(bg);
        this.setPaintFocusBorder(hasFocus);
        this.customizeCellRenderer(list, item, index, selected, hasFocus);
        if (item.getCount() > 1) {
            this.countLabel.setText(" \u00d7" + item.getCount() + " ");
        } else {
            this.countLabel.setText("");
        }
        return this.view;
    }

    protected void customizeCellRenderer(@NotNull JList<? extends LogPanelItem> list, @Nullable LogPanelItem event, int index, boolean selected, boolean hasFocus) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        if (event != null) {
            Icon[] iconArray = new Icon[]{UnityLogPanelIconsKt.getIcon(event.getType()), UnityLogPanelIconsKt.getIcon(event.getMode())};
            this.setIcon((Icon)new RowIcon(iconArray));
            List<UnityLogTokenizer.Token> tokens = this.tokenizer.tokenize(event.getShortPresentation());
            for (UnityLogTokenizer.Token token : tokens) {
                if (token.getUsed()) continue;
                SimpleTextAttributes style = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                if (token.getBold() && token.getItalic()) {
                    style = new SimpleTextAttributes(3, token.getColor());
                } else if (token.getBold()) {
                    style = token.getColor() == null ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : new SimpleTextAttributes(1, token.getColor());
                } else if (token.getItalic()) {
                    style = token.getColor() == null ? SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES : new SimpleTextAttributes(1, token.getColor());
                } else if (token.getColor() != null) {
                    style = new SimpleTextAttributes(0, token.getColor());
                }
                this.append(token.getToken(), style);
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)list, (SimpleColoredComponent)((SimpleColoredComponent)this), (boolean)true, (boolean)selected);
        }
    }
}

