/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.toolWindow;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.jetbrains.rider.plugins.unity.UnityBundle;
import com.jetbrains.rider.plugins.unity.UnityProjectLifetimeService;
import com.jetbrains.rider.plugins.unity.toolWindow.UnityToolWindowContext;
import com.jetbrains.rider.plugins.unity.toolWindow.log.UnityLogPanelModel;
import com.jetbrains.rider.plugins.unity.toolWindow.log.UnityLogPanelView;
import icons.UnityIcons;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\u0006H\u0002J\u0006\u0010\n\u001a\u00020\u0006R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/plugins/unity/toolWindow/UnityToolWindowFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "context", "Lcom/jetbrains/rider/plugins/unity/toolWindow/UnityToolWindowContext;", "lock", "Ljava/lang/Object;", "create", "getOrCreateContext", "Companion", "intellij.rider.plugins.unity"})
public final class UnityToolWindowFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Object lock;
    @Nullable
    private UnityToolWindowContext context;
    @NotNull
    public static final String TOOL_WINDOW_ID = "Unity";
    @NotNull
    public static final String ACTION_PLACE = "Unity";

    public UnityToolWindowFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final UnityToolWindowContext getOrCreateContext() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            UnityToolWindowContext unityToolWindowContext = this.context;
            if (unityToolWindowContext == null) {
                unityToolWindowContext = this.create();
            }
            UnityToolWindowContext unityToolWindowContext2 = unityToolWindowContext;
            return unityToolWindowContext2;
        }
    }

    private final UnityToolWindowContext create() {
        UnityToolWindowContext twContext;
        Content content;
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.project);
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"BOTTOM");
        ToolWindow toolWindow = toolWindowManager.registerToolWindow("Unity", true, toolWindowAnchor, (Disposable)this.project, true, false);
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        toolWindow.setTitle("");
        toolWindow.setIcon(UnityIcons.ToolWindows.Companion.getUnityLog());
        UnityLogPanelModel logModel = new UnityLogPanelModel(UnityProjectLifetimeService.Companion.getLifetime(this.project), this.project, toolWindow);
        UnityLogPanelView logView = new UnityLogPanelView(UnityProjectLifetimeService.Companion.getLifetime(this.project), this.project, logModel, toolWindow);
        Content $this$create_u24lambda_u241 = content = contentManager2.getFactory().createContent(null, UnityBundle.Companion.message("tab.title.log", new Object[0]), true);
        boolean bl = false;
        StatusBarUtil.setStatusBarInfo((Project)this.project, (String)"");
        $this$create_u24lambda_u241.setComponent((JComponent)logView.getPanel());
        $this$create_u24lambda_u241.setCloseable(false);
        Content content2 = content;
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"apply(...)");
        Content toolWindowContent = content2;
        contentManager2.addContent(toolWindowContent);
        this.context = twContext = new UnityToolWindowContext(toolWindow, logModel);
        return twContext;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/plugins/unity/toolWindow/UnityToolWindowFactory$Companion;", "", "()V", "ACTION_PLACE", "", "TOOL_WINDOW_ID", "getInstance", "Lcom/jetbrains/rider/plugins/unity/toolWindow/UnityToolWindowFactory;", "project", "Lcom/intellij/openapi/project/Project;", "show", "", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UnityToolWindowFactory getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(UnityToolWindowFactory.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (UnityToolWindowFactory)object;
        }

        public final void show(@NotNull Project project) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Unity");
                if (toolWindow == null) break block0;
                toolWindow.show(null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

