/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.run.configurations;

import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.debuggerWorker.DebuggerStartInfoBase;
import com.jetbrains.rider.plugins.unity.model.debuggerWorker.UnityBundleInfo;
import com.jetbrains.rider.plugins.unity.model.debuggerWorker.UnityLocalUwpStartInfo;
import com.jetbrains.rider.plugins.unity.run.configurations.RunConfigurationUtilKt;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityAttachProfileState;
import com.jetbrains.rider.run.configurations.remote.RemoteConfiguration;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/unity/run/configurations/UnityAttachLocalUwpProfileState;", "Lcom/jetbrains/rider/plugins/unity/run/configurations/UnityAttachProfileState;", "remoteConfiguration", "Lcom/jetbrains/rider/run/configurations/remote/RemoteConfiguration;", "executionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "targetName", "", "packageName", "(Lcom/jetbrains/rider/run/configurations/remote/RemoteConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;Ljava/lang/String;Ljava/lang/String;)V", "createModelStartInfo", "Lcom/jetbrains/rider/model/debuggerWorker/DebuggerStartInfoBase;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider.plugins.unity"})
public final class UnityAttachLocalUwpProfileState
extends UnityAttachProfileState {
    @NotNull
    private final RemoteConfiguration remoteConfiguration;
    @NotNull
    private final String packageName;

    public UnityAttachLocalUwpProfileState(@NotNull RemoteConfiguration remoteConfiguration, @NotNull ExecutionEnvironment executionEnvironment, @NotNull String targetName, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)remoteConfiguration, (String)"remoteConfiguration");
        Intrinsics.checkNotNullParameter((Object)executionEnvironment, (String)"executionEnvironment");
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        super(remoteConfiguration, executionEnvironment, targetName, false);
        this.remoteConfiguration = remoteConfiguration;
        this.packageName = packageName;
    }

    @Override
    @Nullable
    public Object createModelStartInfo(@NotNull Lifetime lifetime, @NotNull Continuation<? super DebuggerStartInfoBase> $completion) {
        String string = this.remoteConfiguration.getAddress();
        int n = this.remoteConfiguration.getPort();
        List<UnityBundleInfo> list = RunConfigurationUtilKt.getUnityBundlesList();
        Project project = this.getExecutionEnvironment().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new UnityLocalUwpStartInfo(this.packageName, string, n, false, list, RunConfigurationUtilKt.getUnityPackagesList(project));
    }
}

