/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.run.configurations;

import com.intellij.execution.CantRunException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.debuggerWorker.DebuggerStartInfoBase;
import com.jetbrains.rider.plugins.unity.UnityBundle;
import com.jetbrains.rider.plugins.unity.model.debuggerWorker.UnityIosUsbStartInfo;
import com.jetbrains.rider.plugins.unity.run.configurations.RunConfigurationUtilKt;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityAttachProfileState;
import com.jetbrains.rider.plugins.unity.util.UnityInstallationFinder;
import com.jetbrains.rider.run.configurations.remote.RemoteConfiguration;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/plugins/unity/run/configurations/UnityAttachIosUsbProfileState;", "Lcom/jetbrains/rider/plugins/unity/run/configurations/UnityAttachProfileState;", "project", "Lcom/intellij/openapi/project/Project;", "remoteConfiguration", "Lcom/jetbrains/rider/run/configurations/remote/RemoteConfiguration;", "executionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "targetName", "", "deviceId", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/run/configurations/remote/RemoteConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;Ljava/lang/String;Ljava/lang/String;)V", "createModelStartInfo", "Lcom/jetbrains/rider/model/debuggerWorker/DebuggerStartInfoBase;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider.plugins.unity"})
public final class UnityAttachIosUsbProfileState
extends UnityAttachProfileState {
    @NotNull
    private final Project project;
    @NotNull
    private final RemoteConfiguration remoteConfiguration;
    @NotNull
    private final String deviceId;

    public UnityAttachIosUsbProfileState(@NotNull Project project, @NotNull RemoteConfiguration remoteConfiguration, @NotNull ExecutionEnvironment executionEnvironment, @NotNull String targetName, @NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)remoteConfiguration, (String)"remoteConfiguration");
        Intrinsics.checkNotNullParameter((Object)executionEnvironment, (String)"executionEnvironment");
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        super(remoteConfiguration, executionEnvironment, targetName, false);
        this.project = project;
        this.remoteConfiguration = remoteConfiguration;
        this.deviceId = deviceId;
    }

    @Override
    @Nullable
    public Object createModelStartInfo(@NotNull Lifetime lifetime, @NotNull Continuation<? super DebuggerStartInfoBase> $completion) {
        boolean bl;
        Path iosSupportPath;
        Path path = UnityInstallationFinder.Companion.getInstance(this.project).getAdditionalPlaybackEnginesRoot();
        Path path2 = iosSupportPath = path != null ? path.resolve("iOSSupport") : null;
        if (path2 != null) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            bl = !Files.isDirectory(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        } else {
            bl = false;
        }
        if (bl) {
            Object[] objectArray = new Object[]{iosSupportPath};
            throw new CantRunException(UnityBundle.Companion.message("dialog.message.unable.to.find.iossupport.folder", objectArray));
        }
        return new UnityIosUsbStartInfo(String.valueOf(iosSupportPath), this.deviceId, this.remoteConfiguration.getAddress(), this.remoteConfiguration.getPort(), false, RunConfigurationUtilKt.getUnityBundlesList(), RunConfigurationUtilKt.getUnityPackagesList(this.project));
    }
}

