/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.run;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.model.debuggerWorker.OutputMessageWithSubject;
import com.jetbrains.rider.model.debuggerWorker.OutputSubject;
import com.jetbrains.rider.model.debuggerWorker.OutputType;
import com.jetbrains.rider.plugins.unity.UnityBundle;
import com.jetbrains.rider.plugins.unity.util.UnityInstallationFinder;
import com.jetbrains.rider.run.IDebuggerOutputListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/plugins/unity/run/UnityDebuggerOutputListener;", "Lcom/jetbrains/rider/run/IDebuggerOutputListener;", "project", "Lcom/intellij/openapi/project/Project;", "host", "", "targetName", "isEditor", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "onOutputMessageAvailable", "", "message", "Lcom/jetbrains/rider/model/debuggerWorker/OutputMessageWithSubject;", "intellij.rider.plugins.unity"})
public final class UnityDebuggerOutputListener
implements IDebuggerOutputListener {
    @NotNull
    private final Project project;
    @NotNull
    private final String host;
    @NotNull
    private final String targetName;
    private final boolean isEditor;

    public UnityDebuggerOutputListener(@NotNull Project project, @NotNull String host, @NotNull String targetName, boolean isEditor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        this.project = project;
        this.host = host;
        this.targetName = targetName;
        this.isEditor = isEditor;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void onOutputMessageAvailable(@NotNull OutputMessageWithSubject message2) {
        block12: {
            DotNetDebugProcess debugProcess;
            String string;
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            if (message2.getSubject() != OutputSubject.ConnectionError) break block12;
            Object[] objectArray = new Object[]{this.targetName};
            Object text = UnityBundle.Companion.message("notification.content.unable.to.connect.to", objectArray);
            String unityVersion = UnityInstallationFinder.Companion.getInstance(this.project).getApplicationVersion(2);
            Ref.ObjectRef url = new Ref.ObjectRef();
            if (unityVersion != null && VersionComparatorUtil.compare((String)unityVersion, (String)"2018.2") >= 0) {
                url.element = "https://docs.unity3d.com/" + unityVersion + "/Documentation/Manual/ManagedCodeDebugging.html";
                string = this.isEditor ? UnityBundle.Companion.message("notification.content.please.follow.href.debugging.in.editor.documentation", new Object[0]) : UnityBundle.Companion.message("notification.content.please.follow.href.debugging.in.player.documentation", new Object[0]);
            } else if (this.isEditor) {
                string = UnityBundle.Companion.message("notification.content.please.ensure.editor.attaching.enabled.in.unity.s.external.tools.settings.page", new Object[0]);
            } else {
                Object[] objectArray2 = new Object[]{this.host};
                string = UnityBundle.Companion.message("notification.content.please.ensure.that.player.has.script.debugging.enabled.that.host.reachable", objectArray2);
            }
            text = (String)text + string;
            Notification debugNotification = XDebuggerManagerImpl.getNotificationGroup().createNotification((String)text, NotificationType.ERROR);
            if (url.element != null) {
                String string2 = UnityBundle.Companion.message("open.documentation", new Object[0]);
                debugNotification.addAction((AnAction)new NotificationAction((Ref.ObjectRef<String>)url, string2){
                    final /* synthetic */ Ref.ObjectRef<String> $url;
                    {
                        this.$url = $url;
                        super($super_call_param$1);
                    }

                    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                        BrowserUtil.browse((String)((String)this.$url.element));
                    }
                });
            }
            debugNotification.notify(this.project);
            XDebuggerManager debuggerManager = XDebuggerManager.getInstance((Project)this.project);
            XDebugSession xDebugSession = debuggerManager.getCurrentSession();
            XDebugProcess xDebugProcess = xDebugSession != null ? xDebugSession.getDebugProcess() : null;
            DotNetDebugProcess dotNetDebugProcess = debugProcess = xDebugProcess instanceof DotNetDebugProcess ? (DotNetDebugProcess)xDebugProcess : null;
            if (debugProcess != null) {
                ExecutionConsole console = debugProcess.getConsole();
                ConsoleView consoleView = console instanceof ConsoleView ? (ConsoleView)console : null;
                if (consoleView != null) {
                    String string3 = "\n" + (String)text;
                    consoleView.print(string3, switch (WhenMappings.$EnumSwitchMapping$0[message2.getType().ordinal()]) {
                        case 1 -> ConsoleViewContentType.NORMAL_OUTPUT;
                        case 2 -> ConsoleViewContentType.LOG_WARNING_OUTPUT;
                        case 3 -> ConsoleViewContentType.ERROR_OUTPUT;
                        default -> throw new NoWhenBranchMatchedException();
                    });
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OutputType.values().length];
            try {
                nArray[OutputType.Info.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OutputType.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OutputType.Error.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

