/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.explorer;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.ProjectExtensionsKt;
import com.jetbrains.rider.plugins.unity.explorer.AssetsRootNode;
import com.jetbrains.rider.plugins.unity.explorer.BuiltinPackageNode;
import com.jetbrains.rider.plugins.unity.explorer.BuiltinPackagesRootNode;
import com.jetbrains.rider.plugins.unity.explorer.PackageDependenciesRoot;
import com.jetbrains.rider.plugins.unity.explorer.PackageDependencyItemNode;
import com.jetbrains.rider.plugins.unity.explorer.PackageNode;
import com.jetbrains.rider.plugins.unity.explorer.PackagesRootNode;
import com.jetbrains.rider.plugins.unity.explorer.ReadOnlyPackagesRootNode;
import com.jetbrains.rider.plugins.unity.explorer.ReferenceRootNode;
import com.jetbrains.rider.plugins.unity.explorer.UnityExplorerFileSystemNode;
import com.jetbrains.rider.plugins.unity.explorer.UnknownPackageNode;
import com.jetbrains.rider.projectView.ideaInterop.RiderScratchProjectViewPane;
import com.jetbrains.rider.projectView.views.SolutionViewRootNodeBase;
import com.jetbrains.rider.projectView.views.actions.ConfigureScratchesAction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006H\u0014J \u0010\b\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\tj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007`\nH\u0016J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/UnityExplorerRootNode;", "Lcom/jetbrains/rider/projectView/views/SolutionViewRootNodeBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "calculateChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "createComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getSortKey", "", "node", "intellij.rider.plugins.unity"})
public final class UnityExplorerRootNode
extends SolutionViewRootNodeBase {
    public UnityExplorerRootNode(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    protected List<AbstractTreeNode<?>> calculateChildren() {
        VirtualFile packagesFolder;
        List nodes = new ArrayList();
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        VirtualFile virtualFile = ProjectExtensionsKt.getProjectDir(project).findChild("Assets");
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile assetsFolder = virtualFile;
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        nodes.add(new AssetsRootNode(project2, assetsFolder));
        Project project3 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"myProject");
        VirtualFile virtualFile2 = packagesFolder = ProjectExtensionsKt.getProjectDir(project3).findChild("Packages");
        boolean bl = virtualFile2 != null ? virtualFile2.exists() : false;
        if (bl) {
            Project project4 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"myProject");
            nodes.add(new PackagesRootNode(project4, packagesFolder));
        }
        Project project5 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"myProject");
        if (ConfigureScratchesAction.Companion.showScratchesInExplorer(project5)) {
            Project project6 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"myProject");
            nodes.add(RiderScratchProjectViewPane.Companion.createNode(project6));
        }
        return nodes;
    }

    @NotNull
    public Comparator<AbstractTreeNode<?>> createComparator() {
        Comparator comparator = super.createComparator();
        return (arg_0, arg_1) -> UnityExplorerRootNode.createComparator$lambda$0(this, comparator, arg_0, arg_1);
    }

    private final int getSortKey(AbstractTreeNode<?> node2) {
        AbstractTreeNode<?> abstractTreeNode = node2;
        return abstractTreeNode instanceof AssetsRootNode ? 1 : (abstractTreeNode instanceof PackagesRootNode ? 2 : (abstractTreeNode instanceof ReferenceRootNode ? 3 : (abstractTreeNode instanceof ReadOnlyPackagesRootNode ? 4 : (abstractTreeNode instanceof BuiltinPackagesRootNode ? 5 : (abstractTreeNode instanceof PackageNode ? 6 : (abstractTreeNode instanceof PackageDependenciesRoot ? 7 : (abstractTreeNode instanceof PackageDependencyItemNode ? 8 : (abstractTreeNode instanceof BuiltinPackageNode ? 9 : (abstractTreeNode instanceof UnknownPackageNode ? 100 : (abstractTreeNode instanceof UnityExplorerFileSystemNode ? 1000 : 10000))))))))));
    }

    private static final int createComparator$lambda$0(UnityExplorerRootNode this$0, Comparator $comparator, AbstractTreeNode node1, AbstractTreeNode node2) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$comparator, (String)"$comparator");
        Intrinsics.checkNotNull((Object)node1);
        int sortKey1 = this$0.getSortKey(node1);
        Intrinsics.checkNotNull((Object)node2);
        int sortKey2 = this$0.getSortKey(node2);
        if (sortKey1 != sortKey2) {
            return Intrinsics.compare((int)sortKey1, (int)sortKey2);
        }
        return $comparator.compare(node1, node2);
    }
}

