/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.explorer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.rider.plugins.unity.explorer.AncestorNodeType;
import com.jetbrains.rider.plugins.unity.explorer.AssetsRootNode;
import com.jetbrains.rider.plugins.unity.explorer.UnityExplorer;
import com.jetbrains.rider.plugins.unity.explorer.UnityExplorerFileSystemNode;
import com.jetbrains.rider.plugins.unity.explorer.UnityPluginExplorerBundle;
import com.jetbrains.rider.projectView.ProjectModelIconsKt;
import com.jetbrains.rider.projectView.views.FileSystemNodeBase;
import com.jetbrains.rider.projectView.views.NestingNode;
import com.jetbrains.rider.projectView.views.fileSystemExplorer.FileSystemExplorerCustomization;
import com.jetbrains.rider.projectView.views.solutionExplorer.SolutionExplorerViewPane;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceEntityErrorsSupport;
import icons.UnityIcons;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0016\u0018\u0000 92\u00020\u0001:\u00019B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J$\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007H\u0016J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00012\b\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J-\u0010\u001f\u001a\u0004\u0018\u00010\u00012\b\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0017\u0010 \u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\"0!\u00a2\u0006\u0002\b#H\u0002J\b\u0010$\u001a\u00020%H\u0016J\u0014\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010%H\u0016J\b\u0010)\u001a\u00020\u001eH\u0016J\b\u0010*\u001a\u00020\u001eH\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0016J\u0010\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u0005H\u0002J\b\u0010.\u001a\u00020\"H\u0016J\u0010\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u00020\u0005H\u0002J\u0010\u00101\u001a\u00020\"2\u0006\u00100\u001a\u00020\u0005H\u0002J\b\u00102\u001a\u00020\"H\u0002J\b\u00103\u001a\u00020\"H\u0002J\u0014\u00104\u001a\u00020\"2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0002J\u0010\u00105\u001a\u00020\"2\u0006\u00100\u001a\u00020\u0005H\u0002J\u0010\u00106\u001a\u00020\u001e2\u0006\u00107\u001a\u00020\u000fH\u0002J\u0010\u00108\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006:"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/UnityExplorerFileSystemNode;", "Lcom/jetbrains/rider/projectView/views/FileSystemNodeBase;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "nestedFiles", "", "Lcom/jetbrains/rider/projectView/views/NestingNode;", "descendentOf", "Lcom/jetbrains/rider/plugins/unity/explorer/AncestorNodeType;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;Lcom/jetbrains/rider/plugins/unity/explorer/AncestorNodeType;)V", "getDescendentOf", "()Lcom/jetbrains/rider/plugins/unity/explorer/AncestorNodeType;", "entities", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "getEntities", "()Ljava/util/List;", "addProjects", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "calculateIcon", "Ljavax/swing/Icon;", "containingProjectNode", "entity", "createNode", "findAncestor", "root", "name", "", "forEachAncestor", "action", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "getFileStatusColor", "Ljava/awt/Color;", "status", "getName", "getTestPresentation", "getVirtualFileChildren", "hasAssemblyDefinitionFile", "dir", "hasProblemFileBeneath", "isFolderEndingWithTilde", "file", "isIgnoredFolder", "isUnderAssemblyDefinition", "isUnderEditorFolder", "isUnderFirstpassFolder", "shouldShowVirtualFile", "stripDefaultProjectPrefix", "it", "update", "Companion", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nUnityExplorerFileSystemNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityExplorerFileSystemNode.kt\ncom/jetbrains/rider/plugins/unity/explorer/UnityExplorerFileSystemNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,384:1\n1747#2,3:385\n1603#2,9:390\n1855#2:399\n1856#2:401\n1612#2:402\n1549#2:403\n1620#2,3:404\n766#2:407\n857#2,2:408\n766#2:412\n857#2,2:413\n13309#3,2:388\n12474#3,2:410\n1#4:400\n*S KotlinDebug\n*F\n+ 1 UnityExplorerFileSystemNode.kt\ncom/jetbrains/rider/plugins/unity/explorer/UnityExplorerFileSystemNode\n*L\n88#1:385,3\n165#1:390,9\n165#1:399\n165#1:401\n165#1:402\n166#1:403\n166#1:404,3\n167#1:407\n167#1:408,2\n339#1:412\n339#1:413,2\n99#1:388,2\n274#1:410,2\n165#1:400\n*E\n"})
public class UnityExplorerFileSystemNode
extends FileSystemNodeBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AncestorNodeType descendentOf;

    public UnityExplorerFileSystemNode(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull List<NestingNode<VirtualFile>> nestedFiles, @NotNull AncestorNodeType descendentOf) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(nestedFiles, (String)"nestedFiles");
        Intrinsics.checkNotNullParameter((Object)((Object)descendentOf), (String)"descendentOf");
        super(project, virtualFile, nestedFiles);
        this.descendentOf = descendentOf;
    }

    @NotNull
    protected final AncestorNodeType getDescendentOf() {
        return this.descendentOf;
    }

    @NotNull
    public List<ProjectModelEntity> getEntities() {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project);
        VirtualFile virtualFile = this.getFile();
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        return CollectionsKt.toList((Iterable)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, (VirtualFile)virtualFile, (Project)project2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasProblemFileBeneath() {
        ProjectModelEntity it;
        Project project;
        if (!Registry.is((String)"projectView.showHierarchyErrors")) return false;
        Iterable $this$any$iv = this.getEntities();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (ProjectModelEntity)element$iv;
            boolean bl = false;
            project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        } while (!WorkspaceEntityErrorsSupport.Companion.getInstance(project).hasErrors(it));
        return true;
    }

    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        if (!this.getVirtualFile().isValid()) {
            return;
        }
        presentation.addText(this.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setIcon(this.calculateIcon());
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        FileSystemExplorerCustomization[] $this$forEach$iv = FileSystemExplorerCustomization.Companion.getExtensions(project);
        boolean $i$f$forEach2 = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            FileSystemExplorerCustomization element$iv;
            FileSystemExplorerCustomization it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.updateNode(presentation, this.getFile(), (FileSystemNodeBase)this);
        }
        boolean ignored = FileTypeManager.getInstance().isFileIgnored(this.getVirtualFile());
        if (ignored || this.descendentOf == AncestorNodeType.IgnoredFolder) {
            Object[] $i$f$forEach2 = new Object[]{"\u00b7"};
            presentation.addText(UnityPluginExplorerBundle.Companion.message("label.ignored.no.index", $i$f$forEach2), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        UnityExplorer unityExplorer = UnityExplorer.Companion.getInstance(project2);
        if (this.getVirtualFile().isDirectory() && unityExplorer.getShowProjectNames()) {
            this.addProjects(presentation);
        }
        if (Companion.isHiddenAsset(this.getVirtualFile()) || this.descendentOf == AncestorNodeType.HiddenAsset) {
            CharSequence charSequence = presentation.getTooltip();
            Object tooltip = charSequence == null || charSequence.length() == 0 ? "" : presentation.getTooltip() + "<br/>";
            Project project3 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"myProject");
            if (!SolutionExplorerViewPane.Companion.getInstance(project3).getMyShowAllFiles() && this.isFolderEndingWithTilde(this.getVirtualFile())) {
                tooltip = (String)tooltip + this.getVirtualFile().getName() + "<br/>";
            }
            presentation.setTooltip((String)tooltip + (this.getVirtualFile().isDirectory() ? UnityPluginExplorerBundle.Companion.message("tooltip.this.folder.not.imported.into.asset.database", new Object[0]) : UnityPluginExplorerBundle.Companion.message("tooltip.this.file.not.imported.into.asset.database", new Object[0])));
        }
        if (ignored) {
            CharSequence charSequence = presentation.getTooltip();
            String tooltip = charSequence == null || charSequence.length() == 0 ? "" : presentation.getTooltip() + "<br/>";
            presentation.setTooltip(tooltip + (this.getVirtualFile().isDirectory() ? UnityPluginExplorerBundle.Companion.message("tooltip.this.folder.matches.ignored.file.folders.pattern", new Object[0]) : UnityPluginExplorerBundle.Companion.message("tooltip.this.file.matches.ignored.file.folders.pattern", new Object[0])));
        }
    }

    @NotNull
    public String getName() {
        if (this.isFolderEndingWithTilde(this.getVirtualFile())) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            if (!SolutionExplorerViewPane.Companion.getInstance(project).getMyShowAllFiles()) {
                return StringsKt.removeSuffix((String)super.getName(), (CharSequence)"~");
            }
        }
        return super.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFolderEndingWithTilde(VirtualFile file) {
        if (this.descendentOf == AncestorNodeType.FileSystem) return false;
        if (!file.isDirectory()) return false;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string, (String)"~", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final boolean isIgnoredFolder(VirtualFile file) {
        return file.isDirectory() && FileTypeManager.getInstance().isFileIgnored(this.getVirtualFile());
    }

    /*
     * WARNING - void declaration
     */
    protected final void addProjects(@NotNull PresentationData presentation) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Iterable $this$mapNotNull$iv = this.getEntities();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        ProjectModelEntity projectModelEntity = $this$forEach$iv$iv$iv.iterator();
        while (projectModelEntity.hasNext()) {
            ProjectModelEntity it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = projectModelEntity.next();
            boolean bl = false;
            ProjectModelEntity it = (ProjectModelEntity)element$iv$iv;
            boolean bl2 = false;
            if (this.containingProjectNode(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            projectModelEntity = (ProjectModelEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.stripDefaultProjectPrefix((ProjectModelEntity)p0));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl4 = ((CharSequence)it).length() > 0;
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List projectNames = CollectionsKt.distinct((Iterable)CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE)));
        if (CollectionsKt.any((Iterable)projectNames)) {
            int maxProjectsInDescription = 3;
            int maxProjectsInTooltip = 10;
            Object description = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)projectNames, (int)maxProjectsInDescription), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            if (((Collection)projectNames).size() > maxProjectsInDescription) {
                Object object;
                description = (String)description + ", \u2026";
                String string = UnityPluginExplorerBundle.Companion.message("tooltip.contains.files.from.multiple.projects", new Object[0]);
                String string2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)projectNames, (int)maxProjectsInTooltip), (CharSequence)"<br/>", null, null, (int)0, null, null, (int)62, null);
                if (((Collection)projectNames).size() > maxProjectsInTooltip) {
                    Object[] objectArray = new Object[]{((Collection)projectNames).size() - maxProjectsInTooltip};
                    object = "<br/>" + UnityPluginExplorerBundle.Companion.message("tooltip.and.count.others", objectArray);
                } else {
                    object = "";
                }
                presentation.setTooltip(string + "<br/>" + string2 + (String)object);
            }
            presentation.addText(" (" + (String)description + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    private final String stripDefaultProjectPrefix(ProjectModelEntity it) {
        CharSequence charSequence = it.getName();
        Regex regex = UnityExplorer.Companion.getDefaultProjectPrefixRegex();
        String string = "";
        return regex.replace(charSequence, string);
    }

    private final ProjectModelEntity containingProjectNode(ProjectModelEntity entity2) {
        VirtualFile dir;
        if (this.descendentOf == AncestorNodeType.FileSystem) {
            return null;
        }
        if (ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)entity2)) {
            return null;
        }
        ProjectModelEntity projectModelEntity = ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)entity2);
        if (projectModelEntity == null) {
            return null;
        }
        ProjectModelEntity projectEntity = projectModelEntity;
        VirtualFileUrl virtualFileUrl = entity2.getUrl();
        Object object = dir = virtualFileUrl != null ? VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl) : null;
        if (dir != null && this.hasAssemblyDefinitionFile(dir)) {
            return projectEntity;
        }
        if (this.isUnderAssemblyDefinition()) {
            return null;
        }
        if (this.descendentOf == AncestorNodeType.Assets) {
            AbstractTreeNode abstractTreeNode;
            FileSystemNodeBase editor;
            if (Intrinsics.areEqual((Object)projectEntity.getName(), (Object)"Assembly-CSharp-Editor") && this.isUnderEditorFolder()) {
                return null;
            }
            if (Intrinsics.areEqual((Object)projectEntity.getName(), (Object)"Assembly-CSharp-firstpass") && UnityExplorerFileSystemNode.isUnderFirstpassFolder$default(this, null, 1, null)) {
                return null;
            }
            if (Intrinsics.areEqual((Object)projectEntity.getName(), (Object)"Assembly-CSharp-Editor-firstpass") && (editor = this.findAncestor((abstractTreeNode = this.getParent()) instanceof FileSystemNodeBase ? (FileSystemNodeBase)abstractTreeNode : null, "Editor")) != null && this.isUnderFirstpassFolder(editor)) {
                return null;
            }
        }
        return projectEntity;
    }

    private final FileSystemNodeBase forEachAncestor(FileSystemNodeBase root, Function1<? super FileSystemNodeBase, Boolean> action2) {
        FileSystemNodeBase node2 = root;
        while (node2 != null) {
            if (((Boolean)action2.invoke((Object)node2)).booleanValue()) {
                return node2;
            }
            AbstractTreeNode abstractTreeNode = node2.getParent();
            node2 = abstractTreeNode instanceof FileSystemNodeBase ? (FileSystemNodeBase)abstractTreeNode : null;
        }
        return null;
    }

    private final FileSystemNodeBase findAncestor(FileSystemNodeBase root, String name) {
        return this.forEachAncestor(root, (Function1<? super FileSystemNodeBase, Boolean>)((Function1)new Function1<FileSystemNodeBase, Boolean>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull FileSystemNodeBase $this$forEachAncestor) {
                Intrinsics.checkNotNullParameter((Object)$this$forEachAncestor, (String)"$this$forEachAncestor");
                return StringsKt.equals((String)$this$forEachAncestor.getName(), (String)this.$name, (boolean)true);
            }
        }));
    }

    private final boolean isUnderEditorFolder() {
        AbstractTreeNode abstractTreeNode = this.getParent();
        return this.findAncestor(abstractTreeNode instanceof FileSystemNodeBase ? (FileSystemNodeBase)abstractTreeNode : null, "Editor") != null;
    }

    private final boolean isUnderFirstpassFolder(FileSystemNodeBase root) {
        Object object = root;
        if (object == null) {
            AbstractTreeNode abstractTreeNode = this.getParent();
            object = abstractTreeNode instanceof FileSystemNodeBase ? (FileSystemNodeBase)abstractTreeNode : null;
        }
        return this.forEachAncestor((FileSystemNodeBase)object, (Function1<? super FileSystemNodeBase, Boolean>)((Function1)isUnderFirstpassFolder.1.INSTANCE)) != null;
    }

    static /* synthetic */ boolean isUnderFirstpassFolder$default(UnityExplorerFileSystemNode unityExplorerFileSystemNode, FileSystemNodeBase fileSystemNodeBase, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isUnderFirstpassFolder");
        }
        if ((n & 1) != 0) {
            fileSystemNodeBase = null;
        }
        return unityExplorerFileSystemNode.isUnderFirstpassFolder(fileSystemNodeBase);
    }

    private final boolean isUnderAssemblyDefinition() {
        AbstractTreeNode abstractTreeNode = this.getParent();
        return this.forEachAncestor(abstractTreeNode instanceof FileSystemNodeBase ? (FileSystemNodeBase)abstractTreeNode : null, (Function1<? super FileSystemNodeBase, Boolean>)((Function1)isUnderAssemblyDefinition.1.INSTANCE)) != null;
    }

    private final boolean hasAssemblyDefinitionFile(VirtualFile dir) {
        boolean bl;
        block1: {
            VirtualFile[] virtualFileArray = dir.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            Object[] $this$any$iv = virtualFileArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl2 = false;
                if (!StringsKt.equals((String)it.getExtension(), (String)"asmdef", (boolean)true)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final Icon calculateIcon() {
        block28: {
            block29: {
                Icon rootSpecialIcon;
                if (this.isIgnoredFolder(this.getVirtualFile()) || this.getVirtualFile().isDirectory() && this.descendentOf == AncestorNodeType.IgnoredFolder) {
                    return UnityIcons.Explorer.Companion.getUnloadedFolder();
                }
                if (this.descendentOf == AncestorNodeType.FileSystem) break block28;
                if (StringsKt.equals((String)this.getName(), (String)"Resources", (boolean)true)) {
                    return UnityIcons.Explorer.Companion.getResourcesFolder();
                }
                if (this.descendentOf != AncestorNodeType.Assets) break block29;
                if (StringsKt.equals((String)this.getName(), (String)"Editor", (boolean)true) && !this.isUnderAssemblyDefinition()) {
                    return UnityIcons.Explorer.Companion.getEditorFolder();
                }
                if (!(this.getParent() instanceof AssetsRootNode)) break block29;
                String string = this.getName();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                switch (string2) {
                    case "editor default resources": {
                        Icon icon = UnityIcons.Explorer.Companion.getEditorDefaultResourcesFolder();
                        break;
                    }
                    case "gizmos": {
                        Icon icon = UnityIcons.Explorer.Companion.getGizmosFolder();
                        break;
                    }
                    case "plugins": {
                        Icon icon = UnityIcons.Explorer.Companion.getPluginsFolder();
                        break;
                    }
                    case "standard assets": {
                        Icon icon = UnityIcons.Explorer.Companion.getAssetsFolder();
                        break;
                    }
                    case "pro standard assets": {
                        Icon icon = UnityIcons.Explorer.Companion.getAssetsFolder();
                        break;
                    }
                    case "streamingassets": {
                        Icon icon = UnityIcons.Explorer.Companion.getStreamingAssetsFolder();
                        break;
                    }
                    default: {
                        Icon icon = rootSpecialIcon = null;
                    }
                }
                if (rootSpecialIcon != null) {
                    return rootSpecialIcon;
                }
            }
            if (this.hasAssemblyDefinitionFile(this.getVirtualFile())) {
                return UnityIcons.Explorer.Companion.getAsmdefFolder();
            }
            if (this.getVirtualFile().isDirectory() && Companion.isHiddenAsset(this.getVirtualFile())) {
                return UnityIcons.Explorer.Companion.getUnloadedFolder();
            }
        }
        VirtualFile virtualFile = this.getVirtualFile();
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return ProjectModelIconsKt.calculateFileSystemIcon((VirtualFile)virtualFile, (Project)project);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public FileSystemNodeBase createNode(@NotNull VirtualFile virtualFile, @NotNull List<NestingNode<VirtualFile>> nestedFiles) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(nestedFiles, (String)"nestedFiles");
        if (this.isIgnoredFolder(virtualFile)) ** GOTO lbl-1000
        if (!virtualFile.isDirectory()) {
            v0 = virtualFile.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getParent(...)");
            ** if (!this.isIgnoredFolder((VirtualFile)v0)) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v1 = AncestorNodeType.IgnoredFolder;
            ** GOTO lbl12
        }
lbl-1000:
        // 2 sources

        {
            v1 = UnityExplorerFileSystemNode.Companion.isHiddenAsset(virtualFile) != false ? AncestorNodeType.HiddenAsset : this.descendentOf;
        }
lbl12:
        // 2 sources

        desc = v1;
        v2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"myProject");
        return new UnityExplorerFileSystemNode(v2, virtualFile, nestedFiles, desc);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<VirtualFile> getVirtualFileChildren() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = super.getVirtualFileChildren();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!this.shouldShowVirtualFile(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean shouldShowVirtualFile(VirtualFile file) {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        if (SolutionExplorerViewPane.Companion.getInstance(project).getMyShowAllFiles()) {
            return true;
        }
        if (this.isFolderEndingWithTilde(file)) {
            Project project2 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
            return UnityExplorer.Companion.getInstance(project2).getShowTildeFolders();
        }
        return !Companion.isHiddenAsset(file);
    }

    @NotNull
    public FileStatus getFileStatus() {
        FileStatus fileStatus;
        if (UnityExplorerFileSystemNode.Companion.isDescendantOfReadOnlyPackage(this)) {
            FileStatus fileStatus2 = FileStatus.NOT_CHANGED;
            Intrinsics.checkNotNull((Object)fileStatus2);
            fileStatus = fileStatus2;
        } else {
            fileStatus = super.getFileStatus();
        }
        return fileStatus;
    }

    @Nullable
    public Color getFileStatusColor(@Nullable FileStatus status) {
        Color color;
        if (UnityExplorerFileSystemNode.Companion.isDescendantOfReadOnlyPackage(this) && Intrinsics.areEqual((Object)status, (Object)FileStatus.NOT_CHANGED)) {
            FileStatus fileStatus = status;
            color = fileStatus != null ? fileStatus.getColor() : null;
        } else {
            color = super.getFileStatusColor(status);
        }
        return color;
    }

    @NotNull
    public String getTestPresentation() {
        if (this.getPresentation().getTooltip() != null) {
            return super.getTestPresentation() + ", tooltip=" + this.getPresentation().getTooltip();
        }
        return super.getTestPresentation();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/UnityExplorerFileSystemNode$Companion;", "", "()V", "isDescendantOfReadOnlyPackage", "", "node", "Lcom/jetbrains/rider/plugins/unity/explorer/UnityExplorerFileSystemNode;", "isHiddenAsset", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isHiddenAsset(@Nullable VirtualFile file) {
            block8: {
                block7: {
                    String extension;
                    String string;
                    if (file == null) {
                        return false;
                    }
                    String string2 = file.getExtension();
                    if (string2 != null) {
                        string = string2;
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                        String string3 = string.toLowerCase(locale);
                        v3 = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    } else {
                        v3 = extension = null;
                    }
                    if (extension != null && UnityExplorer.Companion.getIgnoredExtensions().contains(extension)) {
                        return true;
                    }
                    String string4 = file.getNameWithoutExtension();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getNameWithoutExtension(...)");
                    string = string4;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    String string5 = string.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                    String name = string5;
                    if (Intrinsics.areEqual((Object)name, (Object)"cvs")) break block7;
                    String string6 = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
                    if (!StringsKt.startsWith$default((String)string6, (String)".", (boolean)false, (int)2, null)) break block8;
                }
                return true;
            }
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return StringsKt.endsWith$default((String)string, (String)"~", (boolean)false, (int)2, null);
        }

        private final boolean isDescendantOfReadOnlyPackage(UnityExplorerFileSystemNode node2) {
            if (node2 == null) {
                return false;
            }
            if (node2.getDescendentOf() == AncestorNodeType.HiddenAsset || node2.getDescendentOf() == AncestorNodeType.IgnoredFolder) {
                AbstractTreeNode abstractTreeNode = node2.getParent();
                return this.isDescendantOfReadOnlyPackage(abstractTreeNode instanceof UnityExplorerFileSystemNode ? (UnityExplorerFileSystemNode)abstractTreeNode : null);
            }
            return node2.getDescendentOf() == AncestorNodeType.ReadOnlyPackage;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

