/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.explorer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.plugins.unity.explorer.AncestorNodeType;
import com.jetbrains.rider.plugins.unity.explorer.UnityExplorerFileSystemNode;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityReference;
import icons.UnityIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0016J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0014R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R$\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/ReferenceItemNode;", "Lcom/jetbrains/rider/plugins/unity/explorer/UnityExplorerFileSystemNode;", "project", "Lcom/intellij/openapi/project/Project;", "referenceName", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "entityPointers", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "Lkotlin/collections/ArrayList;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/ArrayList;)V", "entities", "", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "getEntities", "()Ljava/util/List;", "entity", "getEntity", "()Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "getEntityPointers", "()Ljava/util/ArrayList;", "entityReference", "getEntityReference", "()Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "isAlwaysLeaf", "", "navigate", "", "requestFocus", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nReferenceNodes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReferenceNodes.kt\ncom/jetbrains/rider/plugins/unity/explorer/ReferenceItemNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1603#2,9:83\n1855#2:92\n1856#2:94\n1612#2:95\n1#3:93\n*S KotlinDebug\n*F\n+ 1 ReferenceNodes.kt\ncom/jetbrains/rider/plugins/unity/explorer/ReferenceItemNode\n*L\n72#1:83,9\n72#1:92\n72#1:94\n72#1:95\n72#1:93\n*E\n"})
public final class ReferenceItemNode
extends UnityExplorerFileSystemNode {
    @NotNull
    private final String referenceName;
    @NotNull
    private final ArrayList<ProjectModelEntityReference> entityPointers;

    public ReferenceItemNode(@NotNull Project project, @NotNull String referenceName, @NotNull VirtualFile virtualFile, @NotNull ArrayList<ProjectModelEntityReference> entityPointers) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)referenceName, (String)"referenceName");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(entityPointers, (String)"entityPointers");
        super(project, virtualFile, CollectionsKt.emptyList(), AncestorNodeType.References);
        this.referenceName = referenceName;
        this.entityPointers = entityPointers;
    }

    @NotNull
    public ArrayList<ProjectModelEntityReference> getEntityPointers() {
        return this.entityPointers;
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.setPresentableText(this.referenceName);
        presentation.setIcon(UnityIcons.Explorer.Companion.getReference());
    }

    public void navigate(boolean requestFocus) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ProjectModelEntity> getEntities() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getEntityPointers();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ProjectModelEntity it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ProjectModelEntityReference it = (ProjectModelEntityReference)element$iv$iv;
            boolean bl2 = false;
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            if (it.getEntity(project) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public ProjectModelEntity getEntity() {
        ProjectModelEntity projectModelEntity;
        ProjectModelEntityReference projectModelEntityReference = this.getEntityReference();
        if (projectModelEntityReference != null) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            projectModelEntity = projectModelEntityReference.getEntity(project);
        } else {
            projectModelEntity = null;
        }
        return projectModelEntity;
    }

    @Nullable
    public ProjectModelEntityReference getEntityReference() {
        return (ProjectModelEntityReference)CollectionsKt.firstOrNull((List)this.getEntityPointers());
    }

    @Override
    @NotNull
    public FileStatus getFileStatus() {
        FileStatus fileStatus = FileStatus.NOT_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"NOT_CHANGED");
        return fileStatus;
    }
}

