/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.explorer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.rider.plugins.unity.explorer.AncestorNodeType;
import com.jetbrains.rider.plugins.unity.explorer.PackageDependenciesRoot;
import com.jetbrains.rider.plugins.unity.explorer.PackageNodesKt;
import com.jetbrains.rider.plugins.unity.explorer.UnityExplorer;
import com.jetbrains.rider.plugins.unity.explorer.UnityExplorerFileSystemNode;
import com.jetbrains.rider.plugins.unity.explorer.UnityPluginExplorerBundle;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.UnityPackageSource;
import com.jetbrains.rider.plugins.unity.workspace.UnityPackageEntity;
import com.jetbrains.rider.projectView.views.SolutionViewUtilsKt;
import icons.UnityIcons;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\fH\u0014J\u0015\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/PackageNode;", "Lcom/jetbrains/rider/plugins/unity/explorer/UnityExplorerFileSystemNode;", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "project", "Lcom/intellij/openapi/project/Project;", "packageFolder", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageEntity", "Lcom/jetbrains/rider/plugins/unity/workspace/UnityPackageEntity;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/rider/plugins/unity/workspace/UnityPackageEntity;)V", "calculateChildren", "", "compareTo", "", "other", "getName", "", "getTooltipForPackageEntity", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.rider.plugins.unity"})
public final class PackageNode
extends UnityExplorerFileSystemNode
implements Comparable<AbstractTreeNode<?>> {
    @NotNull
    private final UnityPackageEntity packageEntity;

    public PackageNode(@NotNull Project project, @NotNull VirtualFile packageFolder, @NotNull UnityPackageEntity packageEntity) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)packageFolder, (String)"packageFolder");
        Intrinsics.checkNotNullParameter((Object)packageEntity, (String)"packageEntity");
        super(project, packageFolder, CollectionsKt.emptyList(), AncestorNodeType.Companion.fromPackageData(packageEntity));
        this.packageEntity = packageEntity;
        this.setIcon(switch (WhenMappings.$EnumSwitchMapping$0[this.packageEntity.getSource().ordinal()]) {
            case 1 -> UnityIcons.Explorer.Companion.getReferencedPackage();
            case 2 -> UnityIcons.Explorer.Companion.getEmbeddedPackage();
            case 3 -> UnityIcons.Explorer.Companion.getLocalPackage();
            case 4 -> UnityIcons.Explorer.Companion.getLocalTarballPackage();
            case 5 -> UnityIcons.Explorer.Companion.getBuiltInPackage();
            case 6 -> UnityIcons.Explorer.Companion.getGitPackage();
            case 7 -> UnityIcons.Explorer.Companion.getUnknownPackage();
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    @Override
    @NotNull
    public String getName() {
        return this.packageEntity.getDisplayName();
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        String string;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.addText(this.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setIcon(this.getIcon());
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        SolutionViewUtilsKt.addNonIndexedMark((PresentationData)presentation, (Project)project, (VirtualFile)this.getVirtualFile());
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        if (UnityExplorer.Companion.getInstance(project2).getShowProjectNames()) {
            this.addProjects(presentation);
        }
        if ((string = presentation.getTooltip()) == null) {
            string = "";
        }
        String existingTooltip = string;
        String tooltip = "<html>" + PackageNodesKt.access$getPackageTooltip(this.getName(), this.packageEntity) + this.getTooltipForPackageEntity(this.packageEntity) + (String)(((CharSequence)existingTooltip).length() > 0 ? "<br/><br/>" + existingTooltip : "") + "</html>";
        presentation.setTooltip(tooltip);
    }

    @NlsSafe
    private final String getTooltipForPackageEntity(UnityPackageEntity packageEntity) {
        return switch (WhenMappings.$EnumSwitchMapping$0[packageEntity.getSource().ordinal()]) {
            case 2 -> {
                if (!Intrinsics.areEqual((Object)this.getVirtualFile().getName(), (Object)this.getName())) {
                    Object[] var2_2 = new Object[2];
                    var2_2[0] = "<br/><br/>";
                    Intrinsics.checkNotNullExpressionValue((Object)this.getVirtualFile().getName(), (String)"getName(...)");
                    yield UnityPluginExplorerBundle.Companion.message("folder.name", var2_2);
                }
                yield "";
            }
            case 3 -> {
                Object[] var2_3 = new Object[2];
                var2_3[0] = "<br/><br/>";
                Intrinsics.checkNotNullExpressionValue((Object)this.getVirtualFile().getPath(), (String)"getPath(...)");
                yield UnityPluginExplorerBundle.Companion.message("folder.location", var2_3);
            }
            case 4 -> {
                Object[] var2_4 = new Object[2];
                var2_4[0] = "<br/><br/>";
                String v1 = packageEntity.getTarballLocation();
                if (v1 == null) {
                    v1 = "";
                }
                var2_4[1] = v1;
                yield UnityPluginExplorerBundle.Companion.message("tarball.location", var2_4);
            }
            case 6 -> {
                void var2_5;
                String v2;
                Object text = "<br/><br/>";
                Object var3_6 = (Object[])packageEntity.getGitUrl();
                if (!(var3_6 == null || var3_6.length() == 0)) {
                    var3_6 = new Object[1];
                    Intrinsics.checkNotNull((Object)packageEntity.getGitUrl());
                    v2 = UnityPluginExplorerBundle.Companion.message("git.url", (Object[])var3_6);
                } else {
                    v2 = UnityPluginExplorerBundle.Companion.message("unknown.git.url", new Object[0]);
                }
                text = (String)text + v2;
                var3_6 = packageEntity.getGitHash();
                if (!(var3_6 == null || var3_6.length() == 0)) {
                    var3_6 = new Object[2];
                    var3_6[0] = "<br/>";
                    Intrinsics.checkNotNull((Object)packageEntity.getGitHash());
                    text = (String)text + UnityPluginExplorerBundle.Companion.message("hash.in.tooltip", (Object[])var3_6);
                }
                if (!((var3_6 = (CharSequence)packageEntity.getGitRevision()) == null || var3_6.length() == 0)) {
                    var3_6 = new Object[2];
                    var3_6[0] = "<br/>";
                    Intrinsics.checkNotNull((Object)packageEntity.getGitRevision());
                    text = (String)text + UnityPluginExplorerBundle.Companion.message("revision.in.tooltip", (Object[])var3_6);
                }
                yield var2_5;
            }
            default -> "";
        };
    }

    @NotNull
    protected List<AbstractTreeNode<?>> calculateChildren() {
        List children = super.calculateChildren();
        if (!this.packageEntity.getDependencies().isEmpty()) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            children.add(0, new PackageDependenciesRoot(project, this.packageEntity));
        }
        return children;
    }

    @Override
    public int compareTo(@NotNull AbstractTreeNode<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE).compare(this.getName(), other.getName());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UnityPackageSource.values().length];
            try {
                nArray[UnityPackageSource.Registry.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnityPackageSource.Embedded.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnityPackageSource.Local.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnityPackageSource.LocalTarball.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnityPackageSource.BuiltIn.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnityPackageSource.Git.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnityPackageSource.Unknown.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

