/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.explorer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.plugins.unity.explorer.PackageDependencyItemNode;
import com.jetbrains.rider.plugins.unity.workspace.UnityPackageEntity;
import com.jetbrains.rider.projectView.views.SolutionViewNode;
import icons.UnityIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/PackageDependenciesRoot;", "Lcom/jetbrains/rider/projectView/views/SolutionViewNode;", "", "project", "Lcom/intellij/openapi/project/Project;", "packageEntity", "Lcom/jetbrains/rider/plugins/unity/workspace/UnityPackageEntity;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/plugins/unity/workspace/UnityPackageEntity;)V", "calculateChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "contains", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.rider.plugins.unity"})
public final class PackageDependenciesRoot
extends SolutionViewNode<Object> {
    @NotNull
    private final UnityPackageEntity packageEntity;

    public PackageDependenciesRoot(@NotNull Project project, @NotNull UnityPackageEntity packageEntity) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)packageEntity, (String)"packageEntity");
        super(project, (Object)packageEntity);
        this.packageEntity = packageEntity;
    }

    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.setPresentableText("Dependencies");
        presentation.setIcon(UnityIcons.Explorer.Companion.getDependenciesRoot());
    }

    @NotNull
    protected List<AbstractTreeNode<?>> calculateChildren() {
        List children = new ArrayList();
        for (Map.Entry<String, String> entry : this.packageEntity.getDependencies().entrySet()) {
            String name = entry.getKey();
            String version = entry.getValue();
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            children.add(new PackageDependencyItemNode(project, name, version));
        }
        return children;
    }

    public boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return false;
    }
}

