/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.explorer;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.prefix.set.MutablePrefixTreeSet;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.plugins.unity.UnityProjectLifetimeService;
import com.jetbrains.rider.plugins.unity.explorer.UnityExplorerFileSystemNode;
import com.jetbrains.rider.plugins.unity.explorer.UnityPluginExplorerBundle;
import com.jetbrains.rider.plugins.unity.workspace.UnityWorkspacePackageUpdater;
import com.jetbrains.rider.projectView.VfsBackendRequester;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\b\b\u0007\u0018\u0000 '2\u00020\u0001:\u0004'()*B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0002J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010!\u001a\u00020\f2\u000e\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0#J\u000e\u0010$\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0005J\"\u0010%\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00052\b\u0010&\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/MetaTracker;", "Lcom/jetbrains/rider/projectView/VfsBackendRequester;", "()V", "actionsPerProject", "", "Lcom/intellij/openapi/project/Project;", "Lcom/jetbrains/rider/plugins/unity/explorer/MetaTracker$MetaActionList;", "lock", "Ljava/lang/Object;", "projects", "", "createMetaFile", "", "parent", "Lcom/intellij/openapi/vfs/VirtualFile;", "metaFileName", "", "ls", "getMetaFile", "file", "Ljava/nio/file/Path;", "path", "getMetaFileName", "fileName", "getOrCreate", "project", "isApplicableForProject", "", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "isMetaFile", "isUndoRedoInProgress", "isValidEvent", "onEvent", "events", "", "register", "shouldCreateMetaFile", "assetFile", "Companion", "MetaAction", "MetaActionList", "MetaGroupId", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nMetaTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetaTracker.kt\ncom/jetbrains/rider/plugins/unity/explorer/MetaTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,289:1\n1#2:290\n766#3:291\n857#3,2:292\n13#4:294\n13#5:295\n*S KotlinDebug\n*F\n+ 1 MetaTracker.kt\ncom/jetbrains/rider/plugins/unity/explorer/MetaTracker\n*L\n63#1:291\n63#1:292,2\n50#1:294\n50#1:295\n*E\n"})
public final class MetaTracker
implements VfsBackendRequester {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object lock = new Object();
    @NotNull
    private Set<Project> projects = new LinkedHashSet();
    @NotNull
    private final Map<Project, MetaActionList> actionsPerProject = new LinkedHashMap();
    @NotNull
    private static final Logger logger;

    public final void register(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Lifetime lifetime = UnityProjectLifetimeService.Companion.getLifetime(project);
        lifetime.bracketIfAlive((Function0)new Function0<Boolean>(this, project){
            final /* synthetic */ MetaTracker this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final Boolean invoke() {
                Boolean bl;
                Object object = MetaTracker.access$getLock$p(this.this$0);
                MetaTracker metaTracker = this.this$0;
                Project project = this.$project;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl2 = false;
                    bl = MetaTracker.access$getProjects$p(metaTracker).add(project);
                }
                return bl;
            }
        }, (Function0)new Function0<Unit>(this, project){
            final /* synthetic */ MetaTracker this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Object object = MetaTracker.access$getLock$p(this.this$0);
                MetaTracker metaTracker = this.this$0;
                Project project = this.$project;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    MetaTracker.access$getProjects$p(metaTracker).remove(project);
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void onEvent(@NotNull List<? extends VFileEvent> events) {
        void $this$filterTo$iv$iv;
        Iterable $i$a$-synchronized-MetaTracker$onEvent$unityProjects$232;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Object object = this.lock;
        synchronized (object) {
            List list;
            boolean $i$a$-synchronized-MetaTracker$onEvent$unityProjects$232 = false;
            List it = list = (List)new ArrayList();
            boolean bl3 = false;
            it.addAll((Collection)this.projects);
            $i$a$-synchronized-MetaTracker$onEvent$unityProjects$232 = list;
        }
        Iterable $this$filter$iv = $i$a$-synchronized-MetaTracker$onEvent$unityProjects$232;
        boolean bl = false;
        $i$a$-synchronized-MetaTracker$onEvent$unityProjects$232 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Project it = (Project)element$iv$iv;
            boolean bl2 = false;
            if (!(!this.isUndoRedoInProgress(it) && !it.isDisposed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unityProjects = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        for (VFileEvent vFileEvent : events) {
            if (!this.isValidEvent(vFileEvent)) continue;
            for (Project project : unityProjects) {
                if (!this.isApplicableForProject(vFileEvent, project)) continue;
                MetaActionList actions = this.getOrCreate(project);
                if (this.isMetaFile(vFileEvent)) {
                    Path path = Paths.get(vFileEvent.getPath(), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    actions.addInitialSetOfChangedMetaFiles(path);
                    continue;
                }
                try {
                    Path metaFile;
                    VFileEvent bl3 = vFileEvent;
                    if (bl3 instanceof VFileCreateEvent) {
                        String string = ((VFileCreateEvent)vFileEvent).getChildName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getChildName(...)");
                        String metaFileName = this.getMetaFileName(string);
                        Path metaFile2 = ((VFileCreateEvent)vFileEvent).getParent().toNioPath().resolve(metaFileName);
                        Object object2 = ((VFileCreateEvent)vFileEvent).getFile();
                        if (object2 == null || (object2 = object2.getDetectedLineSeparator()) == null) {
                            object2 = "\n";
                        }
                        Object ls = object2;
                        Intrinsics.checkNotNull((Object)metaFile2);
                        actions.add(metaFile2, project, (Function0<Unit>)((Function0)new Function0<Unit>(this, project, vFileEvent, metaFileName, (String)ls){
                            final /* synthetic */ MetaTracker this$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ VFileEvent $event;
                            final /* synthetic */ String $metaFileName;
                            final /* synthetic */ String $ls;
                            {
                                this.this$0 = $receiver;
                                this.$project = $project;
                                this.$event = $event;
                                this.$metaFileName = $metaFileName;
                                this.$ls = $ls;
                                super(0);
                            }

                            public final void invoke() {
                                VirtualFile virtualFile = ((VFileCreateEvent)this.$event).getFile();
                                VirtualFile virtualFile2 = ((VFileCreateEvent)this.$event).getParent();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getParent(...)");
                                if (MetaTracker.access$shouldCreateMetaFile(this.this$0, this.$project, virtualFile, virtualFile2)) {
                                    VirtualFile virtualFile3 = ((VFileCreateEvent)this.$event).getParent();
                                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getParent(...)");
                                    MetaTracker.access$createMetaFile(this.this$0, virtualFile3, this.$metaFileName, this.$ls);
                                }
                            }
                        }));
                        continue;
                    }
                    if (bl3 instanceof VFileDeleteEvent) {
                        if (this.getMetaFile(((VFileDeleteEvent)vFileEvent).getPath()) == null) continue;
                        actions.add(metaFile, project, (Function0<Unit>)((Function0)new Function0<Unit>(metaFile, this){
                            final /* synthetic */ Path $metaFile;
                            final /* synthetic */ MetaTracker this$0;
                            {
                                this.$metaFile = $metaFile;
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                VirtualFile fileToDelete = VfsUtil.findFile((Path)this.$metaFile, (boolean)true);
                                if (fileToDelete != null) {
                                    VirtualFileUtil.readBytes((VirtualFile)fileToDelete);
                                    fileToDelete.delete((Object)this.this$0);
                                }
                            }
                        }));
                        continue;
                    }
                    if (bl3 instanceof VFileCopyEvent) {
                        if (this.getMetaFile(((VFileCopyEvent)vFileEvent).getFile().getPath()) == null) continue;
                        String string = ((VFileCopyEvent)vFileEvent).getFile().getDetectedLineSeparator();
                        if (string == null) {
                            string = "\n";
                        }
                        String ls = string;
                        actions.add(metaFile, project, (Function0<Unit>)((Function0)new Function0<Unit>(this, project, vFileEvent, ls){
                            final /* synthetic */ MetaTracker this$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ VFileEvent $event;
                            final /* synthetic */ String $ls;
                            {
                                this.this$0 = $receiver;
                                this.$project = $project;
                                this.$event = $event;
                                this.$ls = $ls;
                                super(0);
                            }

                            public final void invoke() {
                                VirtualFile virtualFile = ((VFileCopyEvent)this.$event).getFile();
                                VirtualFile virtualFile2 = ((VFileCopyEvent)this.$event).getNewParent();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getNewParent(...)");
                                if (MetaTracker.access$shouldCreateMetaFile(this.this$0, this.$project, virtualFile, virtualFile2)) {
                                    VirtualFile virtualFile3 = ((VFileCopyEvent)this.$event).getNewParent();
                                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getNewParent(...)");
                                    String string = ((VFileCopyEvent)this.$event).getNewChildName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNewChildName(...)");
                                    MetaTracker.access$createMetaFile(this.this$0, virtualFile3, MetaTracker.access$getMetaFileName(this.this$0, string), this.$ls);
                                }
                            }
                        }));
                        continue;
                    }
                    if (bl3 instanceof VFileMoveEvent) {
                        if (this.getMetaFile(((VFileMoveEvent)vFileEvent).getOldPath()) == null) continue;
                        actions.add(metaFile, project, (Function0<Unit>)((Function0)new Function0<Unit>(metaFile, this, vFileEvent){
                            final /* synthetic */ Path $metaFile;
                            final /* synthetic */ MetaTracker this$0;
                            final /* synthetic */ VFileEvent $event;
                            {
                                this.$metaFile = $metaFile;
                                this.this$0 = $receiver;
                                this.$event = $event;
                                super(0);
                            }

                            public final void invoke() {
                                block0: {
                                    VirtualFile virtualFile = VfsUtil.findFile((Path)this.$metaFile, (boolean)true);
                                    if (virtualFile == null) break block0;
                                    virtualFile.move((Object)this.this$0, ((VFileMoveEvent)this.$event).getNewParent());
                                }
                            }
                        }));
                        continue;
                    }
                    if (!(bl3 instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)vFileEvent).isRename() || this.getMetaFile(((VFilePropertyChangeEvent)vFileEvent).getOldPath()) == null) continue;
                    actions.add(metaFile, project, (Function0<Unit>)((Function0)new Function0<Unit>(this, vFileEvent, metaFile){
                        final /* synthetic */ MetaTracker this$0;
                        final /* synthetic */ VFileEvent $event;
                        final /* synthetic */ Path $metaFile;
                        {
                            this.this$0 = $receiver;
                            this.$event = $event;
                            this.$metaFile = $metaFile;
                            super(0);
                        }

                        public final void invoke() {
                            block1: {
                                VirtualFile conflictingMeta;
                                Object object = ((VFilePropertyChangeEvent)this.$event).getNewValue();
                                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                                String target = MetaTracker.access$getMetaFileName(this.this$0, (String)object);
                                VirtualFile origin = VfsUtil.findFile((Path)this.$metaFile, (boolean)true);
                                VirtualFile virtualFile = origin;
                                VirtualFile virtualFile2 = virtualFile != null && (virtualFile = virtualFile.getParent()) != null ? virtualFile.findChild(target) : (conflictingMeta = null);
                                if (conflictingMeta != null) {
                                    MetaTracker.access$getLogger$cp().warn("Removing conflicting meta " + conflictingMeta);
                                    conflictingMeta.delete((Object)this.this$0);
                                }
                                VirtualFile virtualFile3 = origin;
                                if (virtualFile3 == null) break block1;
                                virtualFile3.rename((Object)this.this$0, target);
                            }
                        }
                    }));
                }
                catch (Throwable t) {
                    logger.error(t);
                }
            }
        }
    }

    private final MetaActionList getOrCreate(Project project) {
        MetaActionList actions = this.actionsPerProject.get(project);
        if (actions == null) {
            actions = new MetaActionList(project);
            CollectionExKt.addUnique(this.actionsPerProject, (Lifetime)UnityProjectLifetimeService.Companion.getLifetime(project), (Object)project, (Object)actions);
        }
        return actions;
    }

    private final boolean isValidEvent(VFileEvent event) {
        if (event.isFromRefresh()) {
            return false;
        }
        if (!(event.getFileSystem() instanceof LocalFileSystem)) {
            return false;
        }
        return CommandProcessor.getInstance().getCurrentCommand() != null;
    }

    private final boolean isUndoRedoInProgress(Project project) {
        return UndoManager.getInstance((Project)project).isUndoOrRedoInProgress();
    }

    private final boolean isMetaFile(VFileEvent event) {
        Object object = event.getFile();
        if (object == null || (object = object.getExtension()) == null) {
            object = PathUtil.getFileExtension((String)event.getPath());
        }
        Object extension = object;
        return StringsKt.equals((String)"meta", (String)extension, (boolean)true);
    }

    private final boolean isApplicableForProject(VFileEvent event, Project project) {
        ApplicationKt.getApplication().assertIsDispatchThread();
        VirtualFile virtualFile = event.getFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        return CollectionsKt.any((Iterable)UnityWorkspacePackageUpdater.Companion.getInstance(project).getSourceRootsTree().getAncestors((Object)file));
    }

    private final Path getMetaFile(String path) {
        if (path == null) {
            return null;
        }
        Path file = Paths.get(path, new String[0]);
        Intrinsics.checkNotNull((Object)file);
        String metaFileName = this.getMetaFileName(PathsKt.getName((Path)file));
        return file.getParent().resolve(metaFileName);
    }

    private final VirtualFile getMetaFile(VirtualFile file) {
        if (file == null) {
            return null;
        }
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String metaFileName = this.getMetaFileName(string);
        VirtualFile virtualFile = file.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
        return VirtualFileUtil.findFile((VirtualFile)virtualFile, (String)metaFileName);
    }

    private final String getMetaFileName(String fileName) {
        return fileName + ".meta";
    }

    private final boolean shouldCreateMetaFile(Project project, VirtualFile assetFile, VirtualFile parent) {
        ApplicationKt.getApplication().assertIsDispatchThread();
        MutablePrefixTreeSet<VirtualFile> roots = UnityWorkspacePackageUpdater.Companion.getInstance(project).getSourceRootsTree();
        if (UnityExplorerFileSystemNode.Companion.isHiddenAsset(assetFile) || !roots.contains((Object)parent) && this.getMetaFile(parent) == null) {
            logger.info("avoid adding meta file for " + assetFile + ".");
            return false;
        }
        return true;
    }

    private final void createMetaFile(VirtualFile parent, String metaFileName, String ls) {
        VirtualFile virtualFile = parent.createChildData((Object)this, metaFileName);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"createChildData(...)");
        VirtualFile metaFile = virtualFile;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null);
        int n = 0;
        int n2 = 32;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String guid = string3;
        long timestamp = LocalDateTime.now(ZoneOffset.UTC).atZone(ZoneOffset.UTC).toEpochSecond();
        String content = "fileFormatVersion: 2" + ls + "guid: " + guid + ls + "timeCreated: " + timestamp;
        VfsUtil.saveText((VirtualFile)metaFile, (String)content);
    }

    public static final /* synthetic */ Object access$getLock$p(MetaTracker $this) {
        return $this.lock;
    }

    public static final /* synthetic */ Set access$getProjects$p(MetaTracker $this) {
        return $this.projects;
    }

    public static final /* synthetic */ boolean access$shouldCreateMetaFile(MetaTracker $this, Project project, VirtualFile assetFile, VirtualFile parent) {
        return $this.shouldCreateMetaFile(project, assetFile, parent);
    }

    public static final /* synthetic */ void access$createMetaFile(MetaTracker $this, VirtualFile parent, String metaFileName, String ls) {
        $this.createMetaFile(parent, metaFileName, ls);
    }

    public static final /* synthetic */ String access$getMetaFileName(MetaTracker $this, String fileName) {
        return $this.getMetaFileName(fileName);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MetaTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        MetaTracker.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/MetaTracker$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/plugins/unity/explorer/MetaTracker;", "intellij.rider.plugins.unity"})
    @SourceDebugExtension(value={"SMAP\nMetaTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetaTracker.kt\ncom/jetbrains/rider/plugins/unity/explorer/MetaTracker$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,289:1\n40#2,3:290\n*S KotlinDebug\n*F\n+ 1 MetaTracker.kt\ncom/jetbrains/rider/plugins/unity/explorer/MetaTracker$Companion\n*L\n49#1:290,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MetaTracker getInstance() {
            boolean $i$f$service = false;
            Class<MetaTracker> serviceClass$iv = MetaTracker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (MetaTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u000e\u001a\u00020\bR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/MetaTracker$MetaAction;", "", "metaFile", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "action", "Lkotlin/Function0;", "", "(Ljava/nio/file/Path;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "getMetaFile", "()Ljava/nio/file/Path;", "getProject", "()Lcom/intellij/openapi/project/Project;", "execute", "intellij.rider.plugins.unity"})
    private static final class MetaAction {
        @NotNull
        private final Path metaFile;
        @NotNull
        private final Project project;
        @NotNull
        private final Function0<Unit> action;

        public MetaAction(@NotNull Path metaFile, @NotNull Project project, @NotNull Function0<Unit> action2) {
            Intrinsics.checkNotNullParameter((Object)metaFile, (String)"metaFile");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            this.metaFile = metaFile;
            this.project = project;
            this.action = action2;
        }

        @NotNull
        public final Path getMetaFile() {
            return this.metaFile;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public final void execute() {
            try {
                this.action.invoke();
            }
            catch (Throwable ex) {
                logger.error(ex);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\nJ\b\u0010\u0014\u001a\u00020\u000eH\u0002J\u0006\u0010\u0015\u001a\u00020\u000eJ\b\u0010\u0016\u001a\u00020\u0017H\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/MetaTracker$MetaActionList;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "actions", "", "Lcom/jetbrains/rider/plugins/unity/explorer/MetaTracker$MetaAction;", "changedMetaFiles", "Ljava/util/HashSet;", "Ljava/nio/file/Path;", "nextGroupIdIndex", "", "add", "", "metaFile", "action", "Lkotlin/Function0;", "addInitialSetOfChangedMetaFiles", "path", "clear", "execute", "getCommandName", "", "intellij.rider.plugins.unity"})
    @SourceDebugExtension(value={"SMAP\nMetaTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetaTracker.kt\ncom/jetbrains/rider/plugins/unity/explorer/MetaTracker$MetaActionList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,289:1\n1855#2,2:290\n*S KotlinDebug\n*F\n+ 1 MetaTracker.kt\ncom/jetbrains/rider/plugins/unity/explorer/MetaTracker$MetaActionList\n*L\n249#1:290,2\n*E\n"})
    private static final class MetaActionList {
        @NotNull
        private final HashSet<Path> changedMetaFiles;
        @NotNull
        private final List<MetaAction> actions;
        private int nextGroupIdIndex;

        public MetaActionList(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            MessageBusConnection connection = project.getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)UnityProjectLifetimeService.Companion.getLifetime(project), null, (int)1, null));
            Topic topic = CommandListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            connection.subscribe(topic, (Object)new CommandListener(){

                public void beforeCommandFinished(@NotNull CommandEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.execute();
                    this.clear();
                    super.beforeCommandFinished(event);
                }
            });
            this.changedMetaFiles = new HashSet();
            this.actions = new ArrayList();
        }

        private final void clear() {
            ApplicationKt.getApplication().assertIsDispatchThread();
            this.changedMetaFiles.clear();
            this.actions.clear();
        }

        public final void addInitialSetOfChangedMetaFiles(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.changedMetaFiles.add(path);
        }

        public final void add(@NotNull Path metaFile, @NotNull Project project, @NotNull Function0<Unit> action2) {
            Intrinsics.checkNotNullParameter((Object)metaFile, (String)"metaFile");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            if (this.changedMetaFiles.contains(metaFile)) {
                return;
            }
            this.actions.add(new MetaAction(metaFile, project, action2));
        }

        public final void execute() {
            if (this.actions.isEmpty()) {
                return;
            }
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            Ref.ObjectRef groupId = new Ref.ObjectRef();
            groupId.element = commandProcessor.getCurrentCommandGroupId();
            if (groupId.element == null) {
                int n = this.nextGroupIdIndex;
                this.nextGroupIdIndex = n + 1;
                groupId.element = new MetaGroupId(n);
                commandProcessor.setCurrentCommandGroupId(groupId.element);
            }
            commandProcessor.allowMergeGlobalCommands(() -> MetaActionList.execute$lambda$3(this, commandProcessor, groupId));
        }

        @Nls
        @NotNull
        public final String getCommandName() {
            String string;
            if (((Collection)this.actions).size() == 1) {
                Object[] objectArray = new Object[]{PathsKt.getName((Path)((MetaAction)CollectionsKt.single(this.actions)).getMetaFile())};
                string = UnityPluginExplorerBundle.Companion.message("process.one.meta.file", objectArray);
            } else {
                Object[] objectArray = new Object[]{((Collection)this.actions).size()};
                string = UnityPluginExplorerBundle.Companion.message("process.several.meta.files", objectArray);
            }
            return string;
        }

        private static final void execute$lambda$3$lambda$2$lambda$1$lambda$0(MetaActionList this$0, MetaAction $it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
            if (!this$0.changedMetaFiles.contains($it.getMetaFile())) {
                $it.execute();
            }
        }

        private static final void execute$lambda$3$lambda$2$lambda$1(MetaActionList this$0, MetaAction $it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
            ApplicationKt.getApplication().runWriteAction(() -> MetaActionList.execute$lambda$3$lambda$2$lambda$1$lambda$0(this$0, $it));
        }

        private static final void execute$lambda$3(MetaActionList this$0, CommandProcessor $commandProcessor, Ref.ObjectRef $groupId) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$groupId, (String)"$groupId");
            Iterable $this$forEach$iv = this$0.actions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MetaAction it = (MetaAction)element$iv;
                boolean bl = false;
                $commandProcessor.executeCommand(it.getProject(), () -> MetaActionList.execute$lambda$3$lambda$2$lambda$1(this$0, it), this$0.getCommandName(), $groupId.element);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/MetaTracker$MetaGroupId;", "", "index", "", "(I)V", "getIndex", "()I", "toString", "", "intellij.rider.plugins.unity"})
    private static final class MetaGroupId {
        private final int index;

        public MetaGroupId(int index) {
            this.index = index;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public String toString() {
            return "MetaGroupId" + this.index;
        }
    }
}

