/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.explorer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.rider.plugins.unity.explorer.AncestorNodeType;
import com.jetbrains.rider.plugins.unity.explorer.PackageNodesKt;
import com.jetbrains.rider.plugins.unity.explorer.UnityExplorerFileSystemNode;
import com.jetbrains.rider.plugins.unity.workspace.UnityPackageEntity;
import com.jetbrains.rider.projectView.views.FileSystemNodeBase;
import com.jetbrains.rider.projectView.views.NestingNode;
import com.jetbrains.rider.projectView.views.SolutionViewUtilsKt;
import com.jetbrains.rider.projectView.views.solutionExplorer.SolutionExplorerViewPane;
import icons.UnityIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0015\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0096\u0002J$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00160\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/BuiltinPackageNode;", "Lcom/jetbrains/rider/plugins/unity/explorer/UnityExplorerFileSystemNode;", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "project", "Lcom/intellij/openapi/project/Project;", "packageEntity", "Lcom/jetbrains/rider/plugins/unity/workspace/UnityPackageEntity;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/plugins/unity/workspace/UnityPackageEntity;)V", "calculateChildren", "", "canNavigateToSource", "", "compareTo", "", "other", "createNode", "Lcom/jetbrains/rider/projectView/views/FileSystemNodeBase;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "nestedFiles", "", "Lcom/jetbrains/rider/projectView/views/NestingNode;", "getName", "", "navigate", "", "requestFocus", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nPackageNodes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageNodes.kt\ncom/jetbrains/rider/plugins/unity/explorer/BuiltinPackageNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,397:1\n1726#2,3:398\n*S KotlinDebug\n*F\n+ 1 PackageNodes.kt\ncom/jetbrains/rider/plugins/unity/explorer/BuiltinPackageNode\n*L\n287#1:398,3\n*E\n"})
public final class BuiltinPackageNode
extends UnityExplorerFileSystemNode
implements Comparable<AbstractTreeNode<?>> {
    @NotNull
    private final UnityPackageEntity packageEntity;

    public BuiltinPackageNode(@NotNull Project project, @NotNull UnityPackageEntity packageEntity) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)packageEntity, (String)"packageEntity");
        VirtualFile virtualFile = packageEntity.getPackageFolder();
        Intrinsics.checkNotNull((Object)virtualFile);
        super(project, virtualFile, CollectionsKt.emptyList(), AncestorNodeType.ReadOnlyPackage);
        this.packageEntity = packageEntity;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected List<AbstractTreeNode<?>> calculateChildren() {
        block11: {
            block12: {
                v0 = this.myProject;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"myProject");
                if (SolutionExplorerViewPane.Companion.getInstance(v0).getMyShowAllFiles()) {
                    return super.calculateChildren();
                }
                children = super.calculateChildren();
                $this$all$iv = children;
                $i$f$all = false;
                if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) break block12;
                v1 = true;
                break block11;
            }
            for (T element$iv : $this$all$iv) {
                it = (AbstractTreeNode)element$iv;
                $i$a$-all-BuiltinPackageNode$calculateChildren$1 = false;
                v2 = var8_8 = it.getName();
                if (v2 != null) {
                    Intrinsics.checkNotNull((Object)v2);
                    v3 = StringsKt.startsWith$default((String)var8_8, (String)"package.json", (boolean)false, (int)2, null);
                } else {
                    v3 = false;
                }
                if (v3) ** GOTO lbl-1000
                v4 = var8_8 = it.getName();
                if (v4 != null) {
                    Intrinsics.checkNotNull((Object)v4);
                    v5 = StringsKt.startsWith$default((String)var8_8, (String)".icon.png", (boolean)false, (int)2, null);
                } else {
                    v5 = false;
                }
                if (v5) ** GOTO lbl-1000
                v6 = var8_8 = it.getName();
                if (v6 != null) {
                    Intrinsics.checkNotNull((Object)v6);
                    v7 = StringsKt.startsWith$default((String)var8_8, (String)"package.ModuleCompilationTrigger", (boolean)false, (int)2, null);
                } else {
                    v7 = false;
                }
                if (v7) lbl-1000:
                // 3 sources

                {
                    v8 = true;
                } else {
                    v8 = false;
                }
                if (v8) continue;
                v1 = false;
                break block11;
            }
            v1 = true;
        }
        if (v1) {
            return new ArrayList<E>();
        }
        return super.calculateChildren();
    }

    @Override
    @NotNull
    public FileSystemNodeBase createNode(@NotNull VirtualFile virtualFile, @NotNull List<NestingNode<VirtualFile>> nestedFiles) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(nestedFiles, (String)"nestedFiles");
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return new UnityExplorerFileSystemNode(project, virtualFile, nestedFiles, this.getDescendentOf());
    }

    public boolean canNavigateToSource() {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        if (SolutionExplorerViewPane.Companion.getInstance(project).getMyShowAllFiles()) {
            return super.canNavigateToSource();
        }
        return true;
    }

    public void navigate(boolean requestFocus) {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        if (SolutionExplorerViewPane.Companion.getInstance(project).getMyShowAllFiles()) {
            super.navigate(requestFocus);
            return;
        }
        VirtualFile packageJson = this.getVirtualFile().findChild("package.json");
        if (packageJson != null) {
            new OpenFileDescriptor(this.myProject, packageJson).navigate(requestFocus);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.packageEntity.getDisplayName();
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        String tooltip;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.addText(this.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setIcon(UnityIcons.Explorer.Companion.getBuiltInPackage());
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        if (SolutionExplorerViewPane.Companion.getInstance(project).getMyShowAllFiles()) {
            Project project2 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
            SolutionViewUtilsKt.addNonIndexedMark((PresentationData)presentation, (Project)project2, (VirtualFile)this.getVirtualFile());
        }
        if (!Intrinsics.areEqual((Object)(tooltip = PackageNodesKt.access$getPackageTooltip(this.getName(), this.packageEntity)), (Object)this.getName())) {
            presentation.setTooltip(tooltip);
        }
    }

    @Override
    public int compareTo(@NotNull AbstractTreeNode<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE).compare(this.getName(), other.getName());
    }
}

