/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.explorer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdSolutionDescriptor;
import com.jetbrains.rider.model.RdSolutionState;
import com.jetbrains.rider.plugins.unity.UnityBundle;
import com.jetbrains.rider.plugins.unity.explorer.AncestorNodeType;
import com.jetbrains.rider.plugins.unity.explorer.ReferenceRootNode;
import com.jetbrains.rider.plugins.unity.explorer.UnityExplorerFileSystemNode;
import com.jetbrains.rider.projectView.ProjectModelStatuses;
import com.jetbrains.rider.projectView.views.SolutionViewUtilsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceProjectsCount;
import icons.UnityIcons;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\fH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0010\u0010\u0007\u001a\u00020\b8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/AssetsRootNode;", "Lcom/jetbrains/rider/plugins/unity/explorer/UnityExplorerFileSystemNode;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "assets", "", "referenceRoot", "Lcom/jetbrains/rider/plugins/unity/explorer/ReferenceRootNode;", "calculateChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "isAlwaysExpand", "", "isSolutionOrProjectsSync", "presentProjectsCount", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "count", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceProjectsCount$ProjectsCount;", "showZero", "update", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nAssetsRootNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssetsRootNode.kt\ncom/jetbrains/rider/plugins/unity/explorer/AssetsRootNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1747#2,3:86\n*S KotlinDebug\n*F\n+ 1 AssetsRootNode.kt\ncom/jetbrains/rider/plugins/unity/explorer/AssetsRootNode\n*L\n56#1:86,3\n*E\n"})
public final class AssetsRootNode
extends UnityExplorerFileSystemNode {
    @NotNull
    private final ReferenceRootNode referenceRoot;
    @NlsSafe
    @NotNull
    private final String assets;

    public AssetsRootNode(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        super(project, virtualFile, CollectionsKt.emptyList(), AncestorNodeType.Assets);
        this.referenceRoot = new ReferenceRootNode(project);
        this.assets = "Assets";
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        if (!this.getVirtualFile().isValid()) {
            return;
        }
        presentation.addText(this.assets, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setIcon(UnityIcons.Explorer.Companion.getAssetsRoot());
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getSolutionEntity((WorkspaceModel)WorkspaceModel.Companion.getInstance(project));
        if (projectModelEntity == null) {
            return;
        }
        ProjectModelEntity solutionEntity = projectModelEntity;
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = solutionEntity.getDescriptor();
        RdSolutionDescriptor rdSolutionDescriptor = rdProjectModelItemDescriptor instanceof RdSolutionDescriptor ? (RdSolutionDescriptor)rdProjectModelItemDescriptor : null;
        if (rdSolutionDescriptor == null) {
            return;
        }
        RdSolutionDescriptor descriptor = rdSolutionDescriptor;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        WorkspaceProjectsCount.ProjectsCount projectsCount = WorkspaceProjectsCount.Companion.getInstance(project2).get(solutionEntity);
        if (this.isSolutionOrProjectsSync()) {
            SolutionViewUtilsKt.presentSyncNode((PresentationData)presentation);
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[descriptor.getState().ordinal()]) {
                case 1: {
                    if (projectsCount.getFailed() + projectsCount.getUnloaded() <= 0) break;
                    this.presentProjectsCount(presentation, projectsCount, true);
                    break;
                }
                case 2: {
                    SolutionViewUtilsKt.addAdditionalText((PresentationData)presentation, (String)UnityBundle.Companion.message("load.failed", new Object[0]));
                    break;
                }
                case 3: {
                    this.presentProjectsCount(presentation, projectsCount, true);
                }
            }
        }
    }

    private final boolean isSolutionOrProjectsSync() {
        boolean bl;
        block4: {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            ProjectModelStatuses projectModelStatuses = ProjectModelStatuses.Companion.getInstance(project);
            if (projectModelStatuses.isSolutionInSync()) {
                return true;
            }
            Project project2 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
            List projects = WorkspaceModelExtensionsKt.findProjects((WorkspaceModel)WorkspaceModel.Companion.getInstance(project2));
            Iterable $this$any$iv = projects;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ProjectModelEntity project3 = (ProjectModelEntity)element$iv;
                    boolean bl2 = false;
                    if (!(projectModelStatuses.getProjectStatus(project3) != null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void presentProjectsCount(PresentationData presentation, WorkspaceProjectsCount.ProjectsCount count, boolean showZero) {
        Object[] objectArray;
        if (count.getTotal() == 0 && !showZero) {
            return;
        }
        Object text = null;
        int unloadedCount = count.getFailed() + count.getUnloaded();
        if (count.getTotal() == 1) {
            objectArray = new Object[]{count.getTotal()};
            text = UnityBundle.Companion.message("one.project.count", objectArray);
        } else {
            objectArray = new Object[]{count.getTotal()};
            text = UnityBundle.Companion.message("many.projects.count", objectArray);
        }
        if (unloadedCount > 0) {
            objectArray = new Object[]{unloadedCount};
            text = (String)text + UnityBundle.Companion.message("unloaded.projects.count", objectArray);
        }
        SolutionViewUtilsKt.addAdditionalText((PresentationData)presentation, (String)text);
    }

    public boolean isAlwaysExpand() {
        return true;
    }

    @NotNull
    protected List<AbstractTreeNode<?>> calculateChildren() {
        List result = super.calculateChildren();
        result.add(0, this.referenceRoot);
        return result;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdSolutionState.values().length];
            try {
                nArray[RdSolutionState.Default.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdSolutionState.WithErrors.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdSolutionState.WithWarnings.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

