/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.diff;

import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.merge.external.AutomaticExternalMergeTool;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.tools.external.ExternalDiffToolUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.plugins.unity.EngineConstants;
import com.jetbrains.rider.plugins.unity.ideaInterop.fileTypes.yaml.UnityYamlFileType;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendModel_PregeneratedKt;
import com.jetbrains.rider.plugins.unity.util.UnityInstallationFinder;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\u000e\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/plugins/unity/diff/UnityYamlAutomaticExternalMergeTool;", "Lcom/intellij/diff/merge/external/AutomaticExternalMergeTool;", "()V", "canProcessOutputContent", "", "content", "Lcom/intellij/diff/contents/DiffContent;", "canShow", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lcom/intellij/diff/merge/MergeRequest;", "show", "", "tryExecuteMerge", "externalMergeTool", "Lcom/intellij/diff/tools/external/ExternalDiffSettings$ExternalTool;", "Lcom/intellij/diff/merge/ThreesideMergeRequest;", "Companion", "intellij.rider.plugins.unity"})
public final class UnityYamlAutomaticExternalMergeTool
implements AutomaticExternalMergeTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger myLogger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void show(@Nullable Project project, @NotNull MergeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (project == null) {
            return;
        }
        Path path = UnityInstallationFinder.Companion.getInstance(project).getApplicationContentsPath();
        if (path == null) {
            return;
        }
        Path appDataPath = path;
        String extension = SystemInfo.isWindows ? ".exe" : "";
        String tempDir = System.getProperty("java.io.tmpdir");
        Path premergedBase = Paths.get(tempDir, new String[0]).resolve("premergedBase_" + request.hashCode());
        Path premergedRight = Paths.get(tempDir, new String[0]).resolve("premergedRight_" + request.hashCode());
        try {
            boolean isMergeTrustExitCode = true;
            String mergeToolName = StringsKt.contains$default((CharSequence)((Object)appDataPath).toString(), (CharSequence)EngineConstants.INSTANCE.getTuanjieEngineName(), (boolean)false, (int)2, null) ? EngineConstants.INSTANCE.getTuanjieEngineName() + "YAMLMerge" : EngineConstants.INSTANCE.getUnityEngineName() + "YAMLMerge";
            String mergeExePath = ((Object)appDataPath.resolve("Tools/" + mergeToolName + extension)).toString();
            String mergeParametersFromBackend = (String)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)FrontendBackendModel_PregeneratedKt.getFrontendBackendModel(SolutionHostExtensionsKt.getSolution((Project)project)).getBackendSettings().getMergeParameters()));
            String mergeParameters = StringsKt.contains$default((CharSequence)mergeParametersFromBackend, (CharSequence)" -p ", (boolean)false, (int)2, null) ? mergeParametersFromBackend + " " + premergedBase + " " + premergedRight : mergeParametersFromBackend;
            myLogger.info("PreMerge with " + mergeExePath + " " + mergeParameters);
            ExternalDiffSettings.ExternalTool externalTool = new ExternalDiffSettings.ExternalTool(null, mergeExePath, mergeParameters, isMergeTrustExitCode, ExternalDiffSettings.ExternalToolGroup.MERGE_TOOL, 1, null);
            if (this.tryExecuteMerge(project, externalTool, (ThreesideMergeRequest)request)) return;
            Intrinsics.checkNotNull((Object)premergedBase);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(premergedBase, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Intrinsics.checkNotNull((Object)premergedRight);
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.exists(premergedRight, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    myLogger.info("PreMerge partially successful. Call ShowMergeBuiltin on pre-merged.");
                    DiffContent diffContent = ((ThreesideMergeRequest)request).getOutputContent();
                    Intrinsics.checkNotNull((Object)diffContent, (String)"null cannot be cast to non-null type com.intellij.diff.contents.FileContent");
                    VirtualFile virtualFile = ((FileContent)diffContent).getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                    VirtualFile output = virtualFile;
                    byte[][] byArrayArray = new byte[3][];
                    byArrayArray[0] = FilesKt.readBytes((File)DocumentUtilKt.toIOFile((VirtualFile)output));
                    Intrinsics.checkNotNullExpressionValue((Object)Files.readAllBytes(premergedBase), (String)"readAllBytes(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)Files.readAllBytes(premergedRight), (String)"readAllBytes(...)");
                    List byteContents = CollectionsKt.listOf((Object[])((Object[])byArrayArray));
                    MergeRequest mergeRequest = DiffRequestFactory.getInstance().createMergeRequest(project, output, byteContents, ((ThreesideMergeRequest)request).getTitle(), ((ThreesideMergeRequest)request).getContentTitles());
                    Intrinsics.checkNotNullExpressionValue((Object)mergeRequest, (String)"createMergeRequest(...)");
                    MergeRequest preMerged = mergeRequest;
                    MergeCallback.retarget((MergeRequest)request, (MergeRequest)preMerged);
                    DiffManagerEx.getInstance().showMergeBuiltin(project, preMerged);
                    return;
                }
            }
            myLogger.info("PreMerge unsuccessful. Call ShowMergeBuiltin.");
            DiffManagerEx.getInstance().showMergeBuiltin(project, request);
            return;
        }
        finally {
            Intrinsics.checkNotNull((Object)premergedBase);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(premergedBase, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                PathKt.delete$default((Path)premergedBase, (boolean)false, (int)1, null);
            }
            Intrinsics.checkNotNull((Object)premergedRight);
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (Files.exists(premergedRight, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                PathKt.delete$default((Path)premergedRight, (boolean)false, (int)1, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean tryExecuteMerge(Project project, ExternalDiffSettings.ExternalTool externalMergeTool, ThreesideMergeRequest request) {
        request.onAssigned(true);
        try {
            if (ExternalDiffToolUtil.tryExecuteMerge((Project)project, (ExternalDiffSettings.ExternalTool)externalMergeTool, (ThreesideMergeRequest)request, null)) {
                myLogger.info("Merge with external tool was fully successful. Apply result.");
                request.applyResult(MergeResult.RESOLVED);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            myLogger.error("UnityYamlMerge failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            request.onAssigned(false);
        }
    }

    public boolean canShow(@Nullable Project project, @NotNull MergeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (project == null) {
            return false;
        }
        if (!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)FrontendBackendModel_PregeneratedKt.getFrontendBackendModel(SolutionHostExtensionsKt.getSolution((Project)project)).getBackendSettings().getUseUnityYamlMerge()))) {
            return false;
        }
        if (request instanceof ThreesideMergeRequest) {
            DiffContent diffContent = ((ThreesideMergeRequest)request).getOutputContent();
            Intrinsics.checkNotNullExpressionValue((Object)diffContent, (String)"getOutputContent(...)");
            DiffContent outputContent = diffContent;
            if (!this.canProcessOutputContent(outputContent)) {
                return false;
            }
            List list = ((ThreesideMergeRequest)request).getContents();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContents(...)");
            List contents = list;
            if (contents.size() != 3) {
                return false;
            }
            Iterator iterator = contents.iterator();
            while (iterator.hasNext()) {
                DiffContent content;
                DiffContent diffContent2 = content = (DiffContent)iterator.next();
                Intrinsics.checkNotNull((Object)diffContent2);
                if (ExternalDiffToolUtil.canCreateFile((DiffContent)diffContent2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private final boolean canProcessOutputContent(DiffContent content) {
        return content instanceof FileContent && ((FileContent)content).getFile().isInLocalFileSystem() && Intrinsics.areEqual((Object)((FileContent)content).getFile().getFileType(), (Object)((Object)UnityYamlFileType.INSTANCE));
    }

    static {
        Logger logger = Logger.getInstance(UnityYamlAutomaticExternalMergeTool.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        myLogger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/plugins/unity/diff/UnityYamlAutomaticExternalMergeTool$Companion;", "", "()V", "myLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

