/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.debugger.breakpoints;

import com.intellij.openapi.project.Project;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.rider.plugins.unity.debugger.breakpoints.UnityPausepointBreakpointType;
import com.jetbrains.rider.plugins.unity.debugger.breakpoints.UnityPausepointConstants;
import com.jetbrains.rider.plugins.unity.debugger.breakpoints.UnityPausepointsKt;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u0016\u0010\u0010\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/plugins/unity/debugger/breakpoints/UnityPausepointPanel;", "Lcom/intellij/xdebugger/breakpoints/ui/XBreakpointCustomPropertiesPanel;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "activatePausepointHyperlink", "Lcom/intellij/ui/HyperlinkLabel;", "currentListener", "Ljavax/swing/event/HyperlinkListener;", "getComponent", "Ljavax/swing/JComponent;", "loadFrom", "", "breakpoint", "saveTo", "intellij.rider.plugins.unity"})
public final class UnityPausepointPanel
extends XBreakpointCustomPropertiesPanel<XLineBreakpoint<DotNetLineBreakpointProperties>> {
    @NotNull
    private final Project project;
    @NotNull
    private final HyperlinkLabel activatePausepointHyperlink;
    @Nullable
    private HyperlinkListener currentListener;

    public UnityPausepointPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.activatePausepointHyperlink = new HyperlinkLabel(UnityPausepointConstants.INSTANCE.getConvertToPausepointLabelLinkText());
    }

    public void loadFrom(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        boolean isPausepoint = breakpoint.getType() instanceof UnityPausepointBreakpointType;
        this.activatePausepointHyperlink.setHyperlinkText(isPausepoint ? UnityPausepointConstants.INSTANCE.getConvertToLineBreakpointLabelLinkText() : UnityPausepointConstants.INSTANCE.getConvertToPausepointLabelLinkText());
        HyperlinkListener listener2 = arg_0 -> UnityPausepointPanel.loadFrom$lambda$0(isPausepoint, this, breakpoint, arg_0);
        if (this.currentListener != null) {
            this.activatePausepointHyperlink.removeHyperlinkListener(this.currentListener);
        }
        this.currentListener = listener2;
        this.activatePausepointHyperlink.addHyperlinkListener(listener2);
    }

    public void saveTo(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.activatePausepointHyperlink;
    }

    private static final void loadFrom$lambda$0(boolean $isPausepoint, UnityPausepointPanel this$0, XLineBreakpoint $breakpoint, HyperlinkEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$breakpoint, (String)"$breakpoint");
        if (!$isPausepoint) {
            UnityPausepointsKt.convertToPausepoint$default(this$0.project, $breakpoint, null, null, 12, null);
        } else {
            UnityPausepointsKt.convertToLineBreakpoint$default(this$0.project, $breakpoint, null, null, 12, null);
        }
    }
}

