/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.debugger.breakpoints;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.debugger.DotNetBreakpointsManager;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.rider.plugins.unity.FrontendBackendHostKt;
import com.jetbrains.rider.plugins.unity.debugger.breakpoints.UnityPausepointBreakpointType;
import com.jetbrains.rider.plugins.unity.model.debuggerWorker.UnityPausepointAdditionalDataModel;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendModel;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendModel_PregeneratedKt;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityAttachProfileState;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityAttachToEditorRunConfiguration;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u00020\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J\u0014\u0010\u0010\u001a\u00020\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u001c\u0010\u0014\u001a\u00020\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001e\u0010\u0018\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0019\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/plugins/unity/debugger/breakpoints/UnityPausepointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "debugProcess", "Lcom/jetbrains/rider/debugger/DotNetDebugProcess;", "(Lcom/jetbrains/rider/debugger/DotNetDebugProcess;)V", "registeredBreakpoints", "", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "unityModel", "Lcom/jetbrains/rider/plugins/unity/model/frontendBackend/FrontendBackendModel;", "advisePlayModeChanges", "", "doRegisterBreakpoint", "breakpoint", "doUnregisterBreakpoint", "isInPlayMode", "", "isSupportedSession", "markBreakpointDisabledInSession", "message", "", "registerBreakpoint", "unregisterBreakpoint", "temporary", "intellij.rider.plugins.unity"})
public final class UnityPausepointHandler
extends XBreakpointHandler<XLineBreakpoint<DotNetLineBreakpointProperties>> {
    @NotNull
    private final DotNetDebugProcess debugProcess;
    @NotNull
    private final FrontendBackendModel unityModel;
    @NotNull
    private final Set<XBreakpoint<?>> registeredBreakpoints;

    public UnityPausepointHandler(@NotNull DotNetDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        super(UnityPausepointBreakpointType.class);
        this.debugProcess = debugProcess;
        this.unityModel = FrontendBackendModel_PregeneratedKt.getFrontendBackendModel(SolutionHostExtensionsKt.getSolution((Project)this.debugProcess.getProject()));
        this.registeredBreakpoints = new LinkedHashSet();
        if (this.isSupportedSession()) {
            this.advisePlayModeChanges();
        }
    }

    public void registerBreakpoint(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        if (!this.isSupportedSession()) {
            this.markBreakpointDisabledInSession(breakpoint, "Unity pausepoints are only available when debugging a Unity editor process");
            return;
        }
        if (FrontendBackendHostKt.isConnectedToEditor(this.debugProcess.getProject()) && !this.isInPlayMode()) {
            this.markBreakpointDisabledInSession(breakpoint, "Unity pausepoints are only available in play mode");
        } else {
            this.doRegisterBreakpoint(breakpoint);
        }
    }

    public void unregisterBreakpoint(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint, boolean temporary) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        if (this.isSupportedSession()) {
            this.doUnregisterBreakpoint(breakpoint);
        }
    }

    private final void advisePlayModeChanges() {
        this.unityModel.getPlayControls().getPlay().getChange().advise(this.debugProcess.getSessionLifetime(), (Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ UnityPausepointHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(boolean playMode) {
                void $this$forEach$iv;
                Collection collection = XDebuggerManager.getInstance((Project)UnityPausepointHandler.access$getDebugProcess$p(this.this$0).getProject()).getBreakpointManager().getBreakpoints(UnityPausepointBreakpointType.class);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getBreakpoints(...)");
                Iterable iterable = collection;
                UnityPausepointHandler unityPausepointHandler = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    XLineBreakpoint breakpoint = (XLineBreakpoint)element$iv;
                    boolean bl = false;
                    if (playMode) {
                        if (!breakpoint.isEnabled()) continue;
                        Intrinsics.checkNotNull((Object)breakpoint);
                        UnityPausepointHandler.access$doRegisterBreakpoint(unityPausepointHandler, breakpoint);
                        continue;
                    }
                    Intrinsics.checkNotNull((Object)breakpoint);
                    UnityPausepointHandler.access$doUnregisterBreakpoint(unityPausepointHandler, breakpoint);
                    UnityPausepointHandler.access$markBreakpointDisabledInSession(unityPausepointHandler, breakpoint, "Unity pausepoints are only available in play mode");
                }
            }
        });
    }

    private final boolean isSupportedSession() {
        RunProfile runProfile = this.debugProcess.getSession().getRunProfile();
        return runProfile instanceof UnityAttachToEditorRunConfiguration || runProfile instanceof UnityAttachProfileState && ((UnityAttachProfileState)runProfile).isEditor();
    }

    private final boolean isInPlayMode() {
        return (Boolean)InterfacesKt.valueOrDefault(this.unityModel.getPlayControls().getPlay(), (Object)false);
    }

    private final void doRegisterBreakpoint(XLineBreakpoint<?> breakpoint) {
        if (!this.registeredBreakpoints.contains(breakpoint)) {
            ArrayList<UnityPausepointAdditionalDataModel> userData = (ArrayList<UnityPausepointAdditionalDataModel>)breakpoint.getUserData(DotNetBreakpointsManager.Companion.getBreakpointAdditionalDataKey());
            if (userData == null) {
                userData = new ArrayList<UnityPausepointAdditionalDataModel>();
            }
            userData.add(new UnityPausepointAdditionalDataModel());
            breakpoint.putUserData(DotNetBreakpointsManager.Companion.getBreakpointAdditionalDataKey(), userData);
            this.debugProcess.getBreakpointsManager().registerLineBreakpoint(breakpoint);
            this.registeredBreakpoints.add((XBreakpoint<?>)breakpoint);
        }
    }

    private final void doUnregisterBreakpoint(XLineBreakpoint<?> breakpoint) {
        this.debugProcess.getBreakpointsManager().unregisterLineBreakpoint(breakpoint);
        this.registeredBreakpoints.remove(breakpoint);
    }

    private final void markBreakpointDisabledInSession(XLineBreakpoint<?> breakpoint, String message2) {
        this.debugProcess.getSession().updateBreakpointPresentation(breakpoint, breakpoint.getType().getMutedDisabledIcon(), message2);
    }

    public static final /* synthetic */ DotNetDebugProcess access$getDebugProcess$p(UnityPausepointHandler $this) {
        return $this.debugProcess;
    }

    public static final /* synthetic */ void access$doRegisterBreakpoint(UnityPausepointHandler $this, XLineBreakpoint breakpoint) {
        $this.doRegisterBreakpoint(breakpoint);
    }

    public static final /* synthetic */ void access$doUnregisterBreakpoint(UnityPausepointHandler $this, XLineBreakpoint breakpoint) {
        $this.doUnregisterBreakpoint(breakpoint);
    }

    public static final /* synthetic */ void access$markBreakpointDisabledInSession(UnityPausepointHandler $this, XLineBreakpoint breakpoint, String message2) {
        $this.markBreakpointDisabledInSession(breakpoint, message2);
    }
}

