/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.debugger.breakpoints;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointType;
import com.jetbrains.rider.plugins.unity.UnityBundle;
import com.jetbrains.rider.plugins.unity.debugger.breakpoints.UnityPausepointConstants;
import com.jetbrains.rider.plugins.unity.debugger.breakpoints.UnityPausepointsKt;
import icons.UnityIcons;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fH\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\b\u0010 \u001a\u00020\u0016H\u0016J\b\u0010!\u001a\u00020\u0016H\u0016J\b\u0010\"\u001a\u00020\u0016H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016\u00a8\u0006'"}, d2={"Lcom/jetbrains/rider/plugins/unity/debugger/breakpoints/UnityPausepointBreakpointType;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType;", "()V", "canPutAt", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "project", "Lcom/intellij/openapi/project/Project;", "getAdditionalPopupMenuActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "currentSession", "Lcom/intellij/xdebugger/XDebugSession;", "getDefaultSuspendPolicy", "Lcom/intellij/xdebugger/breakpoints/SuspendPolicy;", "getDisabledIcon", "Ljavax/swing/Icon;", "getDisplayText", "", "getEnabledIcon", "getInactiveDependentIcon", "getInvalidIcon", "getMutedDisabledIcon", "getMutedEnabledIcon", "getPriority", "getSuspendNoneIcon", "getTemporaryIcon", "getVerifiedIcon", "getVerifiedIconWithNoSuspend", "getVisibleStandardPanels", "Ljava/util/EnumSet;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointType$StandardPanels;", "Companion", "intellij.rider.plugins.unity"})
public final class UnityPausepointBreakpointType
extends DotNetLineBreakpointType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String Id = "UnityPausepointType";
    @Nls
    @NotNull
    private static final String Title = UnityBundle.Companion.message("breakpoint.type.unity.pausepoints", new Object[0]);

    public UnityPausepointBreakpointType() {
        super(Id, Title);
    }

    @NotNull
    public String getDisplayText(@Nullable XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        Object[] objectArray = new Object[]{super.getDisplayText(breakpoint)};
        return UnityBundle.Companion.message("pause.unity.editor.when.debugger.reaches.0", objectArray);
    }

    @NotNull
    public Icon getDisabledIcon() {
        return UnityIcons.Debugger.Companion.getDb_disabled_pausepoint();
    }

    @NotNull
    public Icon getEnabledIcon() {
        return UnityIcons.Debugger.Companion.getDb_set_pausepoint();
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        return UnityIcons.Debugger.Companion.getDb_dep_line_pausepoint();
    }

    @NotNull
    public Icon getInvalidIcon() {
        return UnityIcons.Debugger.Companion.getDb_invalid_pausepoint();
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        return UnityIcons.Debugger.Companion.getDb_muted_disabled_pausepoint();
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        return UnityIcons.Debugger.Companion.getDb_muted_pausepoint();
    }

    @NotNull
    public Icon getSuspendNoneIcon() {
        return UnityIcons.Debugger.Companion.getDb_no_suspend_pausepoint();
    }

    @NotNull
    public Icon getTemporaryIcon() {
        return UnityIcons.Debugger.Companion.getDb_set_pausepoint();
    }

    @NotNull
    public Icon getVerifiedIcon() {
        return UnityIcons.Debugger.Companion.getDb_verified_pausepoint();
    }

    @NotNull
    public Icon getVerifiedIconWithNoSuspend() {
        return UnityIcons.Debugger.Companion.getDb_verified_no_suspend_pausepoint();
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    public int getPriority() {
        return super.getPriority() - 1;
    }

    @NotNull
    public SuspendPolicy getDefaultSuspendPolicy() {
        return SuspendPolicy.NONE;
    }

    @NotNull
    public EnumSet<XBreakpointType.StandardPanels> getVisibleStandardPanels() {
        EnumSet<Enum> enumSet = EnumSet.of((Enum)XBreakpointType.StandardPanels.DEPENDENCY);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        return enumSet;
    }

    @NotNull
    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint, @Nullable XDebugSession currentSession) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)UnityPausepointConstants.INSTANCE.getConvertToLineBreakpointActionText(), arg_0 -> UnityPausepointBreakpointType.getAdditionalPopupMenuActions$lambda$0((Function1)new Function1<AnActionEvent, Unit>(breakpoint){
            final /* synthetic */ XLineBreakpoint<DotNetLineBreakpointProperties> $breakpoint;
            {
                this.$breakpoint = $breakpoint;
                super(1);
            }

            public final void invoke(AnActionEvent it) {
                DataContext dataContext = it.getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                DataContext dataContext2 = dataContext;
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
                if (editor == null) {
                    return;
                }
                Editor editor2 = editor;
                Project project = editor2.getProject();
                if (project == null) {
                    return;
                }
                Project project2 = project;
                Pair pair = XBreakpointUtil.findSelectedBreakpoint((Project)project2, (Editor)editor2);
                if (this.$breakpoint.getProperties() != null && Intrinsics.areEqual((Object)pair.second, this.$breakpoint)) {
                    UnityPausepointsKt.convertToLineBreakpoint(project2, this.$breakpoint, editor2, (GutterIconRenderer)pair.first);
                }
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
        DumbAwareAction action2 = dumbAwareAction;
        Object[] objectArray = new DumbAwareAction[]{action2};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    private static final void getAdditionalPopupMenuActions$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/unity/debugger/breakpoints/UnityPausepointBreakpointType$Companion;", "", "()V", "Id", "", "Title", "getTitle", "()Ljava/lang/String;", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTitle() {
            return Title;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

