/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.css.uss.impl.util;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.impl.util.CssReferenceProvider;
import com.intellij.psi.css.resolve.CssFileReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.rider.plugins.unity.css.uss.UssFile;
import com.jetbrains.rider.plugins.unity.css.uss.UssFileType;
import com.jetbrains.rider.plugins.unity.css.uss.codeInsight.css.references.UssFilePrefixReference;
import com.jetbrains.rider.plugins.unity.css.uss.codeInsight.css.references.UssFileReferenceSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u001d\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/plugins/unity/css/uss/impl/util/UssFileReferenceProvider;", "Lcom/intellij/psi/css/resolve/CssFileReferenceProvider;", "()V", "getFileReferenceData", "Lkotlin/Triple;", "", "Lcom/jetbrains/rider/plugins/unity/css/uss/codeInsight/css/references/UssFilePrefixReference;", "", "Lcom/intellij/openapi/util/TextRange;", "element", "Lcom/intellij/psi/PsiElement;", "getFileReferences", "", "Lcom/intellij/psi/PsiReference;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "getReferences", "isFont", "", "isImport", "isUriElement", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nUssFileReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UssFileReferenceProvider.kt\ncom/jetbrains/rider/plugins/unity/css/uss/impl/util/UssFileReferenceProvider\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,103:1\n37#2,2:104\n*S KotlinDebug\n*F\n+ 1 UssFileReferenceProvider.kt\ncom/jetbrains/rider/plugins/unity/css/uss/impl/util/UssFileReferenceProvider\n*L\n41#1:104,2\n*E\n"})
public final class UssFileReferenceProvider
implements CssFileReferenceProvider {
    @Nullable
    public PsiReference[] getFileReferences(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getContainingFile() instanceof UssFile) {
            return this.getReferences(element);
        }
        return null;
    }

    private final PsiReference[] getReferences(PsiElement element) {
        if (this.isUriElement(element)) {
            Triple<List<UssFilePrefixReference>, String, TextRange> referenceData = this.getFileReferenceData(element);
            if (referenceData != null) {
                FileType[] fileTypeArray;
                boolean isFont = this.isFont(element);
                boolean isImport = this.isImport(element);
                if (isFont) {
                    fileTypeArray = new FileType[]{};
                } else if (isImport) {
                    UssFileType[] ussFileTypeArray = new UssFileType[]{UssFileType.INSTANCE};
                    fileTypeArray = (FileType[])ussFileTypeArray;
                } else {
                    fileTypeArray = CssReferenceProvider.IMAGE_FILE_TYPES;
                }
                FileType[] fileTypes = fileTypeArray;
                String string = (String)referenceData.getSecond();
                TextRange textRange = (TextRange)referenceData.getThird();
                Intrinsics.checkNotNull((Object)fileTypes);
                FileType[] fileTypeArray2 = fileTypes;
                UssFileReferenceSet referenceSet = new UssFileReferenceSet(element, string, textRange, isFont, Arrays.copyOf(fileTypeArray2, fileTypeArray2.length));
                FileReference[] fileReferenceArray = referenceSet.getAllReferences();
                Intrinsics.checkNotNullExpressionValue((Object)fileReferenceArray, (String)"getAllReferences(...)");
                FileReference[] fileReferenceArray2 = fileReferenceArray;
                List list = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(fileReferenceArray2, fileReferenceArray2.length));
                list.addAll((Collection)referenceData.getFirst());
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new PsiReference[0]);
            }
            return null;
        }
        return null;
    }

    private final boolean isImport(PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, CssImport.class) != null;
    }

    private final boolean isFont(PsiElement element) {
        CssDeclaration cssDeclaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class);
        String name = cssDeclaration != null ? cssDeclaration.getName() : null;
        return Intrinsics.areEqual((Object)name, (Object)"-unity-font") || Intrinsics.areEqual((Object)name, (Object)"-unity-font-definition");
    }

    private final Triple<List<UssFilePrefixReference>, String, TextRange> getFileReferenceData(PsiElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiLanguageInjectionHost && InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectedPsiFiles(parent) != null) {
            return null;
        }
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        TextRange range = textRange;
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        String elementText = element.getText();
        List prefixReferences = new ArrayList();
        Intrinsics.checkNotNull((Object)elementText);
        if (StringsKt.startsWith$default((String)elementText, (String)"project://database/", (int)startOffset, (boolean)false, (int)4, null)) {
            prefixReferences.add(new UssFilePrefixReference(element, range));
        } else if (StringsKt.startsWith$default((String)elementText, (String)"project:///", (int)startOffset, (boolean)false, (int)4, null)) {
            TextRange textRange2 = TextRange.create((int)startOffset, (int)(startOffset + 10));
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"create(...)");
            prefixReferences.add(new UssFilePrefixReference(element, textRange2));
            startOffset += 10;
        } else if (StringsKt.startsWith$default((String)elementText, (String)"project:/", (int)startOffset, (boolean)false, (int)4, null)) {
            TextRange textRange3 = TextRange.create((int)startOffset, (int)(startOffset + 8));
            Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"create(...)");
            prefixReferences.add(new UssFilePrefixReference(element, textRange3));
            startOffset += 8;
        } else if (Intrinsics.areEqual((Object)elementText.subSequence(startOffset, endOffset), (Object)"unity-theme://default")) {
            prefixReferences.add(new UssFilePrefixReference(element, range));
        }
        TextRange textRange4 = TextRange.create((int)startOffset, (int)endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)textRange4, (String)"create(...)");
        TextRange resultRange = textRange4;
        String string = resultRange.substring(elementText);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String resultText = string;
        return new Triple((Object)prefixReferences, (Object)resultText, (Object)resultRange);
    }

    private final boolean isUriElement(PsiElement element) {
        PsiElement parent = element.getParent();
        return parent instanceof CssUri || parent instanceof CssTerm && parent.getParent() instanceof CssUri;
    }
}

