/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.css.uss;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDescriptorOwner;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssValueOwnerDescriptor;
import com.intellij.psi.css.impl.util.CssDocumentationProvider;
import com.intellij.psi.css.impl.util.MdnDocumentationUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.jetbrains.rider.plugins.unity.css.uss.UssLanguage;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0017J&\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0003J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/plugins/unity/css/uss/UssDocumentationProvider;", "Lcom/intellij/lang/documentation/DocumentationProvider;", "()V", "findDocumentationElement", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/annotations/Nullable;", "element", "generateDoc", "", "originalElement", "descriptorText", "documentationElement", "context", "getFilteredAndSortedDescriptors", "", "Lcom/intellij/psi/css/descriptor/CssElementDescriptor;", "descriptorOwner", "Lcom/intellij/psi/css/CssDescriptorOwner;", "descriptorProviderContext", "intellij.rider.plugins.unity"})
public final class UssDocumentationProvider
implements DocumentationProvider {
    @Nls
    @Nullable
    public String generateDoc(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        PsiElement docElement;
        PsiElement psiElement = element;
        if ((psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getLanguage() : null) instanceof UssLanguage && (docElement = this.findDocumentationElement(element)) != null) {
            return this.generateDoc(element.getText(), docElement, originalElement);
        }
        return null;
    }

    private final PsiElement findDocumentationElement(PsiElement element) {
        return CssDocumentationProvider.findDocumentationElement((PsiElement)element);
    }

    @Nls
    private final String generateDoc(String descriptorText, PsiElement documentationElement, PsiElement context) {
        CssElementDescriptorProvider descriptorProvider;
        if (descriptorText == null) {
            return null;
        }
        if (documentationElement instanceof CssDescriptorOwner) {
            PsiElement descriptorProviderContext;
            Collection<CssElementDescriptor> descriptors;
            PsiElement psiElement = context;
            if (psiElement == null) {
                psiElement = documentationElement;
            }
            if ((descriptors = this.getFilteredAndSortedDescriptors((CssDescriptorOwner)documentationElement, descriptorProviderContext = psiElement)).isEmpty()) {
                return null;
            }
            CssElementDescriptor latestDescriptor = descriptors.iterator().next();
            String string = latestDescriptor.getPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
            String presentableName = string;
            String string2 = latestDescriptor.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescription(...)");
            String doc = string2;
            if (latestDescriptor instanceof CssValueOwnerDescriptor) {
                Map valuesDescription = ((CssValueOwnerDescriptor)latestDescriptor).getValuesDescription();
                String formalSyntax = ((CssValueOwnerDescriptor)latestDescriptor).getFormalSyntax();
                if (valuesDescription != null) {
                    return MdnDocumentationUtil.buildDoc((String)presentableName, (String)doc, null, (String)formalSyntax, (Map)valuesDescription);
                }
            }
            return ((CharSequence)doc).length() > 0 ? MdnDocumentationUtil.buildDoc((String)presentableName, (String)doc, null) : latestDescriptor.getDocumentationString(documentationElement);
        }
        CssElementDescriptorProvider cssElementDescriptorProvider = descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)context);
        return cssElementDescriptorProvider != null ? cssElementDescriptorProvider.generateDocForSelector(descriptorText, context) : null;
    }

    private final Collection<CssElementDescriptor> getFilteredAndSortedDescriptors(CssDescriptorOwner descriptorOwner, PsiElement descriptorProviderContext) {
        Collection collection = descriptorOwner.getDescriptors(descriptorProviderContext);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDescriptors(...)");
        Collection descriptors = CollectionsKt.toMutableList((Collection)collection);
        Collection collection2 = CssDescriptorsUtil.filterDescriptorsByContext((Collection)descriptors, (PsiElement)descriptorProviderContext);
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"filterDescriptorsByContext(...)");
        Collection filteredByContext = collection2;
        if (!filteredByContext.isEmpty()) {
            descriptors = filteredByContext;
        }
        Collection collection3 = CssDescriptorsUtil.sortDescriptors((Collection)descriptors);
        Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"sortDescriptors(...)");
        return collection3;
    }
}

