/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.csharp.completion;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.rider.ideaInterop.fileTypes.csharp.completion.CSharpIdentifierPartHelper;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.parser.CsAttributeDeclarationNode;
import com.jetbrains.rider.languages.fileTypes.csharp.psi.impl.CSharpDummyDeclaration;
import com.jetbrains.rider.languages.fileTypes.csharp.psi.impl.CSharpNonInterpolatedStringLiteralExpressionImpl;
import com.jetbrains.rider.languages.fileTypes.csharp.psi.impl.CSharpPsiElementBase;
import com.jetbrains.rider.plugins.unity.FrontendBackendHost;
import com.jetbrains.rider.plugins.unity.UnityProjectDiscovererKt;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/plugins/unity/csharp/completion/OdinLayoutAttributeCSharpIdentifierPartHelper;", "Lcom/jetbrains/rider/ideaInterop/fileTypes/csharp/completion/CSharpIdentifierPartHelper;", "()V", "knownAttributes", "", "", "acceptCharForIdentifierPart", "", "character", "", "acceptCharForIdentifierStart", "hasOdinPackage", "project", "Lcom/intellij/openapi/project/Project;", "isApplicable", "file", "Lcom/intellij/psi/PsiElement;", "offset", "", "intellij.rider.plugins.unity"})
public final class OdinLayoutAttributeCSharpIdentifierPartHelper
implements CSharpIdentifierPartHelper {
    @NotNull
    private final Set<String> knownAttributes;

    public OdinLayoutAttributeCSharpIdentifierPartHelper() {
        Object[] objectArray = new String[]{"BoxGroup", "ButtonGroup", "HorizontalGroup", "ResponsiveButtonGroup", "VerticalGroup", "FoldoutGroup", "TabGroup", "ToggleGroup", "TitleGroup", "HideIfGroup", "ShowIfGroup"};
        this.knownAttributes = SetsKt.setOf((Object[])objectArray);
    }

    private final boolean hasOdinPackage(Project project) {
        FrontendBackendHost host = FrontendBackendHost.Companion.getInstance(project);
        return ((Map)host.getTechnologies()).containsKey("Odin");
    }

    public boolean isApplicable(@NotNull PsiElement file, int offset) {
        PsiElement element;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!((Boolean)UnityProjectDiscovererKt.isUnityProject(project).invoke()).booleanValue()) {
            return false;
        }
        Project project2 = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (!this.hasOdinPackage(project2)) {
            return false;
        }
        PsiElement psiElement = file.findElementAt(offset);
        Object object = element = psiElement != null ? psiElement.getParent() : null;
        if (!(element instanceof CSharpPsiElementBase)) {
            return false;
        }
        if (!(element instanceof CSharpNonInterpolatedStringLiteralExpressionImpl)) {
            return false;
        }
        PsiElement attributeDeclaration = ((CSharpNonInterpolatedStringLiteralExpressionImpl)element).getParent().getParent();
        if (!(attributeDeclaration instanceof CSharpDummyDeclaration)) {
            return false;
        }
        if (!(((CSharpDummyDeclaration)attributeDeclaration).getAstNodeType() instanceof CsAttributeDeclarationNode)) {
            return false;
        }
        String name = ((CSharpDummyDeclaration)attributeDeclaration).getDeclaredName();
        return CollectionsKt.contains((Iterable)this.knownAttributes, (Object)name) || this.knownAttributes.contains(name + "Attribute");
    }

    public boolean acceptCharForIdentifierPart(char character) {
        return character == '/';
    }

    public boolean acceptCharForIdentifierStart(char character) {
        return this.acceptCharForIdentifierPart(character);
    }
}

