/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.plugins.unity.actions.RiderUnityLogViewAction;
import com.jetbrains.rider.plugins.unity.actions.UnityPluginActionsBundle;
import com.jetbrains.rider.plugins.unity.model.UnityApplicationData;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendModel_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/plugins/unity/actions/RiderUnityOpenPlayerLogAction;", "Lcom/jetbrains/rider/plugins/unity/actions/RiderUnityLogViewAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Companion", "intellij.rider.plugins.unity"})
public final class RiderUnityOpenPlayerLogAction
extends RiderUnityLogViewAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String actionId = "RiderUnityOpenPlayerLogAction";
    @NotNull
    private static final Logger logger;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String path;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        UnityApplicationData unityApplicationData = (UnityApplicationData)FrontendBackendModel_PregeneratedKt.getFrontendBackendModel(SolutionHostExtensionsKt.getSolution((Project)project2)).getUnityApplicationData().getValueOrNull();
        String string = path = unityApplicationData != null ? unityApplicationData.getPlayerLogPath() : null;
        if (path != null) {
            VirtualFile vf = VfsUtil.findFileByIoFile((File)new File(path), (boolean)true);
            if (vf != null) {
                OpenFileDescriptor descriptor = new OpenFileDescriptor(project2, vf);
                FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor, true);
            } else {
                NotificationGroup groupId = NotificationGroupManager.getInstance().getNotificationGroup("Unity log open");
                String title = UnityPluginActionsBundle.Companion.message("notification.title.could.not.open.unity.player.log", new Object[0]);
                Object[] objectArray = new Object[]{path};
                String message2 = UnityPluginActionsBundle.Companion.message("notification.content.not.present", objectArray);
                Notification notification = new Notification(groupId.getDisplayId(), title, message2, NotificationType.INFORMATION);
                Notifications.Bus.notify((Notification)notification, (Project)project2);
            }
        } else {
            logger.error("Could not open Unity Player Log, path was null");
        }
    }

    static {
        Logger logger = Logger.getInstance(RiderUnityOpenPlayerLogAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderUnityOpenPlayerLogAction.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/unity/actions/RiderUnityOpenPlayerLogAction$Companion;", "", "()V", "actionId", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

