/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.framework.impl.RdProperty;
import com.jetbrains.rd.ide.model.RdExistingSolution;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.ProjectExtensionsKt;
import com.jetbrains.rider.plugins.unity.UnityProjectDiscovererState;
import com.jetbrains.rider.plugins.unity.UnityProjectLifetimeService;
import com.jetbrains.rider.plugins.unity.explorer.UnityExplorer;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendModel;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/plugins/unity/UnityProjectDiscoverer;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "hasUnityReference", "Lcom/jetbrains/rd/framework/impl/RdProperty;", "", "getHasUnityReference", "()Lcom/jetbrains/rd/framework/impl/RdProperty;", "isUnityProject", "isUnityProjectFolder", "getProject", "()Lcom/intellij/openapi/project/Project;", "hasLibraryFolder", "isCorrectlyLoadedSolution", "Companion", "ProtocolListener", "intellij.rider.plugins.unity"})
public final class UnityProjectDiscoverer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final RdProperty<Boolean> isUnityProject;
    @NotNull
    private final RdProperty<Boolean> isUnityProjectFolder;
    @NotNull
    private final RdProperty<Boolean> hasUnityReference;

    public UnityProjectDiscoverer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.isUnityProject = new RdProperty((Object)UnityProjectDiscovererState.Companion.getInstance(this.project).isUnityProjectState(), null, 2, null);
        this.isUnityProjectFolder = new RdProperty((Object)UnityProjectDiscovererState.Companion.getInstance(this.project).isUnityProjectFolderState(), null, 2, null);
        this.hasUnityReference = new RdProperty((Object)UnityProjectDiscovererState.Companion.getInstance(this.project).getHasUnityReferenceState(), null, 2, null);
        Lifetime lifetime = UnityProjectLifetimeService.Companion.getLifetime(this.project);
        RdCoroutinesUtilKt.startBackgroundAsync$default((Lifetime)lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ UnityProjectDiscoverer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean hasUnityFileStructure = Companion.hasUnityFileStructure(this.this$0.getProject());
                        this.this$0.isUnityProjectFolder().set((Object)Boxing.boxBoolean((hasUnityFileStructure ? 1 : 0) != 0));
                        UnityProjectDiscovererState.Companion.getInstance(this.this$0.getProject()).setUnityProjectFolderState(hasUnityFileStructure);
                        boolean isUnityProjectVal = hasUnityFileStructure && this.this$0.isCorrectlyLoadedSolution(this.this$0.getProject()) && this.this$0.hasLibraryFolder(this.this$0.getProject());
                        boolean oldVal = (Boolean)this.this$0.isUnityProject().getValue();
                        this.this$0.isUnityProject().set((Object)Boxing.boxBoolean((isUnityProjectVal ? 1 : 0) != 0));
                        UnityProjectDiscovererState.Companion.getInstance(this.this$0.getProject()).setUnityProjectState(isUnityProjectVal);
                        if (oldVal == isUnityProjectVal) return Unit.INSTANCE;
                        ProjectView projectView = ProjectView.getInstance((Project)this.this$0.getProject());
                        this.label = 1;
                        Object object3 = RdCoroutinesUtilKt.withUiContext$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(projectView, isUnityProjectVal, this.this$0, null){
                            int label;
                            final /* synthetic */ ProjectView $projectView;
                            final /* synthetic */ boolean $isUnityProjectVal;
                            final /* synthetic */ UnityProjectDiscoverer this$0;
                            {
                                this.$projectView = $projectView;
                                this.$isUnityProjectVal = $isUnityProjectVal;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        AbstractProjectViewPane fileSystemPane = this.$projectView.getProjectViewPaneById("FileSystemExplorer");
                                        if (fileSystemPane != null) {
                                            AbstractProjectViewPane pane = this.$projectView.getProjectViewPaneById("UnityExplorer");
                                            if (this.$isUnityProjectVal) {
                                                if (pane == null) {
                                                    this.$projectView.addProjectPane((AbstractProjectViewPane)new UnityExplorer(this.this$0.getProject()));
                                                }
                                                this.$projectView.changeView("UnityExplorer");
                                            } else if (pane != null) {
                                                this.$projectView.removeProjectPane(pane);
                                            }
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this), (int)1, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final RdProperty<Boolean> isUnityProject() {
        return this.isUnityProject;
    }

    @NotNull
    public final RdProperty<Boolean> isUnityProjectFolder() {
        return this.isUnityProjectFolder;
    }

    @NotNull
    public final RdProperty<Boolean> getHasUnityReference() {
        return this.hasUnityReference;
    }

    private final boolean hasLibraryFolder(Project project) {
        VirtualFile projectDir = ProjectExtensionsKt.getProjectDir(project);
        VirtualFile virtualFile = projectDir.findChild("Library");
        return !(virtualFile != null ? !virtualFile.isDirectory() : false);
    }

    private final boolean isCorrectlyLoadedSolution(Project project) {
        return SolutionHostExtensionsKt.getSolutionDescription((Project)project) instanceof RdExistingSolution;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ&\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\n0\f2\u0006\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/plugins/unity/UnityProjectDiscoverer$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/unity/UnityProjectDiscoverer;", "project", "Lcom/intellij/openapi/project/Project;", "hasUnityFileStructure", "", "projectDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "searchUpForFolderWithUnityFileStructure", "Lkotlin/Pair;", "file", "maxSteps", "", "intellij.rider.plugins.unity"})
    @SourceDebugExtension(value={"SMAP\nUnityProjectDiscoverer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityProjectDiscoverer.kt\ncom/jetbrains/rider/plugins/unity/UnityProjectDiscoverer$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,177:1\n31#2,2:178\n12474#3,2:180\n*S KotlinDebug\n*F\n+ 1 UnityProjectDiscoverer.kt\ncom/jetbrains/rider/plugins/unity/UnityProjectDiscoverer$Companion\n*L\n86#1:178,2\n107#1:180,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UnityProjectDiscoverer getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<UnityProjectDiscoverer> serviceClass$iv = UnityProjectDiscoverer.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (UnityProjectDiscoverer)object;
        }

        private final boolean hasUnityFileStructure(Project project) {
            return !project.isDefault() && this.hasUnityFileStructure(ProjectExtensionsKt.getProjectDir(project));
        }

        public final boolean hasUnityFileStructure(@NotNull VirtualFile projectDir) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
                VirtualFile virtualFile = projectDir.findChild("Assets");
                boolean bl2 = virtualFile != null ? !virtualFile.isDirectory() : false;
                if (bl2) {
                    return false;
                }
                VirtualFile projectSettings = projectDir.findChild("ProjectSettings");
                if (projectSettings == null || !projectSettings.isDirectory()) {
                    return false;
                }
                VirtualFile[] virtualFileArray = projectSettings.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                Object[] $this$any$iv = virtualFileArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"ProjectVersion.txt") || Intrinsics.areEqual((Object)it.getExtension(), (Object)"asset"))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final Pair<Boolean, VirtualFile> searchUpForFolderWithUnityFileStructure(@NotNull VirtualFile file, int maxSteps) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            VirtualFile dir = null;
            dir = file;
            for (int i = 0; i < maxSteps; ++i) {
                int it = i;
                boolean bl = false;
                if (dir == null) continue;
                VirtualFile it2 = dir;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it2.getName(), (Object)"Assets") || Intrinsics.areEqual((Object)it2.getName(), (Object)"Packages")) {
                    VirtualFile virtualFile = it2.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
                    if (Companion.hasUnityFileStructure(virtualFile)) {
                        return new Pair((Object)true, (Object)it2.getParent());
                    }
                }
                dir = it2.getParent();
            }
            return new Pair((Object)false, null);
        }

        public static /* synthetic */ Pair searchUpForFolderWithUnityFileStructure$default(Companion companion, VirtualFile virtualFile, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 10;
            }
            return companion.searchUpForFolderWithUnityFileStructure(virtualFile, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/plugins/unity/UnityProjectDiscoverer$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/plugins/unity/model/frontendBackend/FrontendBackendModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider.plugins.unity"})
    public static final class ProtocolListener
    implements SolutionExtListener<FrontendBackendModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull FrontendBackendModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            SourceExKt.adviseUntil((ISource)((ISource)model.getHasUnityReference()), (Lifetime)lifetime, (Function1)((Function1)new Function1<Boolean, Boolean>(session){
                final /* synthetic */ ClientProjectSession $session;
                {
                    this.$session = $session;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(boolean it) {
                    UnityProjectDiscoverer.Companion.getInstance(this.$session.getProject()).getHasUnityReference().set((Object)it);
                    UnityProjectDiscovererState.Companion.getInstance(this.$session.getProject()).setHasUnityReferenceState(it);
                    return it;
                }
            }));
        }
    }
}

