/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.ArrayAsSequence;
import kotlinx.serialization.json.internal.CharArrayPoolBatchSize;
import kotlinx.serialization.json.internal.InternalJsonReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0012H\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\fH\u0016J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\fH\u0002J\u0006\u0010#\u001a\u00020\u000eJ\u0018\u0010$\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010%\u001a\u00020\fH\u0016J\b\u0010&\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lkotlinx/serialization/json/internal/ReaderJsonLexer;", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "reader", "Lkotlinx/serialization/json/internal/InternalJsonReader;", "buffer", "", "(Lkotlinx/serialization/json/internal/InternalJsonReader;[C)V", "source", "Lkotlinx/serialization/json/internal/ArrayAsSequence;", "getSource", "()Lkotlinx/serialization/json/internal/ArrayAsSequence;", "threshold", "", "appendRange", "", "fromIndex", "toIndex", "canConsumeValue", "", "consumeKeyString", "", "consumeNextToken", "", "ensureHaveChars", "indexOf", "char", "", "startPos", "peekLeadingMatchingValue", "keyToMatch", "isLenient", "prefetchOrEof", "position", "preload", "unprocessedCount", "release", "substring", "endPos", "tryConsumeComma", "kotlinx-serialization-json"})
public final class ReaderJsonLexer
extends AbstractJsonLexer {
    @NotNull
    private final InternalJsonReader reader;
    @NotNull
    private final char[] buffer;
    private int threshold;
    @NotNull
    private final ArrayAsSequence source;

    public ReaderJsonLexer(@NotNull InternalJsonReader reader, @NotNull char[] buffer) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this.reader = reader;
        this.buffer = buffer;
        this.threshold = 128;
        this.source = new ArrayAsSequence(this.buffer);
        this.preload(0);
    }

    public /* synthetic */ ReaderJsonLexer(InternalJsonReader internalJsonReader, char[] cArray, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            cArray = CharArrayPoolBatchSize.INSTANCE.take();
        }
        this(internalJsonReader, cArray);
    }

    @Override
    @NotNull
    protected ArrayAsSequence getSource() {
        return this.source;
    }

    @Override
    public boolean tryConsumeComma() {
        int current = this.skipWhitespaces();
        if (current >= this.getSource().length() || current == -1) {
            return false;
        }
        if (this.getSource().charAt(current) == ',') {
            ++this.currentPosition;
            return true;
        }
        return false;
    }

    @Override
    public boolean canConsumeValue() {
        this.ensureHaveChars();
        int current = this.currentPosition;
        while ((current = this.prefetchOrEof(current)) != -1) {
            char c2 = this.getSource().charAt(current);
            if (c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t') {
                ++current;
                continue;
            }
            this.currentPosition = current;
            return this.isValidValueStart(c2);
        }
        this.currentPosition = current;
        return false;
    }

    private final void preload(int unprocessedCount) {
        int actual;
        char[] buffer = this.getSource().getBuffer$kotlinx_serialization_json();
        if (unprocessedCount != 0) {
            ArraysKt.copyInto(buffer, buffer, 0, this.currentPosition, this.currentPosition + unprocessedCount);
        }
        int sizeTotal = this.getSource().length();
        for (int filledCount = unprocessedCount; filledCount != sizeTotal; filledCount += actual) {
            actual = this.reader.read(buffer, filledCount, sizeTotal - filledCount);
            if (actual != -1) continue;
            this.getSource().trim(filledCount);
            this.threshold = -1;
            break;
        }
        this.currentPosition = 0;
    }

    @Override
    public int prefetchOrEof(int position) {
        if (position < this.getSource().length()) {
            return position;
        }
        this.currentPosition = position;
        this.ensureHaveChars();
        if (this.currentPosition != 0 || ((CharSequence)this.getSource()).length() == 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public byte consumeNextToken() {
        this.ensureHaveChars();
        ArrayAsSequence source = this.getSource();
        int cpos = this.currentPosition;
        while ((cpos = this.prefetchOrEof(cpos)) != -1) {
            char ch;
            byte tc;
            if ((tc = AbstractJsonLexerKt.charToTokenClass(ch = source.charAt(cpos++))) == 3) continue;
            this.currentPosition = cpos;
            return tc;
        }
        this.currentPosition = cpos;
        return 10;
    }

    @Override
    public void ensureHaveChars() {
        int cur = this.currentPosition;
        int oldSize = this.getSource().length();
        int spaceLeft = oldSize - cur;
        if (spaceLeft > this.threshold) {
            return;
        }
        this.preload(spaceLeft);
    }

    @Override
    @NotNull
    public String consumeKeyString() {
        this.consumeNextToken('\"');
        int current = this.currentPosition;
        int closingQuote = this.indexOf('\"', current);
        if (closingQuote == -1) {
            if ((current = this.prefetchOrEof(current)) == -1) {
                AbstractJsonLexer.fail$kotlinx_serialization_json$default(this, (byte)1, false, 2, null);
                throw new KotlinNothingValueException();
            }
            return this.consumeString(this.getSource(), this.currentPosition, current);
        }
        for (int i2 = current; i2 < closingQuote; ++i2) {
            if (this.getSource().charAt(i2) != '\\') continue;
            return this.consumeString(this.getSource(), this.currentPosition, i2);
        }
        this.currentPosition = closingQuote + 1;
        return this.substring(current, closingQuote);
    }

    @Override
    public int indexOf(char c2, int startPos) {
        ArrayAsSequence src = this.getSource();
        int n2 = src.length();
        for (int i2 = startPos; i2 < n2; ++i2) {
            if (src.charAt(i2) != c2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    @NotNull
    public String substring(int startPos, int endPos) {
        return this.getSource().substring(startPos, endPos);
    }

    @Override
    protected void appendRange(int fromIndex, int toIndex) {
        StringBuilder stringBuilder = this.getEscapedString();
        Intrinsics.checkNotNullExpressionValue(stringBuilder.append(this.getSource().getBuffer$kotlinx_serialization_json(), fromIndex, toIndex - fromIndex), "append(...)");
    }

    @Override
    @Nullable
    public String peekLeadingMatchingValue(@NotNull String keyToMatch, boolean isLenient) {
        Intrinsics.checkNotNullParameter(keyToMatch, "keyToMatch");
        return null;
    }

    public final void release() {
        CharArrayPoolBatchSize.INSTANCE.release(this.buffer);
    }
}

