/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.ints.AbstractIntList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntSpliterator;
import it.unimi.dsi.fastutil.ints.Y;
import it.unimi.dsi.fastutil.ints.ag;
import it.unimi.dsi.fastutil.ints.q;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;

public class IntArrayList
extends AbstractIntList
implements Serializable,
Cloneable,
RandomAccess {
    private static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    protected transient int[] a;
    protected int size;

    private static final int[] a(int[] nArray, int n2) {
        if (n2 == 0) {
            return IntArrays.EMPTY_ARRAY;
        }
        return java.util.Arrays.copyOf(nArray, n2);
    }

    private static final int[] a(IntArrayList intArrayList) {
        return IntArrayList.a(intArrayList.a, intArrayList.size);
    }

    /*
     * WARNING - void declaration
     */
    protected IntArrayList(int[] a2, boolean wrapped) {
        void var1_1;
        this.a = var1_1;
    }

    private void c(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Initial capacity (" + n2 + ") is negative");
        }
        if (n2 == 0) {
            this.a = IntArrays.EMPTY_ARRAY;
            return;
        }
        this.a = new int[n2];
    }

    /*
     * WARNING - void declaration
     */
    public IntArrayList(int capacity) {
        void var1_1;
        this.c((int)var1_1);
    }

    public IntArrayList() {
        this.a = IntArrays.DEFAULT_EMPTY_ARRAY;
    }

    /*
     * WARNING - void declaration
     */
    public IntArrayList(Collection<? extends Integer> c2) {
        void var1_1;
        if (c2 instanceof IntArrayList) {
            this.a = IntArrayList.a((IntArrayList)c2);
            this.size = this.a.length;
            return;
        }
        this.c(c2.size());
        if (c2 instanceof IntList) {
            this.size = c2.size();
            ((IntList)c2).getElements(0, this.a, 0, this.size);
            return;
        }
        this.size = IntIterators.unwrap(IntIterators.asIntIterator(var1_1.iterator()), this.a);
    }

    /*
     * WARNING - void declaration
     */
    public IntArrayList(IntCollection c2) {
        void var1_1;
        if (c2 instanceof IntArrayList) {
            this.a = IntArrayList.a((IntArrayList)c2);
            this.size = this.a.length;
            return;
        }
        this.c(c2.size());
        if (c2 instanceof IntList) {
            this.size = c2.size();
            ((IntList)c2).getElements(0, this.a, 0, this.size);
            return;
        }
        this.size = IntIterators.unwrap(var1_1.iterator(), this.a);
    }

    /*
     * WARNING - void declaration
     */
    public IntArrayList(IntList l2) {
        void var1_1;
        if (l2 instanceof IntArrayList) {
            this.a = IntArrayList.a((IntArrayList)l2);
            this.size = this.a.length;
            return;
        }
        this.c(l2.size());
        this.size = var1_1.size();
        l2.getElements(0, this.a, 0, this.size);
    }

    /*
     * WARNING - void declaration
     */
    public IntArrayList(int[] a2) {
        this(a2, 0, ((void)var1_1).length);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntArrayList(int[] a2, int offset, int length) {
        this(length);
        void var3_3;
        void var2_2;
        void var1_1;
        System.arraycopy(var1_1, (int)var2_2, this.a, 0, length);
        this.size = var3_3;
    }

    public IntArrayList(Iterator<? extends Integer> i2) {
        this();
        while (i2.hasNext()) {
            ((q)this).add((int)i2.next());
        }
    }

    public IntArrayList(IntIterator i2) {
        this();
        while (i2.hasNext()) {
            ((q)this).add(i2.nextInt());
        }
    }

    public int[] elements() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    public static IntArrayList wrap(int[] a2, int length) {
        void var1_1;
        Object object;
        if (length > a2.length) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + a2.length + ")");
        }
        object = new IntArrayList((int[])object, true);
        v0.size = var1_1;
        return object;
    }

    public static IntArrayList wrap(int[] a2) {
        return IntArrayList.wrap(a2, a2.length);
    }

    public static IntArrayList of() {
        return new IntArrayList();
    }

    public static IntArrayList of(int ... init) {
        return IntArrayList.wrap(init);
    }

    public static IntArrayList toList(IntStream stream) {
        return stream.collect(IntArrayList::new, IntArrayList::add, IntList::addAll);
    }

    /*
     * WARNING - void declaration
     */
    public static IntArrayList toListWithExpectedSize(IntStream stream, int expectedSize) {
        void var1_1;
        IntStream intStream;
        if (expectedSize <= 10) {
            return IntArrayList.toList(stream);
        }
        return intStream.collect(new Y.b<IntArrayList>((int)var1_1, n2 -> {
            if (n2 <= 10) {
                return new IntArrayList();
            }
            return new IntArrayList(n2);
        }), IntArrayList::add, IntList::addAll);
    }

    /*
     * WARNING - void declaration
     */
    public void ensureCapacity(int capacity) {
        void var1_1;
        if (capacity <= this.a.length || this.a == IntArrays.DEFAULT_EMPTY_ARRAY && capacity <= 10) {
            return;
        }
        this.a = IntArrays.ensureCapacity(this.a, (int)var1_1, this.size);
        assert (this.size <= this.a.length);
    }

    private void d(int n2) {
        if (n2 <= this.a.length) {
            return;
        }
        if (this.a != IntArrays.DEFAULT_EMPTY_ARRAY) {
            n2 = (int)Math.max(Math.min((long)this.a.length + (long)(this.a.length >> 1), 0x7FFFFFF7L), (long)n2);
        } else if (n2 < 10) {
            n2 = 10;
        }
        this.a = IntArrays.forceCapacity(this.a, n2, this.size);
        assert (this.size <= this.a.length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(int index, int k2) {
        void var2_2;
        this.a(index);
        IntArrayList intArrayList = this;
        intArrayList.d(intArrayList.size + 1);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + 1, this.size - index);
        }
        this.a[var1_1] = var2_2;
        ++this.size;
        assert (this.size <= this.a.length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(int k2) {
        void var1_1;
        IntArrayList intArrayList = this;
        intArrayList.d(intArrayList.size + 1);
        this.a[this.size++] = var1_1;
        assert (this.size <= this.a.length);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getInt(int index) {
        void var1_1;
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[var1_1];
    }

    @Override
    public int indexOf(int k2) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (k2 != this.a[i2]) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int k2) {
        int n2 = this.size;
        while (n2-- != 0) {
            if (k2 != this.a[n2]) continue;
            return n2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int removeInt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        int n2 = this.a[index];
        --this.size;
        if (index != this.size) {
            void var1_1;
            System.arraycopy(this.a, index + 1, this.a, index, this.size - var1_1);
        }
        assert (this.size <= this.a.length);
        return n2;
    }

    @Override
    public boolean rem(int k2) {
        int n2;
        if ((n2 = ((AbstractIntList)this).indexOf(n2)) == -1) {
            return false;
        }
        ((AbstractIntList)this).removeInt(n2);
        assert (this.size <= this.a.length);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int set(int index, int k2) {
        void var2_2;
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        int n2 = this.a[index];
        this.a[var1_1] = var2_2;
        return n2;
    }

    @Override
    public void clear() {
        this.size = 0;
        assert (this.size <= this.a.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void size(int size) {
        void var1_1;
        if (size > this.a.length) {
            this.a = IntArrays.forceCapacity(this.a, size, this.size);
        }
        if (size > this.size) {
            java.util.Arrays.fill(this.a, this.size, size, 0);
        }
        this.size = var1_1;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public void trim() {
        this.trim(0);
    }

    /*
     * WARNING - void declaration
     */
    public void trim(int n2) {
        void var1_1;
        if (n2 >= this.a.length || this.size == this.a.length) {
            return;
        }
        int[] nArray = new int[Math.max((int)var1_1, this.size)];
        System.arraycopy(this.a, 0, nArray, 0, this.size);
        this.a = nArray;
        assert (this.size <= this.a.length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IntList subList(int from, int to) {
        void var2_2;
        void var1_1;
        if (from == 0 && to == this.size()) {
            return this;
        }
        this.a(from);
        this.a(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new b((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getElements(int from, int[] a2, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        IntArrays.ensureOffsetLength(a2, offset, length);
        System.arraycopy(this.a, (int)var1_1, var2_2, (int)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeElements(int from, int to) {
        void var1_1;
        void var2_2;
        Arrays.ensureFromTo(this.size, from, to);
        System.arraycopy(this.a, to, this.a, from, this.size - to);
        this.size -= var2_2 - var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addElements(int index, int[] a2, int offset, int length) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.a(index);
        IntArrays.ensureOffsetLength(a2, offset, length);
        IntArrayList intArrayList = this;
        intArrayList.d(intArrayList.size + length);
        System.arraycopy(this.a, index, this.a, index + length, this.size - index);
        System.arraycopy(var2_2, (int)var3_3, this.a, (int)var1_1, length);
        this.size += length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setElements(int index, int[] a2, int offset, int length) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.a(index);
        IntArrays.ensureOffsetLength(a2, offset, length);
        if (index + length > this.size) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + this.size + ")");
        }
        System.arraycopy(var2_2, (int)var3_3, this.a, (int)var1_1, length);
    }

    @Override
    public void forEach(IntConsumer action) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            action.accept(this.a[i2]);
        }
    }

    @Override
    public boolean addAll(int index, IntCollection c2) {
        IntIterator intIterator;
        if (c2 instanceof IntList) {
            return this.addAll(index, (IntList)c2);
        }
        this.a(index);
        int n2 = c2.size();
        if (n2 == 0) {
            return false;
        }
        IntArrayList intArrayList = this;
        intArrayList.d(intArrayList.size + n2);
        System.arraycopy(this.a, index, this.a, index + n2, this.size - index);
        intIterator = intIterator.iterator();
        this.size += n2;
        while (n2-- != 0) {
            this.a[index++] = intIterator.nextInt();
        }
        assert (this.size <= this.a.length);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(int index, IntList l2) {
        void var1_1;
        void var2_2;
        this.a(index);
        int n2 = l2.size();
        if (n2 == 0) {
            return false;
        }
        IntArrayList intArrayList = this;
        intArrayList.d(intArrayList.size + n2);
        System.arraycopy(this.a, index, this.a, index + n2, this.size - index);
        var2_2.getElements(0, this.a, (int)var1_1, n2);
        this.size += n2;
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public boolean removeAll(IntCollection c2) {
        int n2;
        int[] nArray = this.a;
        int n3 = 0;
        for (n2 = 0; n2 < this.size; ++n2) {
            if (c2.contains(nArray[n2])) continue;
            nArray[n3++] = nArray[n2];
        }
        n2 = this.size != n3 ? 1 : 0;
        this.size = n3;
        return n2 != 0;
    }

    @Override
    public boolean removeIf(IntPredicate filter2) {
        int n2;
        int[] nArray = this.a;
        int n3 = 0;
        for (n2 = 0; n2 < this.size; ++n2) {
            if (filter2.test(nArray[n2])) continue;
            nArray[n3++] = nArray[n2];
        }
        n2 = this.size != n3 ? 1 : 0;
        this.size = n3;
        return n2 != 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] toArray(int[] a2) {
        void var1_1;
        if (a2 == null || a2.length < this.size) {
            a2 = java.util.Arrays.copyOf(a2, this.size);
        }
        System.arraycopy(this.a, 0, a2, 0, this.size);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IntListIterator listIterator(int index) {
        void var1_1;
        this.a(index);
        return new IntListIterator(){
            private int a;
            private int b;
            private /* synthetic */ int c;
            private /* synthetic */ IntArrayList d;
            {
                this.d = intArrayList;
                this.c = n2;
                this.a = this.c;
                this.b = -1;
            }

            @Override
            public final boolean hasNext() {
                return this.a < this.d.size;
            }

            @Override
            public final boolean hasPrevious() {
                return this.a > 0;
            }

            @Override
            public final int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.b = this.a++;
                return this.d.a[this.b];
            }

            @Override
            public final int a() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.b = --this.a;
                return this.d.a[this.a];
            }

            @Override
            public final int nextIndex() {
                return this.a;
            }

            @Override
            public final int previousIndex() {
                return this.a - 1;
            }

            @Override
            public final void e_(int n2) {
                ((AbstractIntList)this.d).add(this.a++, n2);
                this.b = -1;
            }

            @Override
            public final void f_(int n2) {
                if (this.b == -1) {
                    throw new IllegalStateException();
                }
                ((AbstractIntList)this.d).set(this.b, n2);
            }

            @Override
            public final void remove() {
                if (this.b == -1) {
                    throw new IllegalStateException();
                }
                ((AbstractIntList)this.d).removeInt(this.b);
                if (this.b < this.a) {
                    --this.a;
                }
                this.b = -1;
            }

            @Override
            public final void forEachRemaining(IntConsumer action) {
                while (this.a < this.d.size) {
                    ++this.a;
                    this.b = this.b;
                    action.accept(this.d.a[this.b]);
                }
            }
        };
    }

    @Override
    public IntSpliterator spliterator() {
        return new a(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sort(IntComparator comp) {
        void var1_1;
        if (comp == null) {
            IntArrays.stableSort(this.a, 0, this.size);
            return;
        }
        IntArrays.stableSort(this.a, 0, this.size, (IntComparator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unstableSort(IntComparator comp) {
        void var1_1;
        if (comp == null) {
            IntArrays.unstableSort(this.a, 0, this.size);
            return;
        }
        IntArrays.unstableSort(this.a, 0, this.size, (IntComparator)var1_1);
    }

    public IntArrayList clone() {
        IntArrayList intArrayList;
        if (this.getClass() == IntArrayList.class) {
            intArrayList = new IntArrayList(IntArrayList.a(this.a, this.size), false);
            new IntArrayList(IntArrayList.a(this.a, this.size), false).size = this.size;
        } else {
            try {
                intArrayList = (IntArrayList)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException);
            }
            intArrayList.a = IntArrayList.a(this.a, this.size);
        }
        return intArrayList;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(IntArrayList l2) {
        void var1_1;
        if (l2 == this) {
            return true;
        }
        int n2 = this.size();
        if (n2 != l2.size()) {
            return false;
        }
        int[] nArray = this.a;
        int[] nArray2 = l2.a;
        if (nArray == nArray2 && n2 == var1_1.size()) {
            return true;
        }
        while (n2-- != 0) {
            if (nArray[n2] == nArray2[n2]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o2) {
        void var1_1;
        if (o2 == this) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (!(o2 instanceof List)) {
            return false;
        }
        if (o2 instanceof IntArrayList) {
            return this.equals((IntArrayList)o2);
        }
        if (o2 instanceof b) {
            return ((AbstractIntList)((b)o2)).equals(this);
        }
        return super.equals(var1_1);
    }

    @Override
    public int compareTo(IntArrayList l2) {
        int n2;
        int[] nArray;
        int n3 = this.size();
        int n4 = l2.size();
        int[] nArray2 = this.a;
        nArray = nArray.a;
        if (nArray2 == nArray && n3 == n4) {
            return 0;
        }
        for (n2 = 0; n2 < n3 && n2 < n4; ++n2) {
            int n5 = nArray2[n2];
            int n6 = nArray[n2];
            if ((n5 = Integer.compare(n5, n6)) == 0) continue;
            return n5;
        }
        if (n2 < n4) {
            return -1;
        }
        if (n2 < n3) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(List<? extends Integer> l2) {
        void var1_1;
        if (l2 instanceof IntArrayList) {
            return this.compareTo((IntArrayList)l2);
        }
        if (l2 instanceof b) {
            return -((AbstractIntList)((b)l2)).compareTo(this);
        }
        return super.compareTo((List<? extends Integer>)var1_1);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeInt(this.a[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.a = new int[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.a[i2] = s2.readInt();
        }
    }

    private final class it.unimi.dsi.fastutil.ints.IntArrayList$b
    extends AbstractIntList.b {
        private static final long serialVersionUID = -3185226345314976296L;

        protected it.unimi.dsi.fastutil.ints.IntArrayList$b(int n2, int n3) {
            super(IntArrayList.this, n2, n3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int getInt(int i2) {
            void var1_1;
            this.b(i2);
            return IntArrayList.this.a[var1_1 + this.b];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final IntListIterator listIterator(int index) {
            void var1_1;
            return new a(this, (int)var1_1);
        }

        @Override
        public final IntSpliterator spliterator() {
            return new b(this);
        }

        private boolean a(int[] nArray, int n2, int n3) {
            if (IntArrayList.this.a == nArray && this.b == n2 && this.c == n3) {
                return true;
            }
            if (n3 - n2 != this.size()) {
                return false;
            }
            n3 = this.b;
            while (n3 < this.c) {
                if (IntArrayList.this.a[n3++] == nArray[n2++]) continue;
                return false;
            }
            return true;
        }

        @Override
        public final boolean equals(Object o2) {
            AbstractIntList abstractIntList;
            if (o2 == this) {
                return true;
            }
            if (o2 == null) {
                return false;
            }
            if (!(o2 instanceof List)) {
                return false;
            }
            if (o2 instanceof IntArrayList) {
                abstractIntList = (IntArrayList)abstractIntList;
                return this.a(((IntArrayList)abstractIntList).a, 0, ((IntArrayList)abstractIntList).size());
            }
            if (abstractIntList instanceof it.unimi.dsi.fastutil.ints.IntArrayList$b) {
                abstractIntList = (it.unimi.dsi.fastutil.ints.IntArrayList$b)abstractIntList;
                return this.a(((it.unimi.dsi.fastutil.ints.IntArrayList$b)abstractIntList).IntArrayList.this.a, ((AbstractIntList.c)abstractIntList).b, ((AbstractIntList.c)abstractIntList).c);
            }
            return super.equals(abstractIntList);
        }

        private int b(int[] nArray, int n2, int n3) {
            if (IntArrayList.this.a == nArray && this.b == n2 && this.c == n3) {
                return 0;
            }
            int n4 = this.b;
            int n5 = n2;
            while (n4 < this.c && n4 < n3) {
                n2 = IntArrayList.this.a[n4];
                int n6 = nArray[n5];
                if ((n2 = Integer.compare(n2, n6)) != 0) {
                    return n2;
                }
                ++n4;
                ++n5;
            }
            if (n4 < n3) {
                return -1;
            }
            if (n4 < this.c) {
                return 1;
            }
            return 0;
        }

        @Override
        public final int compareTo(List<? extends Integer> l2) {
            AbstractIntList abstractIntList;
            if (l2 instanceof IntArrayList) {
                abstractIntList = (IntArrayList)abstractIntList;
                return this.b(((IntArrayList)abstractIntList).a, 0, ((IntArrayList)abstractIntList).size());
            }
            if (abstractIntList instanceof it.unimi.dsi.fastutil.ints.IntArrayList$b) {
                abstractIntList = (it.unimi.dsi.fastutil.ints.IntArrayList$b)abstractIntList;
                return this.b(((it.unimi.dsi.fastutil.ints.IntArrayList$b)abstractIntList).IntArrayList.this.a, ((AbstractIntList.c)abstractIntList).b, ((AbstractIntList.c)abstractIntList).c);
            }
            return super.compareTo(abstractIntList);
        }

        private final class a
        extends IntIterators.b {
            private /* synthetic */ it.unimi.dsi.fastutil.ints.IntArrayList$b d;

            a(it.unimi.dsi.fastutil.ints.IntArrayList$b b2, int n2) {
                this.d = b2;
                super(n2);
            }

            @Override
            protected final int a(int n2) {
                return this.d.IntArrayList.this.a[this.d.b + n2];
            }

            @Override
            protected final void a(int n2, int n3) {
                ((AbstractIntList)this.d).add(n2, n3);
            }

            @Override
            protected final void b(int n2, int n3) {
                ((AbstractIntList)this.d).set(n2, n3);
            }

            @Override
            protected final void b(int n2) {
                ((AbstractIntList)this.d).removeInt(n2);
            }

            @Override
            protected final int b() {
                return this.d.c - this.d.b;
            }

            @Override
            public final int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.c = this.b++;
                return this.d.IntArrayList.this.a[this.d.b + this.c];
            }

            @Override
            public final int a() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.c = --this.b;
                return this.d.IntArrayList.this.a[this.d.b + this.b];
            }

            @Override
            public final void forEachRemaining(IntConsumer action) {
                int n2 = this.d.c - this.d.b;
                while (this.b < n2) {
                    ++this.b;
                    this.c = this.c;
                    action.accept(this.d.IntArrayList.this.a[this.d.b + this.c]);
                }
            }
        }

        private final class b
        extends ag.f {
            private /* synthetic */ it.unimi.dsi.fastutil.ints.IntArrayList$b b;

            b(it.unimi.dsi.fastutil.ints.IntArrayList$b b2) {
                this.b = b2;
                super(b2.b);
            }

            private b(it.unimi.dsi.fastutil.ints.IntArrayList$b b2, int n2, int n3) {
                this.b = b2;
                super(n2, n3);
            }

            @Override
            protected final int a() {
                return this.b.c;
            }

            @Override
            protected final int a(int n2) {
                return this.b.IntArrayList.this.a[n2];
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean tryAdvance(IntConsumer action) {
                void var1_1;
                if (this.a >= this.c()) {
                    return false;
                }
                var1_1.accept(this.b.IntArrayList.this.a[this.a++]);
                return true;
            }

            @Override
            public final void forEachRemaining(IntConsumer action) {
                int n2 = this.c();
                while (this.a < n2) {
                    action.accept(this.b.IntArrayList.this.a[this.a++]);
                }
            }

            @Override
            protected final /* synthetic */ ag.a a(int n2, int n3) {
                int n4 = n3;
                n3 = n2;
                b b2 = this;
                return new b(b2.b, n3, n4);
            }
        }
    }

    private final class a
    implements IntSpliterator {
        private boolean a = false;
        private int b;
        private int c;
        private /* synthetic */ IntArrayList e;

        public a(IntArrayList intArrayList) {
            this(intArrayList, 0, intArrayList.size, false);
        }

        private a(IntArrayList intArrayList, int n2, int n3, boolean bl2) {
            this.e = intArrayList;
            assert (n2 <= n3) : "pos " + n2 + " must be <= max " + n3;
            this.b = n2;
            this.c = n3;
            this.a = bl2;
        }

        private int c() {
            if (this.a) {
                return this.c;
            }
            return this.e.size;
        }

        @Override
        public final int characteristics() {
            return 16720;
        }

        @Override
        public final long estimateSize() {
            return this.c() - this.b;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean tryAdvance(IntConsumer action) {
            void var1_1;
            if (this.b >= this.c()) {
                return false;
            }
            var1_1.accept(this.e.a[this.b++]);
            return true;
        }

        @Override
        public final void forEachRemaining(IntConsumer action) {
            int n2 = this.c();
            while (this.b < n2) {
                action.accept(this.e.a[this.b]);
                ++this.b;
            }
        }

        @Override
        public final IntSpliterator m_() {
            int n2 = this.c();
            int n3 = n2 - this.b >> 1;
            if (n3 <= 1) {
                return null;
            }
            this.c = n2;
            n3 = n2 = this.b + n3;
            int n4 = this.b;
            this.b = n2;
            this.a = true;
            return new a(this.e, n4, n3, true);
        }

        @Override
        public final /* synthetic */ Spliterator.OfInt trySplit() {
            return this.m_();
        }

        @Override
        public final /* synthetic */ Spliterator.OfPrimitive trySplit() {
            return this.m_();
        }

        @Override
        public final /* synthetic */ Spliterator trySplit() {
            return this.m_();
        }
    }
}

