/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.ClosedStorageException;
import com.intellij.util.io.FileChannelInterruptsRetryer;
import com.intellij.util.io.FilePageCacheLockFree;
import com.intellij.util.io.OpenChannelsCache;
import com.intellij.util.io.PageCacheUtils;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.pagecache.FilePageCacheStatistics;
import com.intellij.util.io.pagecache.Page;
import com.intellij.util.io.pagecache.PagedStorage;
import com.intellij.util.io.pagecache.impl.PageContentLockingStrategy;
import com.intellij.util.io.pagecache.impl.PageImpl;
import com.intellij.util.io.pagecache.impl.PageToStorageHandle;
import com.intellij.util.io.pagecache.impl.PagesTable;
import com.intellij.util.io.pagecache.impl.RWLockProtectedPageImpl;
import com.intellij.util.io.storage.AbstractStorage;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PagedFileStorageWithRWLockedPageContent
implements PagedStorage {
    private static final Logger LOG = Logger.getInstance(PagedFileStorageWithRWLockedPageContent.class);
    public static final int DEFAULT_PAGE_SIZE = PageCacheUtils.DEFAULT_PAGE_SIZE;
    private static final StorageLockContext DEFAULT_LOCK_CONTEXT = new StorageLockContext(false);
    public static final ThreadLocal<StorageLockContext> THREAD_LOCAL_STORAGE_LOCK_CONTEXT = new ThreadLocal();
    private static final int MAX_ATTEMPTS_TO_ACQUIRE_PAGE = SystemProperties.getIntProperty("vfs.lock-free-impl.max-attempts-to-acquire-page", 10000);
    @NotNull
    private final StorageLockContext storageLockContext;
    @NotNull
    private final Path file;
    private final boolean readOnly;
    private final int pageSize;
    private final boolean nativeBytesOrder;
    private final PageContentLockingStrategy pageContentLockingStrategy;
    @NotNull
    private final FilePageCacheLockFree pageCache;
    private final transient FilePageCacheStatistics pageCacheStatistics;
    private final PagesTable pages;
    private volatile Future<?> closingInProgress;
    private final AtomicInteger dirtyPagesCount;
    private final AtomicLong actualSize;
    private final transient PageToStorageHandle pageToStorageHandle;
    private static final int MAX_FILLER_SIZE = 8192;
    private static final byte[] ZEROES = new byte[8192];

    public static PagedFileStorageWithRWLockedPageContent createWithDefaults(@NotNull Path file2, @Nullable StorageLockContext storageLockContext, int pageSize, boolean nativeBytesOrder, @NotNull PageContentLockingStrategy strategy) throws IOException {
        if (file2 == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(0);
        }
        if (strategy == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(1);
        }
        boolean readOnly = PersistentHashMapValueStorage.CreationTimeOptions.READONLY.get() == Boolean.TRUE;
        StorageLockContext storageContext = PagedFileStorageWithRWLockedPageContent.findOutAppropriateContext(storageLockContext);
        int actualPageSize = Math.max(pageSize > 0 ? pageSize : PageCacheUtils.DEFAULT_PAGE_SIZE, AbstractStorage.PAGE_SIZE);
        return new PagedFileStorageWithRWLockedPageContent(file2, storageContext, actualPageSize, nativeBytesOrder, readOnly, strategy);
    }

    public PagedFileStorageWithRWLockedPageContent(@NotNull Path file2, @NotNull StorageLockContext storageLockContext, int pageSize, @NotNull PageContentLockingStrategy strategy) throws IOException {
        if (file2 == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(2);
        }
        if (storageLockContext == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(3);
        }
        if (strategy == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(4);
        }
        this(file2, storageLockContext, pageSize, true, false, strategy);
    }

    public PagedFileStorageWithRWLockedPageContent(@NotNull Path file2, @NotNull StorageLockContext storageLockContext, int pageSize, boolean nativeBytesOrder, @NotNull PageContentLockingStrategy strategy) throws IOException {
        if (file2 == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(5);
        }
        if (storageLockContext == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(6);
        }
        if (strategy == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(7);
        }
        this(file2, storageLockContext, pageSize, nativeBytesOrder, false, strategy);
    }

    public PagedFileStorageWithRWLockedPageContent(@NotNull Path file2, @NotNull StorageLockContext storageLockContext, int pageSize, boolean nativeBytesOrder, boolean readOnly, @NotNull PageContentLockingStrategy strategy) throws IOException {
        if (file2 == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(8);
        }
        if (storageLockContext == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(9);
        }
        if (strategy == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(10);
        }
        this.closingInProgress = null;
        this.dirtyPagesCount = new AtomicInteger(0);
        this.actualSize = new AtomicLong(0L);
        this.pageToStorageHandle = new PageToStorageHandle(){

            @Override
            public void pageBecomeDirty() {
                PagedFileStorageWithRWLockedPageContent.this.dirtyPagesCount.incrementAndGet();
            }

            @Override
            public void pageBecomeClean() {
                int dirtyPages = PagedFileStorageWithRWLockedPageContent.this.dirtyPagesCount.decrementAndGet();
                if (dirtyPages < 0) {
                    throw new AssertionError((Object)("Bug: dirty pages (=" + dirtyPages + ") can't be negative"));
                }
            }

            @Override
            public void modifiedRegionUpdated(long startOffsetInFile, int length) {
                long requiredFileSize;
                long actualFileSize;
                do {
                    if ((actualFileSize = PagedFileStorageWithRWLockedPageContent.this.actualSize.get()) < (requiredFileSize = startOffsetInFile + (long)length)) continue;
                    return;
                } while (!PagedFileStorageWithRWLockedPageContent.this.actualSize.compareAndSet(actualFileSize, requiredFileSize));
            }

            @Override
            public void flushBytes(@NotNull ByteBuffer dataToFlush, long offsetInFile) throws IOException {
                if (dataToFlush == null) {
                    1.$$$reportNull$$$0(0);
                }
                PagedFileStorageWithRWLockedPageContent.this.flushPage(dataToFlush, offsetInFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataToFlush", "com/intellij/util/io/PagedFileStorageWithRWLockedPageContent$1", "flushBytes"));
            }
        };
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize(=" + pageSize + ") must be positive");
        }
        this.file = file2;
        this.storageLockContext = storageLockContext;
        this.pageSize = pageSize;
        this.readOnly = readOnly;
        this.nativeBytesOrder = nativeBytesOrder;
        this.pageContentLockingStrategy = strategy;
        this.pageCache = this.storageLockContext.pageCache();
        this.pages = this.pageCache.registerStorage(this);
        try {
            if (Files.exists(file2, new LinkOption[0])) {
                this.actualSize.set(Files.size(file2));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pageCacheStatistics = this.pageCache.getStatistics();
    }

    @Override
    @NotNull
    public Path getFile() {
        Path path = this.file;
        if (path == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(11);
        }
        return path;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public boolean isNativeBytesOrder() {
        return this.nativeBytesOrder;
    }

    @Override
    public void putInt(long offsetInFile, int value) throws IOException {
        this.checkValueIsPageAligned(offsetInFile, 4);
        int pageIndex = this.toPageIndex(offsetInFile);
        int offsetOnPage = this.toOffsetInPage(offsetInFile);
        try (Page page = this.pageByIndex(pageIndex, true);){
            page.putInt(offsetOnPage, value);
        }
    }

    @Override
    public int getInt(long offsetInFile) throws IOException {
        this.checkValueIsPageAligned(offsetInFile, 4);
        int pageIndex = this.toPageIndex(offsetInFile);
        int offsetInPage = this.toOffsetInPage(offsetInFile);
        try (Page page = this.pageByIndex(pageIndex, false);){
            int n2 = page.getInt(offsetInPage);
            return n2;
        }
    }

    @Override
    public void putLong(long offsetInFile, long value) throws IOException {
        this.checkValueIsPageAligned(offsetInFile, 8);
        int pageIndex = this.toPageIndex(offsetInFile);
        int offsetInPage = this.toOffsetInPage(offsetInFile);
        try (Page page = this.pageByIndex(pageIndex, true);){
            page.putLong(offsetInPage, value);
        }
    }

    @Override
    public long getLong(long offsetInFile) throws IOException {
        this.checkValueIsPageAligned(offsetInFile, 8);
        int pageIndex = this.toPageIndex(offsetInFile);
        int offsetInPage = this.toOffsetInPage(offsetInFile);
        try (Page page = this.pageByIndex(pageIndex, false);){
            long l2 = page.getLong(offsetInPage);
            return l2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putBuffer(long offsetInFile, @NotNull ByteBuffer byteBuffer) throws IOException {
        void data2;
        if (byteBuffer == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(12);
        }
        this.checkValueIsPageAligned(offsetInFile, data2.remaining());
        int pageIndex = this.toPageIndex(offsetInFile);
        int offsetInPage = this.toOffsetInPage(offsetInFile);
        try (Page page = this.pageByIndex(pageIndex, true);){
            page.putFromBuffer((ByteBuffer)data2, offsetInPage);
        }
    }

    @Override
    public byte get(long offsetInFile) throws IOException {
        int pageIndex = this.toPageIndex(offsetInFile);
        int offsetInPage = this.toOffsetInPage(offsetInFile);
        try (Page page = this.pageByIndex(pageIndex, false);){
            byte by = page.get(offsetInPage);
            return by;
        }
    }

    @Override
    public void put(long offsetInFile, byte value) throws IOException {
        int pageIndex = this.toPageIndex(offsetInFile);
        int offsetInPage = this.toOffsetInPage(offsetInFile);
        try (Page page = this.pageByIndex(pageIndex, true);){
            page.put(offsetInPage, value);
        }
    }

    @Override
    public void get(long offsetInFile, byte[] destination, int offsetInArray, int length) throws IOException {
        long currentOffsetInFile = offsetInFile;
        int currentOffsetInArray = offsetInArray;
        int remainingBytesToRead = length;
        while (remainingBytesToRead > 0) {
            int pageIndex = this.toPageIndex(currentOffsetInFile);
            int offsetInPage = this.toOffsetInPage(currentOffsetInFile);
            int bytesToRead = Math.min(remainingBytesToRead, this.pageSize - offsetInPage);
            try (Page page = this.pageByIndex(pageIndex, false);){
                page.readToArray(destination, currentOffsetInArray, offsetInPage, bytesToRead);
            }
            remainingBytesToRead -= bytesToRead;
            currentOffsetInArray += bytesToRead;
            currentOffsetInFile += (long)bytesToRead;
        }
    }

    @Override
    public void put(long offsetInFile, byte[] src, int offsetInArray, int length) throws IOException {
        long i2 = offsetInFile;
        int o2 = offsetInArray;
        int l2 = length;
        while (l2 > 0) {
            int pageIndex = this.toPageIndex(i2);
            int offsetInPage = this.toOffsetInPage(i2);
            int page_len = Math.min(l2, this.pageSize - offsetInPage);
            try (Page page = this.pageByIndex(pageIndex, true);){
                page.putFromArray(src, o2, offsetInPage, page_len);
            }
            l2 -= page_len;
            o2 += page_len;
            i2 += (long)page_len;
        }
    }

    @Override
    public long length() {
        return this.actualSize.get();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    @Override
    public boolean isDirty() {
        return this.dirtyPagesCount.get() > 0;
    }

    @Override
    @NotNull
    public Page pageByOffset(long offsetInFile, boolean forModification) throws IOException {
        int pageIndex = this.toPageIndex(offsetInFile);
        Page page = this.pageByIndex(pageIndex, forModification);
        if (page == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(13);
        }
        return page;
    }

    public Page pageByIndex(int pageIndex, boolean forModification) throws IOException {
        if (this.readOnly && forModification) {
            throw new IOException("Read-only storage can't be modified");
        }
        if (pageIndex < 0) {
            throw new AssertionError((Object)("Page " + pageIndex + " must be >=0"));
        }
        long startedAtNs = this.pageCacheStatistics.startTimestampNs();
        int attempt = 0;
        while (true) {
            if (this.isClosed()) {
                throw new ClosedStorageException("Storage is already closed: " + this.file);
            }
            PageImpl page = this.pages.lookupOrCreate(pageIndex, this::createUninitializedPage);
            try {
                while (!page.tryAcquireForUse(this)) {
                    if (page.isNotReadyYet() && page.tryPrepareForUse(this::loadPageData)) continue;
                    Thread.yield();
                }
                this.pageCacheStatistics.pageRequested(page.pageSize(), startedAtNs);
                return page;
            }
            catch (IOException e2) {
                if (attempt > MAX_ATTEMPTS_TO_ACQUIRE_PAGE) {
                    throw new AssertionError((Object)(page + " can't be acquired in " + attempt + " attempts: either we're very unlucky, or it is a bug"));
                }
                LOG.trace("Page " + page + " likely released -> request it again (" + e2.getMessage() + ")");
                if (page.isAboutToUnmap()) {
                    boolean succeed = page.tryMoveTowardsPreTombstone(false);
                    if (succeed) {
                        this.pageCache.unmapPageAndReclaimBuffer(page);
                    }
                } else if (attempt < 10) {
                    Thread.yield();
                } else {
                    this.pageCache.waitForHousekeepingTurn(1);
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closingInProgress != null;
    }

    @Override
    public void force() throws IOException {
        if (this.isDirty()) {
            this.pages.flushAll();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.pageCache.tryToReclaimAll(this.pages);
        Future<?> future = this.closeAsync();
        try {
            future.get();
        }
        catch (ExecutionException e2) {
            Throwable cause = e2.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("Can't close storage for " + this.file, cause);
        }
        catch (InterruptedException e3) {
            InterruptedIOException ioEx = new InterruptedIOException("Closing storage for " + this.file + " was interrupted");
            ioEx.addSuppressed(e3);
            throw ioEx;
        }
    }

    public synchronized Future<?> closeAsync() {
        if (!this.isClosed()) {
            CompletableFuture<Object> closingProgress = new CompletableFuture<Object>();
            this.closingInProgress = closingProgress;
            this.pageCache.enqueueStoragePagesClosing(this, closingProgress);
        }
        return this.closingInProgress;
    }

    public void closeAndRemoveAllFiles() throws IOException, InterruptedException {
        if (!this.isClosed()) {
            this.close();
        }
        FileUtil.delete(this.file);
    }

    @Override
    public int toOffsetInPage(long offsetInFile) {
        return (int)(offsetInFile % (long)this.pageSize);
    }

    public String toString() {
        return "PagedFileStorage[" + this.file + "]{size: " + this.actualSize.get() + ", dirtyPages: " + this.dirtyPagesCount.get() + "}{pageSize: " + this.pageSize + ", " + (this.isClosed() ? "closed " : "") + (this.isReadOnly() ? "readOnly " : "") + (this.isNativeBytesOrder() ? "nativeByteOrder" : "") + "}";
    }

    private int toPageIndex(long offsetInFile) {
        int pageIndex = (int)(offsetInFile / (long)this.pageSize);
        if (pageIndex < 0) {
            throw new AssertionError((Object)("pageIndex(offset: " + offsetInFile + ") = " + pageIndex + ", but must be >=0"));
        }
        return pageIndex;
    }

    private boolean isValueAlignedToPage(long offsetInFile, int valueLength) {
        int offsetInPage = (int)(offsetInFile % (long)this.pageSize);
        int remainsOnPage = this.pageSize - offsetInPage;
        return valueLength <= remainsOnPage;
    }

    private void checkValueIsPageAligned(long offsetInFile, int valueLength) throws IOException {
        if (!this.isValueAlignedToPage(offsetInFile, valueLength)) {
            throw new IOException(valueLength + " bytes @ " + offsetInFile + " break page [" + this.pageSize + "b] border: use PagedStorageWithUnalignedAccess wrapper if un-aligned primitive access is needed");
        }
    }

    PagesTable pages() {
        return this.pages;
    }

    <R> R executeOp(@NotNull OpenChannelsCache.FileChannelOperation<R> operation, boolean readOnly) throws IOException {
        if (operation == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(14);
        }
        return this.storageLockContext.executeOp(this.file, operation, readOnly);
    }

    <R> R executeIdempotentOp(@NotNull FileChannelInterruptsRetryer.FileChannelIdempotentOperation<R> operation, boolean readOnly) throws IOException {
        if (operation == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(15);
        }
        return this.storageLockContext.executeIdempotentOp(this.file, operation, readOnly);
    }

    private PageImpl createUninitializedPage(int pageIndex) {
        ReentrantReadWriteLock lockToUseWithPage = this.pageContentLockingStrategy.lockForPage(this, pageIndex);
        return RWLockProtectedPageImpl.createBlankWithExplicitLock(pageIndex, this.pageSize, this.pageToStorageHandle, lockToUseWithPage);
    }

    private ByteBuffer loadPageData(@NotNull PageImpl pageToLoad) throws IOException {
        if (pageToLoad == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(16);
        }
        if (this.isClosed()) {
            throw new ClosedStorageException("Storage is already closed");
        }
        if (!pageToLoad.isLoading()) {
            throw new AssertionError((Object)("Bug: page must be in LOADING, but " + pageToLoad));
        }
        long startedAtNs = this.pageCacheStatistics.startTimestampNs();
        ByteBuffer pageBuffer = this.pageCache.allocatePageBuffer(this.pageSize);
        pageBuffer.order(this.nativeBytesOrder ? ByteOrder.nativeOrder() : ByteOrder.BIG_ENDIAN);
        try {
            this.executeIdempotentOp(ch -> {
                int readBytes = ch.read(pageBuffer, pageToLoad.offsetInFile());
                int bytesActuallyRead = Math.max(0, readBytes);
                if (readBytes < this.pageSize) {
                    PagedFileStorageWithRWLockedPageContent.fillWithZeroes(pageBuffer, bytesActuallyRead, this.pageSize);
                }
                this.pageCacheStatistics.pageRead(bytesActuallyRead, startedAtNs);
                return pageBuffer;
            }, this.isReadOnly());
        }
        catch (Throwable t2) {
            this.pageCache.reclaimPageBuffer(this.pageSize, pageBuffer);
            throw t2;
        }
        return pageBuffer;
    }

    private void flushPage(@NotNull ByteBuffer bufferToSave, long offsetInFile) throws IOException {
        if (bufferToSave == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(17);
        }
        long startedAtNs = this.pageCacheStatistics.startTimestampNs();
        int bytesToStore = bufferToSave.remaining();
        this.executeIdempotentOp(ch -> {
            ch.write(bufferToSave, offsetInFile);
            return null;
        }, this.isReadOnly());
        this.pageCacheStatistics.pageWritten(bytesToStore, startedAtNs);
    }

    private static void fillWithZeroes(@NotNull ByteBuffer pageBuffer, int startOffsetInclusive, int endOffsetExclusive) {
        int toFillNow;
        if (pageBuffer == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(18);
        }
        for (int currentOffset = startOffsetInclusive; currentOffset < endOffsetExclusive; currentOffset += toFillNow) {
            int remains = endOffsetExclusive - currentOffset;
            toFillNow = Math.min(remains, 8192);
            pageBuffer.put(ZEROES, 0, toFillNow);
        }
    }

    @NotNull
    private static StorageLockContext findOutAppropriateContext(@Nullable StorageLockContext storageLockContext) {
        StorageLockContext threadContext = THREAD_LOCAL_STORAGE_LOCK_CONTEXT.get();
        if (threadContext != null) {
            if (storageLockContext != null && storageLockContext != threadContext) {
                throw new IllegalStateException("Context(" + storageLockContext + ") != THREAD_LOCAL_STORAGE_LOCK_CONTEXT(" + threadContext + ")");
            }
            StorageLockContext storageLockContext2 = threadContext;
            if (storageLockContext2 == null) {
                PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(19);
            }
            return storageLockContext2;
        }
        StorageLockContext storageLockContext3 = storageLockContext != null ? storageLockContext : DEFAULT_LOCK_CONTEXT;
        if (storageLockContext3 == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(20);
        }
        return storageLockContext3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: 
            case 19: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 11: 
            case 13: 
            case 19: 
            case 20: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageLockContext";
                break;
            }
            case 11: 
            case 13: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/PagedFileStorageWithRWLockedPageContent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageToLoad";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bufferToSave";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageBuffer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/PagedFileStorageWithRWLockedPageContent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "pageByOffset";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findOutAppropriateContext";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createWithDefaults";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 13: 
            case 19: 
            case 20: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putBuffer";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executeOp";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "executeIdempotentOp";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadPageData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "flushPage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fillWithZeroes";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: 
            case 13: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

