/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.BaseDataReader;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public abstract class BinaryOutputReader
extends BaseDataReader {
    @NotNull
    private final InputStream myStream;
    private final byte @NotNull [] myBuffer;

    public BinaryOutputReader(@NotNull InputStream stream, @NotNull BaseDataReader.SleepingPolicy sleepingPolicy) {
        if (stream == null) {
            BinaryOutputReader.$$$reportNull$$$0(0);
        }
        if (sleepingPolicy == null) {
            BinaryOutputReader.$$$reportNull$$$0(1);
        }
        super(sleepingPolicy);
        this.myBuffer = new byte[8192];
        this.myStream = stream;
    }

    @Override
    protected boolean readAvailableNonBlocking() throws IOException {
        int n2;
        byte[] buffer = this.myBuffer;
        boolean read = false;
        while (this.myStream.available() > 0 && (n2 = this.myStream.read(buffer)) >= 0) {
            if (n2 <= 0) continue;
            read = true;
            this.onBinaryAvailable(buffer, n2);
        }
        return read;
    }

    @Override
    protected final boolean readAvailableBlocking() throws IOException {
        int n2;
        byte[] buffer = this.myBuffer;
        boolean read = false;
        while ((n2 = this.myStream.read(buffer)) >= 0) {
            if (n2 <= 0) continue;
            read = true;
            this.onBinaryAvailable(buffer, n2);
        }
        return read;
    }

    protected abstract void onBinaryAvailable(byte @NotNull [] var1, int var2);

    @Override
    protected void close() throws IOException {
        this.myStream.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "stream";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sleepingPolicy";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/io/BinaryOutputReader";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

