/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.ValueSerializationProblemReporter;
import com.intellij.util.indexing.impl.forward.AbstractForwardIndexAccessor;
import com.intellij.util.io.DataExternalizer;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ValueSerializationChecker<Value, Input> {
    private static final Logger LOG = Logger.getInstance(ValueSerializationChecker.class);
    @NotNull
    private final DataExternalizer<Value> myValueExternalizer;
    @NotNull
    private final IndexId<?, Value> myIndexId;
    @NotNull
    private final ValueSerializationProblemReporter myProblemReporter;
    static final ValueSerializationProblemReporter DEFAULT_SERIALIZATION_PROBLEM_REPORTER = ex -> LOG.error(ex);

    ValueSerializationChecker(@NotNull IndexExtension<?, Value, ?> extension, @NotNull ValueSerializationProblemReporter reporter) {
        if (extension == null) {
            ValueSerializationChecker.$$$reportNull$$$0(0);
        }
        if (reporter == null) {
            ValueSerializationChecker.$$$reportNull$$$0(1);
        }
        this.myValueExternalizer = extension.getValueExternalizer();
        this.myIndexId = extension.getName();
        this.myProblemReporter = reporter;
    }

    void checkValueSerialization(@NotNull Map<?, Value> data2, @NotNull Input input) {
        Exception problem;
        if (data2 == null) {
            ValueSerializationChecker.$$$reportNull$$$0(2);
        }
        if (input == null) {
            ValueSerializationChecker.$$$reportNull$$$0(3);
        }
        if (IndexDebugProperties.DEBUG && !IndexDebugProperties.IS_IN_STRESS_TESTS && (problem = this.getValueSerializationProblem(data2, input)) != null) {
            this.myProblemReporter.reportProblem(problem);
        }
    }

    @Nullable
    private Exception getValueSerializationProblem(@NotNull Map<?, Value> data2, @NotNull Input input) {
        if (data2 == null) {
            ValueSerializationChecker.$$$reportNull$$$0(4);
        }
        if (input == null) {
            ValueSerializationChecker.$$$reportNull$$$0(5);
        }
        for (Value value : data2.values()) {
            if (!Comparing.equal(value, value) || value != null && value.hashCode() != value.hashCode()) {
                return new Exception("Index " + this.myIndexId + " violates equals / hashCode contract for Value parameter");
            }
            try {
                Object deserializedValue;
                ByteArraySequence sequence = AbstractForwardIndexAccessor.serializeValueToByteSeq(value, this.myValueExternalizer, 4);
                Object object = deserializedValue = sequence == null ? null : (Object)this.myValueExternalizer.read(sequence.toInputStream());
                if (Comparing.equal(value, deserializedValue) && (value == null || value.hashCode() == deserializedValue.hashCode())) continue;
                LOG.error("Index " + this.myIndexId + " deserialization violates equals / hashCode contract for Value parameter" + " while indexing " + input + ". Original value: '" + value + "'; Deserialized value: '" + deserializedValue + "'");
            }
            catch (IOException ex) {
                return ex;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/impl/ValueSerializationChecker";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkValueSerialization";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueSerializationProblem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

