/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import java.util.function.Function;
import kotlin.coroutines.CoroutineContext;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;

final class ContextFunction<T, R>
implements Function<T, R> {
    @NotNull
    private final CoroutineContext myParentContext;
    @NotNull
    private final Function<T, R> myFunction;

    @Async.Schedule
    ContextFunction(@NotNull CoroutineContext context, @NotNull Function<T, R> function) {
        if (context == null) {
            ContextFunction.$$$reportNull$$$0(0);
        }
        if (function == null) {
            ContextFunction.$$$reportNull$$$0(1);
        }
        this.myParentContext = context;
        this.myFunction = function;
    }

    @Override
    @Async.Execute
    public R apply(T arg2) {
        try (AccessToken ignored = ThreadContext.installThreadContext(this.myParentContext, true);){
            R r2 = this.myFunction.apply(arg2);
            return r2;
        }
    }

    public String toString() {
        return this.myFunction.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "function";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/concurrency/ContextFunction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

