/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

public final class MathUtil {
    public static int nonNegativeAbs(int a2) {
        return a2 >= 0 ? a2 : (a2 == Integer.MIN_VALUE ? Integer.MAX_VALUE : -a2);
    }

    public static int clamp(int value, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException(min + ">" + max);
        }
        return Math.min(max, Math.max(value, min));
    }

    public static long clamp(long value, long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException(min + ">" + max);
        }
        return Math.min(max, Math.max(value, min));
    }

    public static double clamp(double value, double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException(min + ">" + max);
        }
        return Math.min(max, Math.max(value, min));
    }

    public static float clamp(float value, float min, float max) {
        if (min > max) {
            throw new IllegalArgumentException(min + ">" + max);
        }
        return Math.min(max, Math.max(value, min));
    }

    public static boolean equals(float a2, float b2, float epsilon) {
        return Math.abs(a2 - b2) < epsilon;
    }

    public static boolean equals(double a2, double b2, double epsilon) {
        return Math.abs(a2 - b2) < epsilon;
    }

    public static int compare(float a2, float b2, float epsilon) {
        return Math.abs(a2 - b2) < epsilon ? 0 : Float.compare(a2, b2);
    }

    public static int compare(double a2, double b2, double epsilon) {
        return Math.abs(a2 - b2) < epsilon ? 0 : Double.compare(a2, b2);
    }

    public static boolean between(float min, float med, float max, float epsilon) {
        return MathUtil.compare(min, med, epsilon) < 0 && MathUtil.compare(med, max, epsilon) < 0;
    }

    public static boolean between(double min, double med, double max, double epsilon) {
        return MathUtil.compare(min, med, epsilon) < 0 && MathUtil.compare(med, max, epsilon) < 0;
    }
}

