/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.util.ThrowableConsumer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jetbrains.annotations.NotNull;

public abstract class TempCopyArchiveHandler
extends ArchiveHandler {
    protected TempCopyArchiveHandler(@NotNull String path) {
        if (path == null) {
            TempCopyArchiveHandler.$$$reportNull$$$0(0);
        }
        super(path);
    }

    protected abstract String getTempDir();

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.removeTempCopy();
    }

    private void removeTempCopy() {
        FileUtil.delete(this.getTempFile());
    }

    @NotNull
    protected File getTempCopy(@NotNull ThrowableConsumer<? super File, ? extends IOException> initializer) throws IOException {
        if (initializer == null) {
            TempCopyArchiveHandler.$$$reportNull$$$0(1);
        }
        File file2 = this.getFile();
        File copy2 = this.getTempFile();
        if (!copy2.exists() || copy2.lastModified() != file2.lastModified()) {
            FileUtil.createParentDirs(copy2);
            initializer.consume((Object)copy2);
            Files.setLastModifiedTime(copy2.toPath(), Files.getLastModifiedTime(file2.toPath(), new LinkOption[0]));
        }
        File file3 = copy2;
        if (file3 == null) {
            TempCopyArchiveHandler.$$$reportNull$$$0(2);
        }
        return file3;
    }

    @NotNull
    private File getTempFile() {
        File file2 = this.getFile();
        String hash = Integer.toHexString(file2.getPath().hashCode());
        return new File(PathManager.getSystemPath() + '/' + this.getTempDir() + '/' + file2.getName() + '_' + hash);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/TempCopyArchiveHandler";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/TempCopyArchiveHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempCopy";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTempCopy";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

