/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvalidVirtualFileAccessException
extends RuntimeException {
    private static final Key<String> INVALIDATION_REASON = Key.create("INVALIDATION_REASON");
    private static final Key<Throwable> INVALIDATION_TRACE = Key.create("INVALIDATION_TRACE");

    public InvalidVirtualFileAccessException(@NotNull VirtualFile file2) {
        if (file2 == null) {
            InvalidVirtualFileAccessException.$$$reportNull$$$0(0);
        }
        super(InvalidVirtualFileAccessException.composeMessage(file2));
        this.initCause(InvalidVirtualFileAccessException.getInvalidationTrace(file2));
    }

    public InvalidVirtualFileAccessException(@NotNull String message) {
        if (message == null) {
            InvalidVirtualFileAccessException.$$$reportNull$$$0(1);
        }
        super(message);
    }

    @NonNls
    private static String composeMessage(@NotNull VirtualFile file2) {
        if (file2 == null) {
            InvalidVirtualFileAccessException.$$$reportNull$$$0(2);
        }
        String url = file2.getUrl();
        @NonNls String message = "Accessing invalid virtual file: " + url;
        String reason = InvalidVirtualFileAccessException.getInvalidationReason(file2);
        if (reason != null) {
            message = message + "; reason: " + reason;
        }
        try {
            VirtualFile found = VirtualFileManager.getInstance().findFileByUrl(url);
            message = message + "; original:" + InvalidVirtualFileAccessException.hashCode(file2) + "; found:" + InvalidVirtualFileAccessException.hashCode(found);
            if (file2.isInLocalFileSystem()) {
                boolean physicalExists = new File(file2.getPath()).exists();
                message = message + "; File.exists()=" + physicalExists;
            } else {
                message = message + "; file system=" + file2.getFileSystem();
            }
        }
        catch (Throwable t2) {
            message = message + "; lookup failed: " + t2.getMessage();
        }
        return message;
    }

    private static String hashCode(Object o2) {
        return o2 == null ? "-" : String.valueOf(o2.hashCode());
    }

    @ApiStatus.Internal
    public static void appendInvalidationReason(@NotNull VirtualFile file2, @NotNull String reason) {
        String oldReason;
        if (file2 == null) {
            InvalidVirtualFileAccessException.$$$reportNull$$$0(3);
        }
        if (reason == null) {
            InvalidVirtualFileAccessException.$$$reportNull$$$0(4);
        }
        if ((oldReason = InvalidVirtualFileAccessException.getInvalidationReason(file2)) == null) {
            file2.putUserData(INVALIDATION_TRACE, ThrowableInterner.intern(new Throwable()));
        }
        file2.putUserData(INVALIDATION_REASON, oldReason == null ? reason : oldReason + "; " + reason);
    }

    @Nullable
    private static Throwable getInvalidationTrace(@NotNull VirtualFile file2) {
        if (file2 == null) {
            InvalidVirtualFileAccessException.$$$reportNull$$$0(5);
        }
        return file2.getUserData(INVALIDATION_TRACE);
    }

    @ApiStatus.Internal
    @Nullable
    public static String getInvalidationReason(@NotNull VirtualFile file2) {
        if (file2 == null) {
            InvalidVirtualFileAccessException.$$$reportNull$$$0(6);
        }
        return file2.getUserData(INVALIDATION_REASON);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/InvalidVirtualFileAccessException";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "composeMessage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "appendInvalidationReason";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getInvalidationTrace";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getInvalidationReason";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

