/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xml.dom.XmlDomReader;
import com.intellij.util.xml.dom.XmlElement;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplicationNamesInfo {
    private final String myProductName;
    private final String myFullProductName;
    private final String myEditionName;
    private final String myScriptName;
    private final String myMotto;
    private static volatile ApplicationNamesInfo instance;

    @NotNull
    private static XmlElement loadData() {
        XmlElement xmlElement;
        String prefix;
        block21: {
            prefix = System.getProperty("idea.platform.prefix", "");
            String appInfoData = ApplicationNamesInfo.getAppInfoData();
            if (AppMode.isDevServer() && appInfoData.isEmpty()) {
                String module = null;
                if (prefix.isEmpty() || prefix.equals("idea")) {
                    module = "intellij.idea.ultimate.customization";
                } else if (prefix.equals("WebStorm")) {
                    module = "intellij.webstorm";
                }
                if (module != null) {
                    XmlElement xmlElement2;
                    Path file2 = Paths.get(PathManager.getHomePath() + "/out/classes/production/" + module + "/idea/" + (prefix.equals("idea") ? "" : prefix) + "ApplicationInfo.xml", new String[0]);
                    try {
                        xmlElement2 = XmlDomReader.readXmlAsModel(Files.newInputStream(file2, new OpenOption[0]));
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        break block21;
                    }
                    catch (Exception e2) {
                        throw new RuntimeException("Cannot load " + file2, e2);
                    }
                    if (xmlElement2 == null) {
                        ApplicationNamesInfo.$$$reportNull$$$0(0);
                    }
                    return xmlElement2;
                }
            } else {
                String customAppInfo;
                if (prefix.equals("Gateway") && (customAppInfo = System.getProperty("idea.application.info.value")) != null) {
                    XmlElement xmlElement3;
                    try {
                        Path file3 = Paths.get(customAppInfo, new String[0]);
                        xmlElement3 = XmlDomReader.readXmlAsModel(Files.newInputStream(file3, new OpenOption[0]));
                    }
                    catch (Exception e3) {
                        throw new RuntimeException("Cannot load custom application info file " + customAppInfo, e3);
                    }
                    if (xmlElement3 == null) {
                        ApplicationNamesInfo.$$$reportNull$$$0(1);
                    }
                    return xmlElement3;
                }
                boolean forceLoadingFromResources = "true".equals(System.getProperty("intellij.platform.load.app.info.from.resources"));
                if (!forceLoadingFromResources && !appInfoData.isEmpty()) {
                    XmlElement xmlElement4 = XmlDomReader.readXmlAsModel(appInfoData.getBytes(StandardCharsets.UTF_8));
                    if (xmlElement4 == null) {
                        ApplicationNamesInfo.$$$reportNull$$$0(2);
                    }
                    return xmlElement4;
                }
            }
        }
        String resource = "idea/" + (prefix.equals("idea") ? "" : prefix) + "ApplicationInfo.xml";
        InputStream stream = ApplicationNamesInfo.class.getClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            throw new RuntimeException("Resource not found: " + resource);
        }
        try {
            XmlElement data2 = XmlDomReader.readXmlAsModel(stream);
            if (PlatformUtils.isQodana()) {
                ApplicationNamesInfo.setQodanaProductAttributes(data2);
            }
            xmlElement = data2;
        }
        catch (Exception e4) {
            throw new RuntimeException("Cannot load resource: " + resource, e4);
        }
        if (xmlElement == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(3);
        }
        return xmlElement;
    }

    private static void setQodanaProductAttributes(XmlElement data2) {
        XmlElement namesNode = data2.getChild("names");
        assert (namesNode != null);
        String qodanaProductName = System.getProperty("qodana.product.name");
        namesNode.attributes.put("product", qodanaProductName);
        namesNode.attributes.put("fullname", qodanaProductName);
        XmlElement buildNode = data2.getChild("build");
        assert (buildNode != null);
        buildNode.attributes.put("number", System.getProperty("qodana.build.number"));
    }

    @ApiStatus.Internal
    public static String getAppInfoData() {
        return "<component xmlns=\"http://jetbrains.org/intellij/schema/application-info\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://jetbrains.org/intellij/schema/application-info http://jetbrains.org/intellij/schema/ApplicationInfo.xsd\">\n  <version major=\"2024\" minor=\"2\" eap=\"false\" suffix=\"\" />\n  <company name=\"JetBrains s.r.o.\" url=\"https://www.jetbrains.com/?fromIDE\" />\n  <build number=\"RD-242.20224.401\" date=\"202408141229\" majorReleaseDate=\"20240813\" />\n  <logo url=\"/rider/artwork/release/splash.png\" />\n  <logo-eap url=\"/rider/artwork/eap/splash.png\" />\n  <about url=\"/rider/artwork/eap/about.png\" foreground=\"ffffff\" copyrightForeground=\"ffffff\" linkColor=\"589bf2\" logoX=\"540\" logoY=\"300\" logoW=\"100\" logoH=\"100\" />\n  <icon ico=\"/rider.ico\" svg=\"/rider/rider.svg\" svg-small=\"/rider/rider_16.svg\" />\n  <icon-eap svg=\"/rider/rider_EAP.svg\" svg-small=\"/rider/rider_16_EAP.svg\" />\n  <names product=\"Rider\" fullname=\"JetBrains Rider\" script=\"rider\" motto=\"A cross-platform IDE for .NET\" />\n  <essential-plugin>com.jetbrains.rider.rdct-shared</essential-plugin>\n  <essential-plugin>rider.intellij.plugin.appender</essential-plugin>\n  <essential-plugin>Rider UI Theme Pack</essential-plugin>\n  <welcome-screen logo-url=\"/rider/icon_128.svg\" />\n  <subscriptions formid=\"3437\" tips-available=\"true\" />\n  <default-laf dark-classic=\"RiderDark\" light-classic=\"RiderLight\" />\n</component>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static XmlElement initAndGetRawData() {
        Class<ApplicationNamesInfo> clazz = ApplicationNamesInfo.class;
        synchronized (ApplicationNamesInfo.class) {
            XmlElement data2 = ApplicationNamesInfo.loadData();
            if (instance == null) {
                instance = new ApplicationNamesInfo(data2);
            }
            XmlElement xmlElement = data2;
            // ** MonitorExit[var0] (shouldn't be in output)
            if (xmlElement == null) {
                ApplicationNamesInfo.$$$reportNull$$$0(4);
            }
            return xmlElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static ApplicationNamesInfo getInstance() {
        ApplicationNamesInfo result2 = instance;
        if (result2 == null) {
            Class<ApplicationNamesInfo> clazz = ApplicationNamesInfo.class;
            // MONITORENTER : com.intellij.openapi.application.ApplicationNamesInfo.class
            result2 = instance;
            if (result2 == null) {
                instance = result2 = new ApplicationNamesInfo(ApplicationNamesInfo.loadData());
            }
            // MONITOREXIT : clazz
        }
        ApplicationNamesInfo applicationNamesInfo = result2;
        if (applicationNamesInfo != null) return applicationNamesInfo;
        ApplicationNamesInfo.$$$reportNull$$$0(5);
        return applicationNamesInfo;
    }

    private ApplicationNamesInfo(@NotNull XmlElement rootElement) {
        if (rootElement == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(6);
        }
        XmlElement names = rootElement.getChild("names");
        assert (names != null);
        this.myProductName = names.getAttributeValue("product");
        this.myFullProductName = names.getAttributeValue("fullname", this.myProductName);
        this.myEditionName = names.getAttributeValue("edition");
        this.myScriptName = names.getAttributeValue("script");
        this.myMotto = names.getAttributeValue("motto", "The Drive to Develop");
    }

    @NlsSafe
    public String getProductName() {
        return this.myProductName;
    }

    @NlsSafe
    public String getFullProductName() {
        return this.myFullProductName;
    }

    @NlsSafe
    public String getFullProductNameWithEdition() {
        return this.myEditionName == null ? this.myFullProductName : this.myFullProductName + ' ' + this.myEditionName;
    }

    @NlsSafe
    @Nullable
    public String getEditionName() {
        return this.myEditionName;
    }

    public String getLowercaseProductName() {
        String s2 = this.myProductName.toLowerCase(Locale.ENGLISH);
        return Character.isUpperCase(s2.charAt(0)) ? s2 : Character.toUpperCase(s2.charAt(0)) + s2.substring(1);
    }

    public String getScriptName() {
        return this.myScriptName;
    }

    @NotNull
    public String getMotto() {
        String string2 = this.myMotto;
        if (string2 == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(7);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 6: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/ApplicationNamesInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "initAndGetRawData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/ApplicationNamesInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMotto";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

