/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.InstalledThreadContext;
import com.intellij.concurrency.ThreadContext;
import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.BlockingJob;
import com.intellij.util.concurrency.Propagation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.internal.intellij.IntellijCoroutines;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u008e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\u001a \u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0011\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0011\u001a2\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00150\u0014\"\u0004\b\u0000\u0010\u0012\"\u0004\b\u0001\u0010\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00150\u0014\u001a \u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0017\"\u0004\b\u0000\u0010\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0017\u001a\u0016\u0010\r\u001a\u00060\u0019j\u0002`\u001a2\n\u0010\u001b\u001a\u00060\u0019j\u0002`\u001a\u001a\b\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\n\u0010\u001e\u001a\u0004\u0018\u00010\fH\u0007\u001a\u0006\u0010\u001f\u001a\u00020\f\u001a#\u0010 \u001a\u0004\u0018\u00010\f2\u0016\u0010!\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\"H\u0082\b\u001a\n\u0010#\u001a\u0004\u0018\u00010\fH\u0007\u001a)\u0010$\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H\u00120(H\u0007\u00a2\u0006\u0002\u0010)\u001a\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020\f\u001a\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\fH\u0007\u001a\u0018\u00101\u001a\u00020/2\u0006\u00100\u001a\u00020\f2\b\b\u0002\u00102\u001a\u00020\b\u001a\b\u00103\u001a\u00020\bH\u0002\u001a\u0006\u00104\u001a\u00020/\u001a\b\u00105\u001a\u00020\u001dH\u0000\u001a?\u00106\u001a\u00020/\"\u0004\b\u0000\u0010\u00122\f\u00107\u001a\b\u0012\u0004\u0012\u0002H\u00120\n2!\u00108\u001a\u001d\u0012\u0013\u0012\u0011H\u0012\u00a2\u0006\f\b9\u0012\b\b:\u0012\u0004\b\b(;\u0012\u0004\u0012\u0002H\u00120\"H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"INITIAL_THREAD_CONTEXT", "Lcom/intellij/concurrency/InstalledThreadContext;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "VIOLATORS", "", "", "shouldWarnAccidentalCancellation", "", "tlCoroutineContext", "Ljava/lang/ThreadLocal;", "tlTemporaryContext", "Lkotlin/coroutines/CoroutineContext;", "captureThreadContext", "Ljava/util/concurrent/Callable;", "V", "callable", "Ljava/util/function/Consumer;", "T", "c", "Ljava/util/function/Function;", "U", "f", "Ljava/util/function/Supplier;", "s", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "runnable", "checkContextInstalled", "", "currentTemporaryThreadContextOrNull", "currentThreadContext", "currentThreadContextOrFallback", "getter", "Lkotlin/Function1;", "currentThreadContextOrNull", "escapeCancellation", "job", "Lkotlinx/coroutines/Job;", "action", "Lkotlin/Function0;", "(Lkotlinx/coroutines/Job;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getContextSkeleton", "", "Lkotlin/coroutines/CoroutineContext$Element;", "context", "installTemporaryThreadContext", "Lcom/intellij/openapi/application/AccessToken;", "coroutineContext", "installThreadContext", "replace", "isKnownViolator", "resetThreadContext", "warnAccidentalCancellation", "withThreadLocal", "variable", "update", "Lkotlin/ParameterName;", "name", "value", "intellij.platform.util"})
@JvmName(name="ThreadContext")
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nthreadContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 threadContext.kt\ncom/intellij/concurrency/ThreadContext\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,474:1\n89#1,11:475\n89#1,11:486\n89#1,11:497\n11065#2:508\n11400#2,3:509\n1747#3,3:512\n*S KotlinDebug\n*F\n+ 1 threadContext.kt\ncom/intellij/concurrency/ThreadContext\n*L\n105#1:475,11\n114#1:486,11\n120#1:497,11\n212#1:508\n212#1:509,3\n213#1:512,3\n*E\n"})
public final class ThreadContext {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final InstalledThreadContext INITIAL_THREAD_CONTEXT;
    @NotNull
    private static final ThreadLocal<InstalledThreadContext> tlCoroutineContext;
    @NotNull
    private static final List<String> VIOLATORS;
    private static final boolean shouldWarnAccidentalCancellation;
    @NotNull
    private static final ThreadLocal<CoroutineContext> tlTemporaryContext;

    private static final CoroutineContext currentThreadContextOrFallback(Function1<? super CoroutineContext, ? extends CoroutineContext> getter) {
        boolean $i$f$currentThreadContextOrFallback = false;
        if (!Propagation.getUseImplicitBlockingContext()) {
            return tlCoroutineContext.get().getContext();
        }
        CoroutineContext suspendingContext = IntellijCoroutines.INSTANCE.currentThreadCoroutineContext();
        InstalledThreadContext installedThreadContext = tlCoroutineContext.get();
        CoroutineContext snapshot = installedThreadContext.component1();
        CoroutineContext overridingContext = installedThreadContext.component2();
        if (suspendingContext == snapshot) {
            return overridingContext;
        }
        return getter.invoke(suspendingContext);
    }

    @VisibleForTesting
    @Nullable
    public static final CoroutineContext currentThreadContextOrNull() {
        CoroutineContext coroutineContext;
        boolean $i$f$currentThreadContextOrFallback = false;
        if (!Propagation.getUseImplicitBlockingContext()) {
            coroutineContext = tlCoroutineContext.get().getContext();
        } else {
            CoroutineContext suspendingContext$iv = IntellijCoroutines.INSTANCE.currentThreadCoroutineContext();
            InstalledThreadContext installedThreadContext = tlCoroutineContext.get();
            CoroutineContext snapshot$iv = installedThreadContext.component1();
            CoroutineContext overridingContext$iv = installedThreadContext.component2();
            if (suspendingContext$iv == snapshot$iv) {
                coroutineContext = overridingContext$iv;
            } else {
                CoroutineContext it = suspendingContext$iv;
                boolean bl2 = false;
                coroutineContext = null;
            }
        }
        return coroutineContext;
    }

    @NotNull
    public static final CoroutineContext currentThreadContext() {
        CoroutineContext coroutineContext;
        ThreadContext.checkContextInstalled();
        boolean $i$f$currentThreadContextOrFallback = false;
        if (!Propagation.getUseImplicitBlockingContext()) {
            coroutineContext = tlCoroutineContext.get().getContext();
        } else {
            CoroutineContext suspendingContext$iv = IntellijCoroutines.INSTANCE.currentThreadCoroutineContext();
            InstalledThreadContext installedThreadContext = tlCoroutineContext.get();
            CoroutineContext snapshot$iv = installedThreadContext.component1();
            CoroutineContext overridingContext$iv = installedThreadContext.component2();
            if (suspendingContext$iv == snapshot$iv) {
                coroutineContext = overridingContext$iv;
            } else {
                CoroutineContext it = suspendingContext$iv;
                boolean bl2 = false;
                CoroutineContext coroutineContext2 = it;
                coroutineContext = coroutineContext2 != null ? coroutineContext2.minusKey(ContinuationInterceptor.Key) : null;
            }
        }
        CoroutineContext coroutineContext3 = coroutineContext;
        if (coroutineContext == null) {
            coroutineContext3 = EmptyCoroutineContext.INSTANCE;
        }
        return coroutineContext3;
    }

    private static final void checkContextInstalled() {
        if (Propagation.isCheckContextAssertions() && LoadingState.APP_STARTED.isOccurred()) {
            CoroutineContext coroutineContext;
            boolean $i$f$currentThreadContextOrFallback = false;
            if (!Propagation.getUseImplicitBlockingContext()) {
                coroutineContext = tlCoroutineContext.get().getContext();
            } else {
                CoroutineContext suspendingContext$iv = IntellijCoroutines.INSTANCE.currentThreadCoroutineContext();
                InstalledThreadContext installedThreadContext = tlCoroutineContext.get();
                CoroutineContext snapshot$iv = installedThreadContext.component1();
                CoroutineContext overridingContext$iv = installedThreadContext.component2();
                if (suspendingContext$iv == snapshot$iv) {
                    coroutineContext = overridingContext$iv;
                } else {
                    CoroutineContext it = suspendingContext$iv;
                    boolean bl2 = false;
                    coroutineContext = it;
                }
            }
            if (coroutineContext == null && !ThreadContext.isKnownViolator()) {
                LOG.warn("Missing thread context", new Throwable());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isKnownViolator() {
        boolean bl2;
        block8: {
            void $this$mapTo$iv$iv;
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "getStackTrace(...)");
            Object[] $this$map$iv = stackTraceElementArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getClassName() + '.' + it.getMethodName());
            }
            List stackTrace = (List)destination$iv$iv;
            Iterable $this$any$iv = VIOLATORS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl4;
                    block7: {
                        String badTrace = (String)element$iv;
                        boolean bl5 = false;
                        Iterable $this$any$iv2 = stackTrace;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String it = (String)element$iv2;
                                boolean bl6 = false;
                                if (!StringsKt.startsWith$default(it, badTrace, false, 2, null)) continue;
                                bl4 = true;
                                break block7;
                            }
                            bl4 = false;
                        }
                    }
                    if (!bl4) continue;
                    bl2 = true;
                    break block8;
                }
                bl2 = false;
            }
        }
        return bl2;
    }

    public static final void warnAccidentalCancellation() {
        if (!shouldWarnAccidentalCancellation) {
            return;
        }
        if (Cancellation.isInNonCancelableSection()) {
            return;
        }
        CoroutineContext kotlinCoroutineContext = IntellijCoroutines.INSTANCE.currentThreadCoroutineContext();
        CoroutineContext snapshot = tlCoroutineContext.get().component1();
        if (snapshot == kotlinCoroutineContext) {
            return;
        }
        CoroutineContext coroutineContext = kotlinCoroutineContext;
        boolean bl2 = coroutineContext != null && (coroutineContext = (Job)coroutineContext.get(Job.Key)) != null ? !coroutineContext.isActive() : false;
        if (bl2) {
            LOG.warn("Detected a cancellation in an implicit non-cancellable section.\nThe code executing here will be aborted because of cancellation.\nIf this behavior is unexpected, please consult the documentation for com.intellij.concurrency.ThreadContext.warnAccidentalCancellation.", new Throwable("Querying stacktrace"));
        }
    }

    @NotNull
    public static final AccessToken resetThreadContext() {
        return ThreadContext.withThreadLocal(tlCoroutineContext, resetThreadContext.1.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Experimental
    public static final <T> T escapeCancellation(@NotNull Job job, @NotNull Function0<? extends T> action) {
        T t2;
        Intrinsics.checkNotNullParameter(job, "job");
        Intrinsics.checkNotNullParameter(action, "action");
        AutoCloseable autoCloseable = ThreadContext.installThreadContext(ThreadContext.currentThreadContext().plus(job).plus(new BlockingJob(job)), true);
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl2 = false;
            t2 = action.invoke();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return t2;
    }

    @NotNull
    public static final AccessToken installThreadContext(@NotNull CoroutineContext coroutineContext, boolean replace) {
        Intrinsics.checkNotNullParameter(coroutineContext, "coroutineContext");
        return ThreadContext.withThreadLocal(tlCoroutineContext, (Function1)new Function1<InstalledThreadContext, InstalledThreadContext>(replace, coroutineContext){
            final /* synthetic */ boolean $replace;
            final /* synthetic */ CoroutineContext $coroutineContext;
            {
                this.$replace = $replace;
                this.$coroutineContext = $coroutineContext;
                super(1);
            }

            @NotNull
            public final InstalledThreadContext invoke(@NotNull InstalledThreadContext previousContext) {
                Intrinsics.checkNotNullParameter(previousContext, "previousContext");
                CoroutineContext currentSnapshot = IntellijCoroutines.INSTANCE.currentThreadCoroutineContext();
                if (!this.$replace && previousContext.getSnapshot() == currentSnapshot && previousContext.getContext() != null) {
                    ThreadContext.access$getLOG$p().error("Thread context was already set: " + previousContext + ". \n Most likely, you are using 'runBlocking' instead of 'runBlockingCancellable' somewhere in the asynchronous stack.");
                }
                return new InstalledThreadContext(currentSnapshot, this.$coroutineContext);
            }
        });
    }

    public static /* synthetic */ AccessToken installThreadContext$default(CoroutineContext coroutineContext, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        return ThreadContext.installThreadContext(coroutineContext, bl2);
    }

    @ApiStatus.Internal
    @Nullable
    public static final CoroutineContext currentTemporaryThreadContextOrNull() {
        return tlTemporaryContext.get();
    }

    @ApiStatus.Internal
    @NotNull
    public static final AccessToken installTemporaryThreadContext(@NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter(coroutineContext, "coroutineContext");
        return ThreadContext.withThreadLocal(tlTemporaryContext, (Function1)new Function1<CoroutineContext, CoroutineContext>(coroutineContext){
            final /* synthetic */ CoroutineContext $coroutineContext;
            {
                this.$coroutineContext = $coroutineContext;
                super(1);
            }

            @Nullable
            public final CoroutineContext invoke(@Nullable CoroutineContext coroutineContext) {
                return this.$coroutineContext;
            }
        });
    }

    @ApiStatus.Internal
    @NotNull
    public static final <T> AccessToken withThreadLocal(@NotNull ThreadLocal<T> variable, @NotNull Function1<? super T, ? extends T> update) {
        Intrinsics.checkNotNullParameter(variable, "variable");
        Intrinsics.checkNotNullParameter(update, "update");
        T previousValue = variable.get();
        T newValue = update.invoke(previousValue);
        if (newValue == previousValue) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            Intrinsics.checkNotNullExpressionValue(accessToken, "EMPTY_ACCESS_TOKEN");
            return accessToken;
        }
        variable.set(newValue);
        return new AccessToken(variable, previousValue, newValue){
            final /* synthetic */ ThreadLocal<T> $variable;
            final /* synthetic */ T $previousValue;
            final /* synthetic */ T $newValue;
            {
                this.$variable = $variable;
                this.$previousValue = $previousValue;
                this.$newValue = $newValue;
            }

            public void finish() {
                T currentValue = this.$variable.get();
                this.$variable.set(this.$previousValue);
                boolean bl2 = currentValue == this.$newValue;
                T t2 = this.$newValue;
                if (!bl2) {
                    boolean bl3 = false;
                    String string2 = "Value was not reset correctly. Expected: " + t2 + ", actual: " + currentValue;
                    throw new IllegalStateException(string2.toString());
                }
            }
        };
    }

    @NotNull
    public static final Runnable captureThreadContext(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        return Propagation.captureRunnableThreadContext(runnable);
    }

    @NotNull
    public static final <T> Supplier<T> captureThreadContext(@NotNull Supplier<T> s2) {
        Intrinsics.checkNotNullParameter(s2, "s");
        Callable<Object> c2 = Propagation.captureCallableThreadContext(s2::get);
        return c2::call;
    }

    @NotNull
    public static final <T> Consumer<T> captureThreadContext(@NotNull Consumer<T> c2) {
        Intrinsics.checkNotNullParameter(c2, "c");
        Function<Object, Unit> f2 = Propagation.capturePropagationContext(p0$p0 -> {
            c2.accept(p0$p0);
            return Unit.INSTANCE;
        });
        return p0$p0 -> f2.apply(p0$p0);
    }

    @NotNull
    public static final <T, U> Function<T, U> captureThreadContext(@NotNull Function<T, U> f2) {
        Intrinsics.checkNotNullParameter(f2, "f");
        return Propagation.capturePropagationContext(f2);
    }

    @NotNull
    public static final Set<CoroutineContext.Element> getContextSkeleton(@NotNull CoroutineContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        ThreadContext.checkContextInstalled();
        return context.fold(new HashSet(), getContextSkeleton.1.INSTANCE);
    }

    @NotNull
    public static final <V> Callable<V> captureThreadContext(@NotNull Callable<V> callable) {
        Intrinsics.checkNotNullParameter(callable, "callable");
        return Propagation.captureCallableThreadContext(callable);
    }

    private static final InstalledThreadContext tlCoroutineContext$lambda$0() {
        return INITIAL_THREAD_CONTEXT;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance("#com.intellij.concurrency");
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
        INITIAL_THREAD_CONTEXT = new InstalledThreadContext(null, null);
        ThreadLocal<InstalledThreadContext> threadLocal = ThreadLocal.withInitial(ThreadContext::tlCoroutineContext$lambda$0);
        Intrinsics.checkNotNullExpressionValue(threadLocal, "withInitial(...)");
        tlCoroutineContext = threadLocal;
        String[] stringArray = new String[]{"com.intellij.diagnostic", "com.intellij.openapi.wm.impl", "com.intellij.model.SideEffectGuard", "com.intellij.openapi.editor.impl", "com.intellij.ui.components", "com.intellij.openapi.progress.util", "com.intellij.openapi.application.impl.NonBlockingReadActionImpl$Submission.reschedule", "com.intellij.openapi.keymap.impl.SystemShortcuts", "com.intellij.ide.IdeKeyboardFocusManager", "com.intellij.execution.process.ProcessIOExecutorService", "com.intellij.util.animation", "com.intellij.util.ui", "com.intellij.ide.ui.popup", "com.intellij.ui", "org.jetbrains.io", "com.intellij.javascript.webSymbols.nodejs.WebTypesNpmLoader", "com.intellij.tasks", "com.intellij.util.concurrency.Invoker", "com.intellij.openapi.application.constraints", "com.intellij.openapi.actionSystem", "org.jetbrains.idea.maven.server", "com.intellij.internal.statistic", "com.intellij.openapi.diagnostic.Logger", "com.intellij.openapi.extensions.impl.ExtensionPointImpl.getExtensionList", "com.intellij.openapi.extensions.impl.ExtensionPointImpl.getExtensions", "com.intellij.serviceContainer.LazyExtensionInstance.createInstance", "com.intellij.ui.icons", "com.intellij.ui.tree", "com.intellij.openapi.project.SmartModeScheduler.onStateChanged", "javax.swing.JComponent.paint", "com.intellij.openapi.application.impl.LaterInvocator.leaveModal", "com.intellij.openapi.application.impl.LaterInvocator.invokeAndWait", "com.intellij.util.animation.JBAnimator.animate", "com.intellij.util.messages.impl.SimpleMessageBusConnectionImpl.disconnect", "com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl.scheduleUpdateRunnable", "com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl.stopProcess", "com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl", "com.intellij.openapi.wm.impl.WindowCloseListener.windowClosing", "com.intellij.ide.ApplicationActivationStateManager.updateState", "com.intellij.openapi.util.io.GentleFlusherBase"};
        VIOLATORS = CollectionsKt.listOf(stringArray);
        shouldWarnAccidentalCancellation = SystemProperties.getBooleanProperty("ide.warn.accidental.cancellation", false);
        tlTemporaryContext = new ThreadLocal();
    }
}

